/*
 * dotnet/FileSystemBase+Const.cs
 *
 * Copyright 2015-2022 Bill Zissimopoulos
 */
/*
 * This file is part of WinFsp.
 *
 * You can redistribute it and/or modify it under the terms of the GNU
 * General Public License version 3 as published by the Free Software
 * Foundation.
 *
 * Licensees holding a valid commercial license may use this software
 * in accordance with the commercial license agreement provided in
 * conjunction with the software.  The terms and conditions of any such
 * commercial license agreement shall govern, supersede, and render
 * ineffective any application of the GPLv3 license to this software,
 * notwithstanding of any reference thereto in the software or
 * associated repository.
 */

using System;

namespace Fsp
{

    public partial class FileSystemBase
    {
        /* CreateOptions */
        public const UInt32 FILE_DIRECTORY_FILE = 0x00000001;
        public const UInt32 FILE_WRITE_THROUGH = 0x00000002;
        public const UInt32 FILE_SEQUENTIAL_ONLY = 0x00000004;
        public const UInt32 FILE_NO_INTERMEDIATE_BUFFERING = 0x00000008;
        public const UInt32 FILE_SYNCHRONOUS_IO_ALERT = 0x00000010;
        public const UInt32 FILE_SYNCHRONOUS_IO_NONALERT = 0x00000020;
        public const UInt32 FILE_NON_DIRECTORY_FILE = 0x00000040;
        public const UInt32 FILE_CREATE_TREE_CONNECTION = 0x00000080;
        public const UInt32 FILE_COMPLETE_IF_OPLOCKED = 0x00000100;
        public const UInt32 FILE_NO_EA_KNOWLEDGE = 0x00000200;
        public const UInt32 FILE_OPEN_REMOTE_INSTANCE = 0x00000400;
        public const UInt32 FILE_RANDOM_ACCESS = 0x00000800;
        public const UInt32 FILE_DELETE_ON_CLOSE = 0x00001000;
        public const UInt32 FILE_OPEN_BY_FILE_ID = 0x00002000;
        public const UInt32 FILE_OPEN_FOR_BACKUP_INTENT = 0x00004000;
        public const UInt32 FILE_NO_COMPRESSION = 0x00008000;
        public const UInt32 FILE_OPEN_REQUIRING_OPLOCK = 0x00010000;
        public const UInt32 FILE_RESERVE_OPFILTER = 0x00100000;
        public const UInt32 FILE_OPEN_REPARSE_POINT = 0x00200000;
        public const UInt32 FILE_OPEN_NO_RECALL = 0x00400000;
        public const UInt32 FILE_OPEN_FOR_FREE_SPACE_QUERY = 0x00800000;

        /* Cleanup */
        public const UInt32 CleanupDelete = 0x01;
        public const UInt32 CleanupSetAllocationSize = 0x02;
        public const UInt32 CleanupSetArchiveBit = 0x10;
        public const UInt32 CleanupSetLastAccessTime = 0x20;
        public const UInt32 CleanupSetLastWriteTime = 0x40;
        public const UInt32 CleanupSetChangeTime = 0x80;

        /* NTSTATUS */
        public const Int32 STATUS_SUCCESS = unchecked((Int32)0x00000000);
        public const Int32 STATUS_WAIT_1 = unchecked((Int32)0x00000001);
        public const Int32 STATUS_WAIT_2 = unchecked((Int32)0x00000002);
        public const Int32 STATUS_WAIT_3 = unchecked((Int32)0x00000003);
        public const Int32 STATUS_WAIT_63 = unchecked((Int32)0x0000003f);
        public const Int32 STATUS_ABANDONED = unchecked((Int32)0x00000080);
        public const Int32 STATUS_ABANDONED_WAIT_63 = unchecked((Int32)0x000000bf);
        public const Int32 STATUS_USER_APC = unchecked((Int32)0x000000c0);
        public const Int32 STATUS_KERNEL_APC = unchecked((Int32)0x00000100);
        public const Int32 STATUS_ALERTED = unchecked((Int32)0x00000101);
        public const Int32 STATUS_TIMEOUT = unchecked((Int32)0x00000102);
        public const Int32 STATUS_PENDING = unchecked((Int32)0x00000103);
        public const Int32 STATUS_REPARSE = unchecked((Int32)0x00000104);
        public const Int32 STATUS_MORE_ENTRIES = unchecked((Int32)0x00000105);
        public const Int32 STATUS_NOT_ALL_ASSIGNED = unchecked((Int32)0x00000106);
        public const Int32 STATUS_SOME_NOT_MAPPED = unchecked((Int32)0x00000107);
        public const Int32 STATUS_OPLOCK_BREAK_IN_PROGRESS = unchecked((Int32)0x00000108);
        public const Int32 STATUS_VOLUME_MOUNTED = unchecked((Int32)0x00000109);
        public const Int32 STATUS_RXACT_COMMITTED = unchecked((Int32)0x0000010a);
        public const Int32 STATUS_NOTIFY_CLEANUP = unchecked((Int32)0x0000010b);
        public const Int32 STATUS_NOTIFY_ENUM_DIR = unchecked((Int32)0x0000010c);
        public const Int32 STATUS_NO_QUOTAS_FOR_ACCOUNT = unchecked((Int32)0x0000010d);
        public const Int32 STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED = unchecked((Int32)0x0000010e);
        public const Int32 STATUS_PAGE_FAULT_TRANSITION = unchecked((Int32)0x00000110);
        public const Int32 STATUS_PAGE_FAULT_DEMAND_ZERO = unchecked((Int32)0x00000111);
        public const Int32 STATUS_PAGE_FAULT_COPY_ON_WRITE = unchecked((Int32)0x00000112);
        public const Int32 STATUS_PAGE_FAULT_GUARD_PAGE = unchecked((Int32)0x00000113);
        public const Int32 STATUS_PAGE_FAULT_PAGING_FILE = unchecked((Int32)0x00000114);
        public const Int32 STATUS_CACHE_PAGE_LOCKED = unchecked((Int32)0x00000115);
        public const Int32 STATUS_CRASH_DUMP = unchecked((Int32)0x00000116);
        public const Int32 STATUS_BUFFER_ALL_ZEROS = unchecked((Int32)0x00000117);
        public const Int32 STATUS_REPARSE_OBJECT = unchecked((Int32)0x00000118);
        public const Int32 STATUS_RESOURCE_REQUIREMENTS_CHANGED = unchecked((Int32)0x00000119);
        public const Int32 STATUS_TRANSLATION_COMPLETE = unchecked((Int32)0x00000120);
        public const Int32 STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY = unchecked((Int32)0x00000121);
        public const Int32 STATUS_NOTHING_TO_TERMINATE = unchecked((Int32)0x00000122);
        public const Int32 STATUS_PROCESS_NOT_IN_JOB = unchecked((Int32)0x00000123);
        public const Int32 STATUS_PROCESS_IN_JOB = unchecked((Int32)0x00000124);
        public const Int32 STATUS_VOLSNAP_HIBERNATE_READY = unchecked((Int32)0x00000125);
        public const Int32 STATUS_FSFILTER_OP_COMPLETED_SUCCESSFULLY = unchecked((Int32)0x00000126);
        public const Int32 STATUS_INTERRUPT_VECTOR_ALREADY_CONNECTED = unchecked((Int32)0x00000127);
        public const Int32 STATUS_INTERRUPT_STILL_CONNECTED = unchecked((Int32)0x00000128);
        public const Int32 STATUS_PROCESS_CLONED = unchecked((Int32)0x00000129);
        public const Int32 STATUS_FILE_LOCKED_WITH_ONLY_READERS = unchecked((Int32)0x0000012a);
        public const Int32 STATUS_FILE_LOCKED_WITH_WRITERS = unchecked((Int32)0x0000012b);
        public const Int32 STATUS_VALID_IMAGE_HASH = unchecked((Int32)0x0000012c);
        public const Int32 STATUS_VALID_CATALOG_HASH = unchecked((Int32)0x0000012d);
        public const Int32 STATUS_VALID_STRONG_CODE_HASH = unchecked((Int32)0x0000012e);
        public const Int32 STATUS_RESOURCEMANAGER_READ_ONLY = unchecked((Int32)0x00000202);
        public const Int32 STATUS_RING_PREVIOUSLY_EMPTY = unchecked((Int32)0x00000210);
        public const Int32 STATUS_RING_PREVIOUSLY_FULL = unchecked((Int32)0x00000211);
        public const Int32 STATUS_RING_PREVIOUSLY_ABOVE_QUOTA = unchecked((Int32)0x00000212);
        public const Int32 STATUS_RING_NEWLY_EMPTY = unchecked((Int32)0x00000213);
        public const Int32 STATUS_RING_SIGNAL_OPPOSITE_ENDPOINT = unchecked((Int32)0x00000214);
        public const Int32 STATUS_OPLOCK_SWITCHED_TO_NEW_HANDLE = unchecked((Int32)0x00000215);
        public const Int32 STATUS_OPLOCK_HANDLE_CLOSED = unchecked((Int32)0x00000216);
        public const Int32 STATUS_WAIT_FOR_OPLOCK = unchecked((Int32)0x00000367);
        public const Int32 STATUS_REPARSE_GLOBAL = unchecked((Int32)0x00000368);
        public const Int32 STATUS_FLT_IO_COMPLETE = unchecked((Int32)0x001c0001);
        public const Int32 STATUS_OBJECT_NAME_EXISTS = unchecked((Int32)0x40000000);
        public const Int32 STATUS_THREAD_WAS_SUSPENDED = unchecked((Int32)0x40000001);
        public const Int32 STATUS_WORKING_SET_LIMIT_RANGE = unchecked((Int32)0x40000002);
        public const Int32 STATUS_IMAGE_NOT_AT_BASE = unchecked((Int32)0x40000003);
        public const Int32 STATUS_RXACT_STATE_CREATED = unchecked((Int32)0x40000004);
        public const Int32 STATUS_SEGMENT_NOTIFICATION = unchecked((Int32)0x40000005);
        public const Int32 STATUS_LOCAL_USER_SESSION_KEY = unchecked((Int32)0x40000006);
        public const Int32 STATUS_BAD_CURRENT_DIRECTORY = unchecked((Int32)0x40000007);
        public const Int32 STATUS_SERIAL_MORE_WRITES = unchecked((Int32)0x40000008);
        public const Int32 STATUS_REGISTRY_RECOVERED = unchecked((Int32)0x40000009);
        public const Int32 STATUS_FT_READ_RECOVERY_FROM_BACKUP = unchecked((Int32)0x4000000a);
        public const Int32 STATUS_FT_WRITE_RECOVERY = unchecked((Int32)0x4000000b);
        public const Int32 STATUS_SERIAL_COUNTER_TIMEOUT = unchecked((Int32)0x4000000c);
        public const Int32 STATUS_NULL_LM_PASSWORD = unchecked((Int32)0x4000000d);
        public const Int32 STATUS_IMAGE_MACHINE_TYPE_MISMATCH = unchecked((Int32)0x4000000e);
        public const Int32 STATUS_RECEIVE_PARTIAL = unchecked((Int32)0x4000000f);
        public const Int32 STATUS_RECEIVE_EXPEDITED = unchecked((Int32)0x40000010);
        public const Int32 STATUS_RECEIVE_PARTIAL_EXPEDITED = unchecked((Int32)0x40000011);
        public const Int32 STATUS_EVENT_DONE = unchecked((Int32)0x40000012);
        public const Int32 STATUS_EVENT_PENDING = unchecked((Int32)0x40000013);
        public const Int32 STATUS_CHECKING_FILE_SYSTEM = unchecked((Int32)0x40000014);
        public const Int32 STATUS_FATAL_APP_EXIT = unchecked((Int32)0x40000015);
        public const Int32 STATUS_PREDEFINED_HANDLE = unchecked((Int32)0x40000016);
        public const Int32 STATUS_WAS_UNLOCKED = unchecked((Int32)0x40000017);
        public const Int32 STATUS_SERVICE_NOTIFICATION = unchecked((Int32)0x40000018);
        public const Int32 STATUS_WAS_LOCKED = unchecked((Int32)0x40000019);
        public const Int32 STATUS_LOG_HARD_ERROR = unchecked((Int32)0x4000001a);
        public const Int32 STATUS_ALREADY_WIN32 = unchecked((Int32)0x4000001b);
        public const Int32 STATUS_WX86_UNSIMULATE = unchecked((Int32)0x4000001c);
        public const Int32 STATUS_WX86_CONTINUE = unchecked((Int32)0x4000001d);
        public const Int32 STATUS_WX86_SINGLE_STEP = unchecked((Int32)0x4000001e);
        public const Int32 STATUS_WX86_BREAKPOINT = unchecked((Int32)0x4000001f);
        public const Int32 STATUS_WX86_EXCEPTION_CONTINUE = unchecked((Int32)0x40000020);
        public const Int32 STATUS_WX86_EXCEPTION_LASTCHANCE = unchecked((Int32)0x40000021);
        public const Int32 STATUS_WX86_EXCEPTION_CHAIN = unchecked((Int32)0x40000022);
        public const Int32 STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE = unchecked((Int32)0x40000023);
        public const Int32 STATUS_NO_YIELD_PERFORMED = unchecked((Int32)0x40000024);
        public const Int32 STATUS_TIMER_RESUME_IGNORED = unchecked((Int32)0x40000025);
        public const Int32 STATUS_ARBITRATION_UNHANDLED = unchecked((Int32)0x40000026);
        public const Int32 STATUS_CARDBUS_NOT_SUPPORTED = unchecked((Int32)0x40000027);
        public const Int32 STATUS_WX86_CREATEWX86TIB = unchecked((Int32)0x40000028);
        public const Int32 STATUS_MP_PROCESSOR_MISMATCH = unchecked((Int32)0x40000029);
        public const Int32 STATUS_HIBERNATED = unchecked((Int32)0x4000002a);
        public const Int32 STATUS_RESUME_HIBERNATION = unchecked((Int32)0x4000002b);
        public const Int32 STATUS_FIRMWARE_UPDATED = unchecked((Int32)0x4000002c);
        public const Int32 STATUS_DRIVERS_LEAKING_LOCKED_PAGES = unchecked((Int32)0x4000002d);
        public const Int32 STATUS_MESSAGE_RETRIEVED = unchecked((Int32)0x4000002e);
        public const Int32 STATUS_SYSTEM_POWERSTATE_TRANSITION = unchecked((Int32)0x4000002f);
        public const Int32 STATUS_ALPC_CHECK_COMPLETION_LIST = unchecked((Int32)0x40000030);
        public const Int32 STATUS_SYSTEM_POWERSTATE_COMPLEX_TRANSITION = unchecked((Int32)0x40000031);
        public const Int32 STATUS_ACCESS_AUDIT_BY_POLICY = unchecked((Int32)0x40000032);
        public const Int32 STATUS_ABANDON_HIBERFILE = unchecked((Int32)0x40000033);
        public const Int32 STATUS_BIZRULES_NOT_ENABLED = unchecked((Int32)0x40000034);
        public const Int32 STATUS_FT_READ_FROM_COPY = unchecked((Int32)0x40000035);
        public const Int32 STATUS_IMAGE_AT_DIFFERENT_BASE = unchecked((Int32)0x40000036);
        public const Int32 STATUS_HEURISTIC_DAMAGE_POSSIBLE = unchecked((Int32)0x40190001);
        public const Int32 STATUS_GUARD_PAGE_VIOLATION = unchecked((Int32)0x80000001);
        public const Int32 STATUS_DATATYPE_MISALIGNMENT = unchecked((Int32)0x80000002);
        public const Int32 STATUS_BREAKPOINT = unchecked((Int32)0x80000003);
        public const Int32 STATUS_SINGLE_STEP = unchecked((Int32)0x80000004);
        public const Int32 STATUS_BUFFER_OVERFLOW = unchecked((Int32)0x80000005);
        public const Int32 STATUS_NO_MORE_FILES = unchecked((Int32)0x80000006);
        public const Int32 STATUS_WAKE_SYSTEM_DEBUGGER = unchecked((Int32)0x80000007);
        public const Int32 STATUS_HANDLES_CLOSED = unchecked((Int32)0x8000000a);
        public const Int32 STATUS_NO_INHERITANCE = unchecked((Int32)0x8000000b);
        public const Int32 STATUS_GUID_SUBSTITUTION_MADE = unchecked((Int32)0x8000000c);
        public const Int32 STATUS_PARTIAL_COPY = unchecked((Int32)0x8000000d);
        public const Int32 STATUS_DEVICE_PAPER_EMPTY = unchecked((Int32)0x8000000e);
        public const Int32 STATUS_DEVICE_POWERED_OFF = unchecked((Int32)0x8000000f);
        public const Int32 STATUS_DEVICE_OFF_LINE = unchecked((Int32)0x80000010);
        public const Int32 STATUS_DEVICE_BUSY = unchecked((Int32)0x80000011);
        public const Int32 STATUS_NO_MORE_EAS = unchecked((Int32)0x80000012);
        public const Int32 STATUS_INVALID_EA_NAME = unchecked((Int32)0x80000013);
        public const Int32 STATUS_EA_LIST_INCONSISTENT = unchecked((Int32)0x80000014);
        public const Int32 STATUS_INVALID_EA_FLAG = unchecked((Int32)0x80000015);
        public const Int32 STATUS_VERIFY_REQUIRED = unchecked((Int32)0x80000016);
        public const Int32 STATUS_EXTRANEOUS_INFORMATION = unchecked((Int32)0x80000017);
        public const Int32 STATUS_RXACT_COMMIT_NECESSARY = unchecked((Int32)0x80000018);
        public const Int32 STATUS_NO_MORE_ENTRIES = unchecked((Int32)0x8000001a);
        public const Int32 STATUS_FILEMARK_DETECTED = unchecked((Int32)0x8000001b);
        public const Int32 STATUS_MEDIA_CHANGED = unchecked((Int32)0x8000001c);
        public const Int32 STATUS_BUS_RESET = unchecked((Int32)0x8000001d);
        public const Int32 STATUS_END_OF_MEDIA = unchecked((Int32)0x8000001e);
        public const Int32 STATUS_BEGINNING_OF_MEDIA = unchecked((Int32)0x8000001f);
        public const Int32 STATUS_MEDIA_CHECK = unchecked((Int32)0x80000020);
        public const Int32 STATUS_SETMARK_DETECTED = unchecked((Int32)0x80000021);
        public const Int32 STATUS_NO_DATA_DETECTED = unchecked((Int32)0x80000022);
        public const Int32 STATUS_REDIRECTOR_HAS_OPEN_HANDLES = unchecked((Int32)0x80000023);
        public const Int32 STATUS_SERVER_HAS_OPEN_HANDLES = unchecked((Int32)0x80000024);
        public const Int32 STATUS_ALREADY_DISCONNECTED = unchecked((Int32)0x80000025);
        public const Int32 STATUS_LONGJUMP = unchecked((Int32)0x80000026);
        public const Int32 STATUS_CLEANER_CARTRIDGE_INSTALLED = unchecked((Int32)0x80000027);
        public const Int32 STATUS_PLUGPLAY_QUERY_VETOED = unchecked((Int32)0x80000028);
        public const Int32 STATUS_UNWIND_CONSOLIDATE = unchecked((Int32)0x80000029);
        public const Int32 STATUS_REGISTRY_HIVE_RECOVERED = unchecked((Int32)0x8000002a);
        public const Int32 STATUS_DLL_MIGHT_BE_INSECURE = unchecked((Int32)0x8000002b);
        public const Int32 STATUS_DLL_MIGHT_BE_INCOMPATIBLE = unchecked((Int32)0x8000002c);
        public const Int32 STATUS_STOPPED_ON_SYMLINK = unchecked((Int32)0x8000002d);
        public const Int32 STATUS_CANNOT_GRANT_REQUESTED_OPLOCK = unchecked((Int32)0x8000002e);
        public const Int32 STATUS_NO_ACE_CONDITION = unchecked((Int32)0x8000002f);
        public const Int32 STATUS_DEVICE_SUPPORT_IN_PROGRESS = unchecked((Int32)0x80000030);
        public const Int32 STATUS_DEVICE_POWER_CYCLE_REQUIRED = unchecked((Int32)0x80000031);
        public const Int32 STATUS_CLUSTER_NODE_ALREADY_UP = unchecked((Int32)0x80130001);
        public const Int32 STATUS_CLUSTER_NODE_ALREADY_DOWN = unchecked((Int32)0x80130002);
        public const Int32 STATUS_CLUSTER_NETWORK_ALREADY_ONLINE = unchecked((Int32)0x80130003);
        public const Int32 STATUS_CLUSTER_NETWORK_ALREADY_OFFLINE = unchecked((Int32)0x80130004);
        public const Int32 STATUS_CLUSTER_NODE_ALREADY_MEMBER = unchecked((Int32)0x80130005);
        public const Int32 STATUS_FLT_BUFFER_TOO_SMALL = unchecked((Int32)0x801c0001);
        public const Int32 STATUS_FVE_PARTIAL_METADATA = unchecked((Int32)0x80210001);
        public const Int32 STATUS_FVE_TRANSIENT_STATE = unchecked((Int32)0x80210002);
        public const Int32 STATUS_UNSUCCESSFUL = unchecked((Int32)0xc0000001);
        public const Int32 STATUS_NOT_IMPLEMENTED = unchecked((Int32)0xc0000002);
        public const Int32 STATUS_INVALID_INFO_CLASS = unchecked((Int32)0xc0000003);
        public const Int32 STATUS_INFO_LENGTH_MISMATCH = unchecked((Int32)0xc0000004);
        public const Int32 STATUS_ACCESS_VIOLATION = unchecked((Int32)0xc0000005);
        public const Int32 STATUS_IN_PAGE_ERROR = unchecked((Int32)0xc0000006);
        public const Int32 STATUS_PAGEFILE_QUOTA = unchecked((Int32)0xc0000007);
        public const Int32 STATUS_INVALID_HANDLE = unchecked((Int32)0xc0000008);
        public const Int32 STATUS_BAD_INITIAL_STACK = unchecked((Int32)0xc0000009);
        public const Int32 STATUS_BAD_INITIAL_PC = unchecked((Int32)0xc000000a);
        public const Int32 STATUS_INVALID_CID = unchecked((Int32)0xc000000b);
        public const Int32 STATUS_TIMER_NOT_CANCELED = unchecked((Int32)0xc000000c);
        public const Int32 STATUS_INVALID_PARAMETER = unchecked((Int32)0xc000000d);
        public const Int32 STATUS_NO_SUCH_DEVICE = unchecked((Int32)0xc000000e);
        public const Int32 STATUS_NO_SUCH_FILE = unchecked((Int32)0xc000000f);
        public const Int32 STATUS_INVALID_DEVICE_REQUEST = unchecked((Int32)0xc0000010);
        public const Int32 STATUS_END_OF_FILE = unchecked((Int32)0xc0000011);
        public const Int32 STATUS_WRONG_VOLUME = unchecked((Int32)0xc0000012);
        public const Int32 STATUS_NO_MEDIA_IN_DEVICE = unchecked((Int32)0xc0000013);
        public const Int32 STATUS_UNRECOGNIZED_MEDIA = unchecked((Int32)0xc0000014);
        public const Int32 STATUS_NONEXISTENT_SECTOR = unchecked((Int32)0xc0000015);
        public const Int32 STATUS_MORE_PROCESSING_REQUIRED = unchecked((Int32)0xc0000016);
        public const Int32 STATUS_NO_MEMORY = unchecked((Int32)0xc0000017);
        public const Int32 STATUS_CONFLICTING_ADDRESSES = unchecked((Int32)0xc0000018);
        public const Int32 STATUS_NOT_MAPPED_VIEW = unchecked((Int32)0xc0000019);
        public const Int32 STATUS_UNABLE_TO_FREE_VM = unchecked((Int32)0xc000001a);
        public const Int32 STATUS_UNABLE_TO_DELETE_SECTION = unchecked((Int32)0xc000001b);
        public const Int32 STATUS_INVALID_SYSTEM_SERVICE = unchecked((Int32)0xc000001c);
        public const Int32 STATUS_ILLEGAL_INSTRUCTION = unchecked((Int32)0xc000001d);
        public const Int32 STATUS_INVALID_LOCK_SEQUENCE = unchecked((Int32)0xc000001e);
        public const Int32 STATUS_INVALID_VIEW_SIZE = unchecked((Int32)0xc000001f);
        public const Int32 STATUS_INVALID_FILE_FOR_SECTION = unchecked((Int32)0xc0000020);
        public const Int32 STATUS_ALREADY_COMMITTED = unchecked((Int32)0xc0000021);
        public const Int32 STATUS_ACCESS_DENIED = unchecked((Int32)0xc0000022);
        public const Int32 STATUS_BUFFER_TOO_SMALL = unchecked((Int32)0xc0000023);
        public const Int32 STATUS_OBJECT_TYPE_MISMATCH = unchecked((Int32)0xc0000024);
        public const Int32 STATUS_NONCONTINUABLE_EXCEPTION = unchecked((Int32)0xc0000025);
        public const Int32 STATUS_INVALID_DISPOSITION = unchecked((Int32)0xc0000026);
        public const Int32 STATUS_UNWIND = unchecked((Int32)0xc0000027);
        public const Int32 STATUS_BAD_STACK = unchecked((Int32)0xc0000028);
        public const Int32 STATUS_INVALID_UNWIND_TARGET = unchecked((Int32)0xc0000029);
        public const Int32 STATUS_NOT_LOCKED = unchecked((Int32)0xc000002a);
        public const Int32 STATUS_PARITY_ERROR = unchecked((Int32)0xc000002b);
        public const Int32 STATUS_UNABLE_TO_DECOMMIT_VM = unchecked((Int32)0xc000002c);
        public const Int32 STATUS_NOT_COMMITTED = unchecked((Int32)0xc000002d);
        public const Int32 STATUS_INVALID_PORT_ATTRIBUTES = unchecked((Int32)0xc000002e);
        public const Int32 STATUS_PORT_MESSAGE_TOO_LONG = unchecked((Int32)0xc000002f);
        public const Int32 STATUS_INVALID_PARAMETER_MIX = unchecked((Int32)0xc0000030);
        public const Int32 STATUS_INVALID_QUOTA_LOWER = unchecked((Int32)0xc0000031);
        public const Int32 STATUS_DISK_CORRUPT_ERROR = unchecked((Int32)0xc0000032);
        public const Int32 STATUS_OBJECT_NAME_INVALID = unchecked((Int32)0xc0000033);
        public const Int32 STATUS_OBJECT_NAME_NOT_FOUND = unchecked((Int32)0xc0000034);
        public const Int32 STATUS_OBJECT_NAME_COLLISION = unchecked((Int32)0xc0000035);
        public const Int32 STATUS_PORT_DO_NOT_DISTURB = unchecked((Int32)0xc0000036);
        public const Int32 STATUS_PORT_DISCONNECTED = unchecked((Int32)0xc0000037);
        public const Int32 STATUS_DEVICE_ALREADY_ATTACHED = unchecked((Int32)0xc0000038);
        public const Int32 STATUS_OBJECT_PATH_INVALID = unchecked((Int32)0xc0000039);
        public const Int32 STATUS_OBJECT_PATH_NOT_FOUND = unchecked((Int32)0xc000003a);
        public const Int32 STATUS_OBJECT_PATH_SYNTAX_BAD = unchecked((Int32)0xc000003b);
        public const Int32 STATUS_DATA_OVERRUN = unchecked((Int32)0xc000003c);
        public const Int32 STATUS_DATA_LATE_ERROR = unchecked((Int32)0xc000003d);
        public const Int32 STATUS_DATA_ERROR = unchecked((Int32)0xc000003e);
        public const Int32 STATUS_CRC_ERROR = unchecked((Int32)0xc000003f);
        public const Int32 STATUS_SECTION_TOO_BIG = unchecked((Int32)0xc0000040);
        public const Int32 STATUS_PORT_CONNECTION_REFUSED = unchecked((Int32)0xc0000041);
        public const Int32 STATUS_INVALID_PORT_HANDLE = unchecked((Int32)0xc0000042);
        public const Int32 STATUS_SHARING_VIOLATION = unchecked((Int32)0xc0000043);
        public const Int32 STATUS_QUOTA_EXCEEDED = unchecked((Int32)0xc0000044);
        public const Int32 STATUS_INVALID_PAGE_PROTECTION = unchecked((Int32)0xc0000045);
        public const Int32 STATUS_MUTANT_NOT_OWNED = unchecked((Int32)0xc0000046);
        public const Int32 STATUS_SEMAPHORE_LIMIT_EXCEEDED = unchecked((Int32)0xc0000047);
        public const Int32 STATUS_PORT_ALREADY_SET = unchecked((Int32)0xc0000048);
        public const Int32 STATUS_SECTION_NOT_IMAGE = unchecked((Int32)0xc0000049);
        public const Int32 STATUS_SUSPEND_COUNT_EXCEEDED = unchecked((Int32)0xc000004a);
        public const Int32 STATUS_THREAD_IS_TERMINATING = unchecked((Int32)0xc000004b);
        public const Int32 STATUS_BAD_WORKING_SET_LIMIT = unchecked((Int32)0xc000004c);
        public const Int32 STATUS_INCOMPATIBLE_FILE_MAP = unchecked((Int32)0xc000004d);
        public const Int32 STATUS_SECTION_PROTECTION = unchecked((Int32)0xc000004e);
        public const Int32 STATUS_EAS_NOT_SUPPORTED = unchecked((Int32)0xc000004f);
        public const Int32 STATUS_EA_TOO_LARGE = unchecked((Int32)0xc0000050);
        public const Int32 STATUS_NONEXISTENT_EA_ENTRY = unchecked((Int32)0xc0000051);
        public const Int32 STATUS_NO_EAS_ON_FILE = unchecked((Int32)0xc0000052);
        public const Int32 STATUS_EA_CORRUPT_ERROR = unchecked((Int32)0xc0000053);
        public const Int32 STATUS_FILE_LOCK_CONFLICT = unchecked((Int32)0xc0000054);
        public const Int32 STATUS_LOCK_NOT_GRANTED = unchecked((Int32)0xc0000055);
        public const Int32 STATUS_DELETE_PENDING = unchecked((Int32)0xc0000056);
        public const Int32 STATUS_CTL_FILE_NOT_SUPPORTED = unchecked((Int32)0xc0000057);
        public const Int32 STATUS_UNKNOWN_REVISION = unchecked((Int32)0xc0000058);
        public const Int32 STATUS_REVISION_MISMATCH = unchecked((Int32)0xc0000059);
        public const Int32 STATUS_INVALID_OWNER = unchecked((Int32)0xc000005a);
        public const Int32 STATUS_INVALID_PRIMARY_GROUP = unchecked((Int32)0xc000005b);
        public const Int32 STATUS_NO_IMPERSONATION_TOKEN = unchecked((Int32)0xc000005c);
        public const Int32 STATUS_CANT_DISABLE_MANDATORY = unchecked((Int32)0xc000005d);
        public const Int32 STATUS_NO_LOGON_SERVERS = unchecked((Int32)0xc000005e);
        public const Int32 STATUS_NO_SUCH_LOGON_SESSION = unchecked((Int32)0xc000005f);
        public const Int32 STATUS_NO_SUCH_PRIVILEGE = unchecked((Int32)0xc0000060);
        public const Int32 STATUS_PRIVILEGE_NOT_HELD = unchecked((Int32)0xc0000061);
        public const Int32 STATUS_INVALID_ACCOUNT_NAME = unchecked((Int32)0xc0000062);
        public const Int32 STATUS_USER_EXISTS = unchecked((Int32)0xc0000063);
        public const Int32 STATUS_NO_SUCH_USER = unchecked((Int32)0xc0000064);
        public const Int32 STATUS_GROUP_EXISTS = unchecked((Int32)0xc0000065);
        public const Int32 STATUS_NO_SUCH_GROUP = unchecked((Int32)0xc0000066);
        public const Int32 STATUS_MEMBER_IN_GROUP = unchecked((Int32)0xc0000067);
        public const Int32 STATUS_MEMBER_NOT_IN_GROUP = unchecked((Int32)0xc0000068);
        public const Int32 STATUS_LAST_ADMIN = unchecked((Int32)0xc0000069);
        public const Int32 STATUS_WRONG_PASSWORD = unchecked((Int32)0xc000006a);
        public const Int32 STATUS_ILL_FORMED_PASSWORD = unchecked((Int32)0xc000006b);
        public const Int32 STATUS_PASSWORD_RESTRICTION = unchecked((Int32)0xc000006c);
        public const Int32 STATUS_LOGON_FAILURE = unchecked((Int32)0xc000006d);
        public const Int32 STATUS_ACCOUNT_RESTRICTION = unchecked((Int32)0xc000006e);
        public const Int32 STATUS_INVALID_LOGON_HOURS = unchecked((Int32)0xc000006f);
        public const Int32 STATUS_INVALID_WORKSTATION = unchecked((Int32)0xc0000070);
        public const Int32 STATUS_PASSWORD_EXPIRED = unchecked((Int32)0xc0000071);
        public const Int32 STATUS_ACCOUNT_DISABLED = unchecked((Int32)0xc0000072);
        public const Int32 STATUS_NONE_MAPPED = unchecked((Int32)0xc0000073);
        public const Int32 STATUS_TOO_MANY_LUIDS_REQUESTED = unchecked((Int32)0xc0000074);
        public const Int32 STATUS_LUIDS_EXHAUSTED = unchecked((Int32)0xc0000075);
        public const Int32 STATUS_INVALID_SUB_AUTHORITY = unchecked((Int32)0xc0000076);
        public const Int32 STATUS_INVALID_ACL = unchecked((Int32)0xc0000077);
        public const Int32 STATUS_INVALID_SID = unchecked((Int32)0xc0000078);
        public const Int32 STATUS_INVALID_SECURITY_DESCR = unchecked((Int32)0xc0000079);
        public const Int32 STATUS_PROCEDURE_NOT_FOUND = unchecked((Int32)0xc000007a);
        public const Int32 STATUS_INVALID_IMAGE_FORMAT = unchecked((Int32)0xc000007b);
        public const Int32 STATUS_NO_TOKEN = unchecked((Int32)0xc000007c);
        public const Int32 STATUS_BAD_INHERITANCE_ACL = unchecked((Int32)0xc000007d);
        public const Int32 STATUS_RANGE_NOT_LOCKED = unchecked((Int32)0xc000007e);
        public const Int32 STATUS_DISK_FULL = unchecked((Int32)0xc000007f);
        public const Int32 STATUS_SERVER_DISABLED = unchecked((Int32)0xc0000080);
        public const Int32 STATUS_SERVER_NOT_DISABLED = unchecked((Int32)0xc0000081);
        public const Int32 STATUS_TOO_MANY_GUIDS_REQUESTED = unchecked((Int32)0xc0000082);
        public const Int32 STATUS_GUIDS_EXHAUSTED = unchecked((Int32)0xc0000083);
        public const Int32 STATUS_INVALID_ID_AUTHORITY = unchecked((Int32)0xc0000084);
        public const Int32 STATUS_AGENTS_EXHAUSTED = unchecked((Int32)0xc0000085);
        public const Int32 STATUS_INVALID_VOLUME_LABEL = unchecked((Int32)0xc0000086);
        public const Int32 STATUS_SECTION_NOT_EXTENDED = unchecked((Int32)0xc0000087);
        public const Int32 STATUS_NOT_MAPPED_DATA = unchecked((Int32)0xc0000088);
        public const Int32 STATUS_RESOURCE_DATA_NOT_FOUND = unchecked((Int32)0xc0000089);
        public const Int32 STATUS_RESOURCE_TYPE_NOT_FOUND = unchecked((Int32)0xc000008a);
        public const Int32 STATUS_RESOURCE_NAME_NOT_FOUND = unchecked((Int32)0xc000008b);
        public const Int32 STATUS_ARRAY_BOUNDS_EXCEEDED = unchecked((Int32)0xc000008c);
        public const Int32 STATUS_FLOAT_DENORMAL_OPERAND = unchecked((Int32)0xc000008d);
        public const Int32 STATUS_FLOAT_DIVIDE_BY_ZERO = unchecked((Int32)0xc000008e);
        public const Int32 STATUS_FLOAT_INEXACT_RESULT = unchecked((Int32)0xc000008f);
        public const Int32 STATUS_FLOAT_INVALID_OPERATION = unchecked((Int32)0xc0000090);
        public const Int32 STATUS_FLOAT_OVERFLOW = unchecked((Int32)0xc0000091);
        public const Int32 STATUS_FLOAT_STACK_CHECK = unchecked((Int32)0xc0000092);
        public const Int32 STATUS_FLOAT_UNDERFLOW = unchecked((Int32)0xc0000093);
        public const Int32 STATUS_INTEGER_DIVIDE_BY_ZERO = unchecked((Int32)0xc0000094);
        public const Int32 STATUS_INTEGER_OVERFLOW = unchecked((Int32)0xc0000095);
        public const Int32 STATUS_PRIVILEGED_INSTRUCTION = unchecked((Int32)0xc0000096);
        public const Int32 STATUS_TOO_MANY_PAGING_FILES = unchecked((Int32)0xc0000097);
        public const Int32 STATUS_FILE_INVALID = unchecked((Int32)0xc0000098);
        public const Int32 STATUS_ALLOTTED_SPACE_EXCEEDED = unchecked((Int32)0xc0000099);
        public const Int32 STATUS_INSUFFICIENT_RESOURCES = unchecked((Int32)0xc000009a);
        public const Int32 STATUS_DFS_EXIT_PATH_FOUND = unchecked((Int32)0xc000009b);
        public const Int32 STATUS_DEVICE_DATA_ERROR = unchecked((Int32)0xc000009c);
        public const Int32 STATUS_DEVICE_NOT_CONNECTED = unchecked((Int32)0xc000009d);
        public const Int32 STATUS_DEVICE_POWER_FAILURE = unchecked((Int32)0xc000009e);
        public const Int32 STATUS_FREE_VM_NOT_AT_BASE = unchecked((Int32)0xc000009f);
        public const Int32 STATUS_MEMORY_NOT_ALLOCATED = unchecked((Int32)0xc00000a0);
        public const Int32 STATUS_WORKING_SET_QUOTA = unchecked((Int32)0xc00000a1);
        public const Int32 STATUS_MEDIA_WRITE_PROTECTED = unchecked((Int32)0xc00000a2);
        public const Int32 STATUS_DEVICE_NOT_READY = unchecked((Int32)0xc00000a3);
        public const Int32 STATUS_INVALID_GROUP_ATTRIBUTES = unchecked((Int32)0xc00000a4);
        public const Int32 STATUS_BAD_IMPERSONATION_LEVEL = unchecked((Int32)0xc00000a5);
        public const Int32 STATUS_CANT_OPEN_ANONYMOUS = unchecked((Int32)0xc00000a6);
        public const Int32 STATUS_BAD_VALIDATION_CLASS = unchecked((Int32)0xc00000a7);
        public const Int32 STATUS_BAD_TOKEN_TYPE = unchecked((Int32)0xc00000a8);
        public const Int32 STATUS_BAD_MASTER_BOOT_RECORD = unchecked((Int32)0xc00000a9);
        public const Int32 STATUS_INSTRUCTION_MISALIGNMENT = unchecked((Int32)0xc00000aa);
        public const Int32 STATUS_INSTANCE_NOT_AVAILABLE = unchecked((Int32)0xc00000ab);
        public const Int32 STATUS_PIPE_NOT_AVAILABLE = unchecked((Int32)0xc00000ac);
        public const Int32 STATUS_INVALID_PIPE_STATE = unchecked((Int32)0xc00000ad);
        public const Int32 STATUS_PIPE_BUSY = unchecked((Int32)0xc00000ae);
        public const Int32 STATUS_ILLEGAL_FUNCTION = unchecked((Int32)0xc00000af);
        public const Int32 STATUS_PIPE_DISCONNECTED = unchecked((Int32)0xc00000b0);
        public const Int32 STATUS_PIPE_CLOSING = unchecked((Int32)0xc00000b1);
        public const Int32 STATUS_PIPE_CONNECTED = unchecked((Int32)0xc00000b2);
        public const Int32 STATUS_PIPE_LISTENING = unchecked((Int32)0xc00000b3);
        public const Int32 STATUS_INVALID_READ_MODE = unchecked((Int32)0xc00000b4);
        public const Int32 STATUS_IO_TIMEOUT = unchecked((Int32)0xc00000b5);
        public const Int32 STATUS_FILE_FORCED_CLOSED = unchecked((Int32)0xc00000b6);
        public const Int32 STATUS_PROFILING_NOT_STARTED = unchecked((Int32)0xc00000b7);
        public const Int32 STATUS_PROFILING_NOT_STOPPED = unchecked((Int32)0xc00000b8);
        public const Int32 STATUS_COULD_NOT_INTERPRET = unchecked((Int32)0xc00000b9);
        public const Int32 STATUS_FILE_IS_A_DIRECTORY = unchecked((Int32)0xc00000ba);
        public const Int32 STATUS_NOT_SUPPORTED = unchecked((Int32)0xc00000bb);
        public const Int32 STATUS_REMOTE_NOT_LISTENING = unchecked((Int32)0xc00000bc);
        public const Int32 STATUS_DUPLICATE_NAME = unchecked((Int32)0xc00000bd);
        public const Int32 STATUS_BAD_NETWORK_PATH = unchecked((Int32)0xc00000be);
        public const Int32 STATUS_NETWORK_BUSY = unchecked((Int32)0xc00000bf);
        public const Int32 STATUS_DEVICE_DOES_NOT_EXIST = unchecked((Int32)0xc00000c0);
        public const Int32 STATUS_TOO_MANY_COMMANDS = unchecked((Int32)0xc00000c1);
        public const Int32 STATUS_ADAPTER_HARDWARE_ERROR = unchecked((Int32)0xc00000c2);
        public const Int32 STATUS_INVALID_NETWORK_RESPONSE = unchecked((Int32)0xc00000c3);
        public const Int32 STATUS_UNEXPECTED_NETWORK_ERROR = unchecked((Int32)0xc00000c4);
        public const Int32 STATUS_BAD_REMOTE_ADAPTER = unchecked((Int32)0xc00000c5);
        public const Int32 STATUS_PRINT_QUEUE_FULL = unchecked((Int32)0xc00000c6);
        public const Int32 STATUS_NO_SPOOL_SPACE = unchecked((Int32)0xc00000c7);
        public const Int32 STATUS_PRINT_CANCELLED = unchecked((Int32)0xc00000c8);
        public const Int32 STATUS_NETWORK_NAME_DELETED = unchecked((Int32)0xc00000c9);
        public const Int32 STATUS_NETWORK_ACCESS_DENIED = unchecked((Int32)0xc00000ca);
        public const Int32 STATUS_BAD_DEVICE_TYPE = unchecked((Int32)0xc00000cb);
        public const Int32 STATUS_BAD_NETWORK_NAME = unchecked((Int32)0xc00000cc);
        public const Int32 STATUS_TOO_MANY_NAMES = unchecked((Int32)0xc00000cd);
        public const Int32 STATUS_TOO_MANY_SESSIONS = unchecked((Int32)0xc00000ce);
        public const Int32 STATUS_SHARING_PAUSED = unchecked((Int32)0xc00000cf);
        public const Int32 STATUS_REQUEST_NOT_ACCEPTED = unchecked((Int32)0xc00000d0);
        public const Int32 STATUS_REDIRECTOR_PAUSED = unchecked((Int32)0xc00000d1);
        public const Int32 STATUS_NET_WRITE_FAULT = unchecked((Int32)0xc00000d2);
        public const Int32 STATUS_PROFILING_AT_LIMIT = unchecked((Int32)0xc00000d3);
        public const Int32 STATUS_NOT_SAME_DEVICE = unchecked((Int32)0xc00000d4);
        public const Int32 STATUS_FILE_RENAMED = unchecked((Int32)0xc00000d5);
        public const Int32 STATUS_VIRTUAL_CIRCUIT_CLOSED = unchecked((Int32)0xc00000d6);
        public const Int32 STATUS_NO_SECURITY_ON_OBJECT = unchecked((Int32)0xc00000d7);
        public const Int32 STATUS_CANT_WAIT = unchecked((Int32)0xc00000d8);
        public const Int32 STATUS_PIPE_EMPTY = unchecked((Int32)0xc00000d9);
        public const Int32 STATUS_CANT_ACCESS_DOMAIN_INFO = unchecked((Int32)0xc00000da);
        public const Int32 STATUS_CANT_TERMINATE_SELF = unchecked((Int32)0xc00000db);
        public const Int32 STATUS_INVALID_SERVER_STATE = unchecked((Int32)0xc00000dc);
        public const Int32 STATUS_INVALID_DOMAIN_STATE = unchecked((Int32)0xc00000dd);
        public const Int32 STATUS_INVALID_DOMAIN_ROLE = unchecked((Int32)0xc00000de);
        public const Int32 STATUS_NO_SUCH_DOMAIN = unchecked((Int32)0xc00000df);
        public const Int32 STATUS_DOMAIN_EXISTS = unchecked((Int32)0xc00000e0);
        public const Int32 STATUS_DOMAIN_LIMIT_EXCEEDED = unchecked((Int32)0xc00000e1);
        public const Int32 STATUS_OPLOCK_NOT_GRANTED = unchecked((Int32)0xc00000e2);
        public const Int32 STATUS_INVALID_OPLOCK_PROTOCOL = unchecked((Int32)0xc00000e3);
        public const Int32 STATUS_INTERNAL_DB_CORRUPTION = unchecked((Int32)0xc00000e4);
        public const Int32 STATUS_INTERNAL_ERROR = unchecked((Int32)0xc00000e5);
        public const Int32 STATUS_GENERIC_NOT_MAPPED = unchecked((Int32)0xc00000e6);
        public const Int32 STATUS_BAD_DESCRIPTOR_FORMAT = unchecked((Int32)0xc00000e7);
        public const Int32 STATUS_INVALID_USER_BUFFER = unchecked((Int32)0xc00000e8);
        public const Int32 STATUS_UNEXPECTED_IO_ERROR = unchecked((Int32)0xc00000e9);
        public const Int32 STATUS_UNEXPECTED_MM_CREATE_ERR = unchecked((Int32)0xc00000ea);
        public const Int32 STATUS_UNEXPECTED_MM_MAP_ERROR = unchecked((Int32)0xc00000eb);
        public const Int32 STATUS_UNEXPECTED_MM_EXTEND_ERR = unchecked((Int32)0xc00000ec);
        public const Int32 STATUS_NOT_LOGON_PROCESS = unchecked((Int32)0xc00000ed);
        public const Int32 STATUS_LOGON_SESSION_EXISTS = unchecked((Int32)0xc00000ee);
        public const Int32 STATUS_INVALID_PARAMETER_1 = unchecked((Int32)0xc00000ef);
        public const Int32 STATUS_INVALID_PARAMETER_2 = unchecked((Int32)0xc00000f0);
        public const Int32 STATUS_INVALID_PARAMETER_3 = unchecked((Int32)0xc00000f1);
        public const Int32 STATUS_INVALID_PARAMETER_4 = unchecked((Int32)0xc00000f2);
        public const Int32 STATUS_INVALID_PARAMETER_5 = unchecked((Int32)0xc00000f3);
        public const Int32 STATUS_INVALID_PARAMETER_6 = unchecked((Int32)0xc00000f4);
        public const Int32 STATUS_INVALID_PARAMETER_7 = unchecked((Int32)0xc00000f5);
        public const Int32 STATUS_INVALID_PARAMETER_8 = unchecked((Int32)0xc00000f6);
        public const Int32 STATUS_INVALID_PARAMETER_9 = unchecked((Int32)0xc00000f7);
        public const Int32 STATUS_INVALID_PARAMETER_10 = unchecked((Int32)0xc00000f8);
        public const Int32 STATUS_INVALID_PARAMETER_11 = unchecked((Int32)0xc00000f9);
        public const Int32 STATUS_INVALID_PARAMETER_12 = unchecked((Int32)0xc00000fa);
        public const Int32 STATUS_REDIRECTOR_NOT_STARTED = unchecked((Int32)0xc00000fb);
        public const Int32 STATUS_REDIRECTOR_STARTED = unchecked((Int32)0xc00000fc);
        public const Int32 STATUS_STACK_OVERFLOW = unchecked((Int32)0xc00000fd);
        public const Int32 STATUS_NO_SUCH_PACKAGE = unchecked((Int32)0xc00000fe);
        public const Int32 STATUS_BAD_FUNCTION_TABLE = unchecked((Int32)0xc00000ff);
        public const Int32 STATUS_VARIABLE_NOT_FOUND = unchecked((Int32)0xc0000100);
        public const Int32 STATUS_DIRECTORY_NOT_EMPTY = unchecked((Int32)0xc0000101);
        public const Int32 STATUS_FILE_CORRUPT_ERROR = unchecked((Int32)0xc0000102);
        public const Int32 STATUS_NOT_A_DIRECTORY = unchecked((Int32)0xc0000103);
        public const Int32 STATUS_BAD_LOGON_SESSION_STATE = unchecked((Int32)0xc0000104);
        public const Int32 STATUS_LOGON_SESSION_COLLISION = unchecked((Int32)0xc0000105);
        public const Int32 STATUS_NAME_TOO_LONG = unchecked((Int32)0xc0000106);
        public const Int32 STATUS_FILES_OPEN = unchecked((Int32)0xc0000107);
        public const Int32 STATUS_CONNECTION_IN_USE = unchecked((Int32)0xc0000108);
        public const Int32 STATUS_MESSAGE_NOT_FOUND = unchecked((Int32)0xc0000109);
        public const Int32 STATUS_PROCESS_IS_TERMINATING = unchecked((Int32)0xc000010a);
        public const Int32 STATUS_INVALID_LOGON_TYPE = unchecked((Int32)0xc000010b);
        public const Int32 STATUS_NO_GUID_TRANSLATION = unchecked((Int32)0xc000010c);
        public const Int32 STATUS_CANNOT_IMPERSONATE = unchecked((Int32)0xc000010d);
        public const Int32 STATUS_IMAGE_ALREADY_LOADED = unchecked((Int32)0xc000010e);
        public const Int32 STATUS_ABIOS_NOT_PRESENT = unchecked((Int32)0xc000010f);
        public const Int32 STATUS_ABIOS_LID_NOT_EXIST = unchecked((Int32)0xc0000110);
        public const Int32 STATUS_ABIOS_LID_ALREADY_OWNED = unchecked((Int32)0xc0000111);
        public const Int32 STATUS_ABIOS_NOT_LID_OWNER = unchecked((Int32)0xc0000112);
        public const Int32 STATUS_ABIOS_INVALID_COMMAND = unchecked((Int32)0xc0000113);
        public const Int32 STATUS_ABIOS_INVALID_LID = unchecked((Int32)0xc0000114);
        public const Int32 STATUS_ABIOS_SELECTOR_NOT_AVAILABLE = unchecked((Int32)0xc0000115);
        public const Int32 STATUS_ABIOS_INVALID_SELECTOR = unchecked((Int32)0xc0000116);
        public const Int32 STATUS_NO_LDT = unchecked((Int32)0xc0000117);
        public const Int32 STATUS_INVALID_LDT_SIZE = unchecked((Int32)0xc0000118);
        public const Int32 STATUS_INVALID_LDT_OFFSET = unchecked((Int32)0xc0000119);
        public const Int32 STATUS_INVALID_LDT_DESCRIPTOR = unchecked((Int32)0xc000011a);
        public const Int32 STATUS_INVALID_IMAGE_NE_FORMAT = unchecked((Int32)0xc000011b);
        public const Int32 STATUS_RXACT_INVALID_STATE = unchecked((Int32)0xc000011c);
        public const Int32 STATUS_RXACT_COMMIT_FAILURE = unchecked((Int32)0xc000011d);
        public const Int32 STATUS_MAPPED_FILE_SIZE_ZERO = unchecked((Int32)0xc000011e);
        public const Int32 STATUS_TOO_MANY_OPENED_FILES = unchecked((Int32)0xc000011f);
        public const Int32 STATUS_CANCELLED = unchecked((Int32)0xc0000120);
        public const Int32 STATUS_CANNOT_DELETE = unchecked((Int32)0xc0000121);
        public const Int32 STATUS_INVALID_COMPUTER_NAME = unchecked((Int32)0xc0000122);
        public const Int32 STATUS_FILE_DELETED = unchecked((Int32)0xc0000123);
        public const Int32 STATUS_SPECIAL_ACCOUNT = unchecked((Int32)0xc0000124);
        public const Int32 STATUS_SPECIAL_GROUP = unchecked((Int32)0xc0000125);
        public const Int32 STATUS_SPECIAL_USER = unchecked((Int32)0xc0000126);
        public const Int32 STATUS_MEMBERS_PRIMARY_GROUP = unchecked((Int32)0xc0000127);
        public const Int32 STATUS_FILE_CLOSED = unchecked((Int32)0xc0000128);
        public const Int32 STATUS_TOO_MANY_THREADS = unchecked((Int32)0xc0000129);
        public const Int32 STATUS_THREAD_NOT_IN_PROCESS = unchecked((Int32)0xc000012a);
        public const Int32 STATUS_TOKEN_ALREADY_IN_USE = unchecked((Int32)0xc000012b);
        public const Int32 STATUS_PAGEFILE_QUOTA_EXCEEDED = unchecked((Int32)0xc000012c);
        public const Int32 STATUS_COMMITMENT_LIMIT = unchecked((Int32)0xc000012d);
        public const Int32 STATUS_INVALID_IMAGE_LE_FORMAT = unchecked((Int32)0xc000012e);
        public const Int32 STATUS_INVALID_IMAGE_NOT_MZ = unchecked((Int32)0xc000012f);
        public const Int32 STATUS_INVALID_IMAGE_PROTECT = unchecked((Int32)0xc0000130);
        public const Int32 STATUS_INVALID_IMAGE_WIN_16 = unchecked((Int32)0xc0000131);
        public const Int32 STATUS_LOGON_SERVER_CONFLICT = unchecked((Int32)0xc0000132);
        public const Int32 STATUS_TIME_DIFFERENCE_AT_DC = unchecked((Int32)0xc0000133);
        public const Int32 STATUS_SYNCHRONIZATION_REQUIRED = unchecked((Int32)0xc0000134);
        public const Int32 STATUS_DLL_NOT_FOUND = unchecked((Int32)0xc0000135);
        public const Int32 STATUS_OPEN_FAILED = unchecked((Int32)0xc0000136);
        public const Int32 STATUS_IO_PRIVILEGE_FAILED = unchecked((Int32)0xc0000137);
        public const Int32 STATUS_ORDINAL_NOT_FOUND = unchecked((Int32)0xc0000138);
        public const Int32 STATUS_ENTRYPOINT_NOT_FOUND = unchecked((Int32)0xc0000139);
        public const Int32 STATUS_CONTROL_C_EXIT = unchecked((Int32)0xc000013a);
        public const Int32 STATUS_LOCAL_DISCONNECT = unchecked((Int32)0xc000013b);
        public const Int32 STATUS_REMOTE_DISCONNECT = unchecked((Int32)0xc000013c);
        public const Int32 STATUS_REMOTE_RESOURCES = unchecked((Int32)0xc000013d);
        public const Int32 STATUS_LINK_FAILED = unchecked((Int32)0xc000013e);
        public const Int32 STATUS_LINK_TIMEOUT = unchecked((Int32)0xc000013f);
        public const Int32 STATUS_INVALID_CONNECTION = unchecked((Int32)0xc0000140);
        public const Int32 STATUS_INVALID_ADDRESS = unchecked((Int32)0xc0000141);
        public const Int32 STATUS_DLL_INIT_FAILED = unchecked((Int32)0xc0000142);
        public const Int32 STATUS_MISSING_SYSTEMFILE = unchecked((Int32)0xc0000143);
        public const Int32 STATUS_UNHANDLED_EXCEPTION = unchecked((Int32)0xc0000144);
        public const Int32 STATUS_APP_INIT_FAILURE = unchecked((Int32)0xc0000145);
        public const Int32 STATUS_PAGEFILE_CREATE_FAILED = unchecked((Int32)0xc0000146);
        public const Int32 STATUS_NO_PAGEFILE = unchecked((Int32)0xc0000147);
        public const Int32 STATUS_INVALID_LEVEL = unchecked((Int32)0xc0000148);
        public const Int32 STATUS_WRONG_PASSWORD_CORE = unchecked((Int32)0xc0000149);
        public const Int32 STATUS_ILLEGAL_FLOAT_CONTEXT = unchecked((Int32)0xc000014a);
        public const Int32 STATUS_PIPE_BROKEN = unchecked((Int32)0xc000014b);
        public const Int32 STATUS_REGISTRY_CORRUPT = unchecked((Int32)0xc000014c);
        public const Int32 STATUS_REGISTRY_IO_FAILED = unchecked((Int32)0xc000014d);
        public const Int32 STATUS_NO_EVENT_PAIR = unchecked((Int32)0xc000014e);
        public const Int32 STATUS_UNRECOGNIZED_VOLUME = unchecked((Int32)0xc000014f);
        public const Int32 STATUS_SERIAL_NO_DEVICE_INITED = unchecked((Int32)0xc0000150);
        public const Int32 STATUS_NO_SUCH_ALIAS = unchecked((Int32)0xc0000151);
        public const Int32 STATUS_MEMBER_NOT_IN_ALIAS = unchecked((Int32)0xc0000152);
        public const Int32 STATUS_MEMBER_IN_ALIAS = unchecked((Int32)0xc0000153);
        public const Int32 STATUS_ALIAS_EXISTS = unchecked((Int32)0xc0000154);
        public const Int32 STATUS_LOGON_NOT_GRANTED = unchecked((Int32)0xc0000155);
        public const Int32 STATUS_TOO_MANY_SECRETS = unchecked((Int32)0xc0000156);
        public const Int32 STATUS_SECRET_TOO_LONG = unchecked((Int32)0xc0000157);
        public const Int32 STATUS_INTERNAL_DB_ERROR = unchecked((Int32)0xc0000158);
        public const Int32 STATUS_FULLSCREEN_MODE = unchecked((Int32)0xc0000159);
        public const Int32 STATUS_TOO_MANY_CONTEXT_IDS = unchecked((Int32)0xc000015a);
        public const Int32 STATUS_LOGON_TYPE_NOT_GRANTED = unchecked((Int32)0xc000015b);
        public const Int32 STATUS_NOT_REGISTRY_FILE = unchecked((Int32)0xc000015c);
        public const Int32 STATUS_NT_CROSS_ENCRYPTION_REQUIRED = unchecked((Int32)0xc000015d);
        public const Int32 STATUS_DOMAIN_CTRLR_CONFIG_ERROR = unchecked((Int32)0xc000015e);
        public const Int32 STATUS_FT_MISSING_MEMBER = unchecked((Int32)0xc000015f);
        public const Int32 STATUS_ILL_FORMED_SERVICE_ENTRY = unchecked((Int32)0xc0000160);
        public const Int32 STATUS_ILLEGAL_CHARACTER = unchecked((Int32)0xc0000161);
        public const Int32 STATUS_UNMAPPABLE_CHARACTER = unchecked((Int32)0xc0000162);
        public const Int32 STATUS_UNDEFINED_CHARACTER = unchecked((Int32)0xc0000163);
        public const Int32 STATUS_FLOPPY_VOLUME = unchecked((Int32)0xc0000164);
        public const Int32 STATUS_FLOPPY_ID_MARK_NOT_FOUND = unchecked((Int32)0xc0000165);
        public const Int32 STATUS_FLOPPY_WRONG_CYLINDER = unchecked((Int32)0xc0000166);
        public const Int32 STATUS_FLOPPY_UNKNOWN_ERROR = unchecked((Int32)0xc0000167);
        public const Int32 STATUS_FLOPPY_BAD_REGISTERS = unchecked((Int32)0xc0000168);
        public const Int32 STATUS_DISK_RECALIBRATE_FAILED = unchecked((Int32)0xc0000169);
        public const Int32 STATUS_DISK_OPERATION_FAILED = unchecked((Int32)0xc000016a);
        public const Int32 STATUS_DISK_RESET_FAILED = unchecked((Int32)0xc000016b);
        public const Int32 STATUS_SHARED_IRQ_BUSY = unchecked((Int32)0xc000016c);
        public const Int32 STATUS_FT_ORPHANING = unchecked((Int32)0xc000016d);
        public const Int32 STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT = unchecked((Int32)0xc000016e);
        public const Int32 STATUS_PARTITION_FAILURE = unchecked((Int32)0xc0000172);
        public const Int32 STATUS_INVALID_BLOCK_LENGTH = unchecked((Int32)0xc0000173);
        public const Int32 STATUS_DEVICE_NOT_PARTITIONED = unchecked((Int32)0xc0000174);
        public const Int32 STATUS_UNABLE_TO_LOCK_MEDIA = unchecked((Int32)0xc0000175);
        public const Int32 STATUS_UNABLE_TO_UNLOAD_MEDIA = unchecked((Int32)0xc0000176);
        public const Int32 STATUS_EOM_OVERFLOW = unchecked((Int32)0xc0000177);
        public const Int32 STATUS_NO_MEDIA = unchecked((Int32)0xc0000178);
        public const Int32 STATUS_NO_SUCH_MEMBER = unchecked((Int32)0xc000017a);
        public const Int32 STATUS_INVALID_MEMBER = unchecked((Int32)0xc000017b);
        public const Int32 STATUS_KEY_DELETED = unchecked((Int32)0xc000017c);
        public const Int32 STATUS_NO_LOG_SPACE = unchecked((Int32)0xc000017d);
        public const Int32 STATUS_TOO_MANY_SIDS = unchecked((Int32)0xc000017e);
        public const Int32 STATUS_LM_CROSS_ENCRYPTION_REQUIRED = unchecked((Int32)0xc000017f);
        public const Int32 STATUS_KEY_HAS_CHILDREN = unchecked((Int32)0xc0000180);
        public const Int32 STATUS_CHILD_MUST_BE_VOLATILE = unchecked((Int32)0xc0000181);
        public const Int32 STATUS_DEVICE_CONFIGURATION_ERROR = unchecked((Int32)0xc0000182);
        public const Int32 STATUS_DRIVER_INTERNAL_ERROR = unchecked((Int32)0xc0000183);
        public const Int32 STATUS_INVALID_DEVICE_STATE = unchecked((Int32)0xc0000184);
        public const Int32 STATUS_IO_DEVICE_ERROR = unchecked((Int32)0xc0000185);
        public const Int32 STATUS_DEVICE_PROTOCOL_ERROR = unchecked((Int32)0xc0000186);
        public const Int32 STATUS_BACKUP_CONTROLLER = unchecked((Int32)0xc0000187);
        public const Int32 STATUS_LOG_FILE_FULL = unchecked((Int32)0xc0000188);
        public const Int32 STATUS_TOO_LATE = unchecked((Int32)0xc0000189);
        public const Int32 STATUS_NO_TRUST_LSA_SECRET = unchecked((Int32)0xc000018a);
        public const Int32 STATUS_NO_TRUST_SAM_ACCOUNT = unchecked((Int32)0xc000018b);
        public const Int32 STATUS_TRUSTED_DOMAIN_FAILURE = unchecked((Int32)0xc000018c);
        public const Int32 STATUS_TRUSTED_RELATIONSHIP_FAILURE = unchecked((Int32)0xc000018d);
        public const Int32 STATUS_EVENTLOG_FILE_CORRUPT = unchecked((Int32)0xc000018e);
        public const Int32 STATUS_EVENTLOG_CANT_START = unchecked((Int32)0xc000018f);
        public const Int32 STATUS_TRUST_FAILURE = unchecked((Int32)0xc0000190);
        public const Int32 STATUS_MUTANT_LIMIT_EXCEEDED = unchecked((Int32)0xc0000191);
        public const Int32 STATUS_NETLOGON_NOT_STARTED = unchecked((Int32)0xc0000192);
        public const Int32 STATUS_ACCOUNT_EXPIRED = unchecked((Int32)0xc0000193);
        public const Int32 STATUS_POSSIBLE_DEADLOCK = unchecked((Int32)0xc0000194);
        public const Int32 STATUS_NETWORK_CREDENTIAL_CONFLICT = unchecked((Int32)0xc0000195);
        public const Int32 STATUS_REMOTE_SESSION_LIMIT = unchecked((Int32)0xc0000196);
        public const Int32 STATUS_EVENTLOG_FILE_CHANGED = unchecked((Int32)0xc0000197);
        public const Int32 STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT = unchecked((Int32)0xc0000198);
        public const Int32 STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT = unchecked((Int32)0xc0000199);
        public const Int32 STATUS_NOLOGON_SERVER_TRUST_ACCOUNT = unchecked((Int32)0xc000019a);
        public const Int32 STATUS_DOMAIN_TRUST_INCONSISTENT = unchecked((Int32)0xc000019b);
        public const Int32 STATUS_FS_DRIVER_REQUIRED = unchecked((Int32)0xc000019c);
        public const Int32 STATUS_IMAGE_ALREADY_LOADED_AS_DLL = unchecked((Int32)0xc000019d);
        public const Int32 STATUS_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING = unchecked((Int32)0xc000019e);
        public const Int32 STATUS_SHORT_NAMES_NOT_ENABLED_ON_VOLUME = unchecked((Int32)0xc000019f);
        public const Int32 STATUS_SECURITY_STREAM_IS_INCONSISTENT = unchecked((Int32)0xc00001a0);
        public const Int32 STATUS_INVALID_LOCK_RANGE = unchecked((Int32)0xc00001a1);
        public const Int32 STATUS_INVALID_ACE_CONDITION = unchecked((Int32)0xc00001a2);
        public const Int32 STATUS_IMAGE_SUBSYSTEM_NOT_PRESENT = unchecked((Int32)0xc00001a3);
        public const Int32 STATUS_NOTIFICATION_GUID_ALREADY_DEFINED = unchecked((Int32)0xc00001a4);
        public const Int32 STATUS_INVALID_EXCEPTION_HANDLER = unchecked((Int32)0xc00001a5);
        public const Int32 STATUS_DUPLICATE_PRIVILEGES = unchecked((Int32)0xc00001a6);
        public const Int32 STATUS_NOT_ALLOWED_ON_SYSTEM_FILE = unchecked((Int32)0xc00001a7);
        public const Int32 STATUS_REPAIR_NEEDED = unchecked((Int32)0xc00001a8);
        public const Int32 STATUS_QUOTA_NOT_ENABLED = unchecked((Int32)0xc00001a9);
        public const Int32 STATUS_NO_APPLICATION_PACKAGE = unchecked((Int32)0xc00001aa);
        public const Int32 STATUS_FILE_METADATA_OPTIMIZATION_IN_PROGRESS = unchecked((Int32)0xc00001ab);
        public const Int32 STATUS_NOT_SAME_OBJECT = unchecked((Int32)0xc00001ac);
        public const Int32 STATUS_FATAL_MEMORY_EXHAUSTION = unchecked((Int32)0xc00001ad);
        public const Int32 STATUS_ERROR_PROCESS_NOT_IN_JOB = unchecked((Int32)0xc00001ae);
        public const Int32 STATUS_CPU_SET_INVALID = unchecked((Int32)0xc00001af);
        public const Int32 STATUS_NETWORK_OPEN_RESTRICTION = unchecked((Int32)0xc0000201);
        public const Int32 STATUS_NO_USER_SESSION_KEY = unchecked((Int32)0xc0000202);
        public const Int32 STATUS_USER_SESSION_DELETED = unchecked((Int32)0xc0000203);
        public const Int32 STATUS_RESOURCE_LANG_NOT_FOUND = unchecked((Int32)0xc0000204);
        public const Int32 STATUS_INSUFF_SERVER_RESOURCES = unchecked((Int32)0xc0000205);
        public const Int32 STATUS_INVALID_BUFFER_SIZE = unchecked((Int32)0xc0000206);
        public const Int32 STATUS_INVALID_ADDRESS_COMPONENT = unchecked((Int32)0xc0000207);
        public const Int32 STATUS_INVALID_ADDRESS_WILDCARD = unchecked((Int32)0xc0000208);
        public const Int32 STATUS_TOO_MANY_ADDRESSES = unchecked((Int32)0xc0000209);
        public const Int32 STATUS_ADDRESS_ALREADY_EXISTS = unchecked((Int32)0xc000020a);
        public const Int32 STATUS_ADDRESS_CLOSED = unchecked((Int32)0xc000020b);
        public const Int32 STATUS_CONNECTION_DISCONNECTED = unchecked((Int32)0xc000020c);
        public const Int32 STATUS_CONNECTION_RESET = unchecked((Int32)0xc000020d);
        public const Int32 STATUS_TOO_MANY_NODES = unchecked((Int32)0xc000020e);
        public const Int32 STATUS_TRANSACTION_ABORTED = unchecked((Int32)0xc000020f);
        public const Int32 STATUS_TRANSACTION_TIMED_OUT = unchecked((Int32)0xc0000210);
        public const Int32 STATUS_TRANSACTION_NO_RELEASE = unchecked((Int32)0xc0000211);
        public const Int32 STATUS_TRANSACTION_NO_MATCH = unchecked((Int32)0xc0000212);
        public const Int32 STATUS_TRANSACTION_RESPONDED = unchecked((Int32)0xc0000213);
        public const Int32 STATUS_TRANSACTION_INVALID_ID = unchecked((Int32)0xc0000214);
        public const Int32 STATUS_TRANSACTION_INVALID_TYPE = unchecked((Int32)0xc0000215);
        public const Int32 STATUS_NOT_SERVER_SESSION = unchecked((Int32)0xc0000216);
        public const Int32 STATUS_NOT_CLIENT_SESSION = unchecked((Int32)0xc0000217);
        public const Int32 STATUS_CANNOT_LOAD_REGISTRY_FILE = unchecked((Int32)0xc0000218);
        public const Int32 STATUS_DEBUG_ATTACH_FAILED = unchecked((Int32)0xc0000219);
        public const Int32 STATUS_SYSTEM_PROCESS_TERMINATED = unchecked((Int32)0xc000021a);
        public const Int32 STATUS_DATA_NOT_ACCEPTED = unchecked((Int32)0xc000021b);
        public const Int32 STATUS_NO_BROWSER_SERVERS_FOUND = unchecked((Int32)0xc000021c);
        public const Int32 STATUS_VDM_HARD_ERROR = unchecked((Int32)0xc000021d);
        public const Int32 STATUS_DRIVER_CANCEL_TIMEOUT = unchecked((Int32)0xc000021e);
        public const Int32 STATUS_REPLY_MESSAGE_MISMATCH = unchecked((Int32)0xc000021f);
        public const Int32 STATUS_MAPPED_ALIGNMENT = unchecked((Int32)0xc0000220);
        public const Int32 STATUS_IMAGE_CHECKSUM_MISMATCH = unchecked((Int32)0xc0000221);
        public const Int32 STATUS_LOST_WRITEBEHIND_DATA = unchecked((Int32)0xc0000222);
        public const Int32 STATUS_CLIENT_SERVER_PARAMETERS_INVALID = unchecked((Int32)0xc0000223);
        public const Int32 STATUS_PASSWORD_MUST_CHANGE = unchecked((Int32)0xc0000224);
        public const Int32 STATUS_NOT_FOUND = unchecked((Int32)0xc0000225);
        public const Int32 STATUS_NOT_TINY_STREAM = unchecked((Int32)0xc0000226);
        public const Int32 STATUS_RECOVERY_FAILURE = unchecked((Int32)0xc0000227);
        public const Int32 STATUS_STACK_OVERFLOW_READ = unchecked((Int32)0xc0000228);
        public const Int32 STATUS_FAIL_CHECK = unchecked((Int32)0xc0000229);
        public const Int32 STATUS_DUPLICATE_OBJECTID = unchecked((Int32)0xc000022a);
        public const Int32 STATUS_OBJECTID_EXISTS = unchecked((Int32)0xc000022b);
        public const Int32 STATUS_CONVERT_TO_LARGE = unchecked((Int32)0xc000022c);
        public const Int32 STATUS_RETRY = unchecked((Int32)0xc000022d);
        public const Int32 STATUS_FOUND_OUT_OF_SCOPE = unchecked((Int32)0xc000022e);
        public const Int32 STATUS_ALLOCATE_BUCKET = unchecked((Int32)0xc000022f);
        public const Int32 STATUS_PROPSET_NOT_FOUND = unchecked((Int32)0xc0000230);
        public const Int32 STATUS_MARSHALL_OVERFLOW = unchecked((Int32)0xc0000231);
        public const Int32 STATUS_INVALID_VARIANT = unchecked((Int32)0xc0000232);
        public const Int32 STATUS_DOMAIN_CONTROLLER_NOT_FOUND = unchecked((Int32)0xc0000233);
        public const Int32 STATUS_ACCOUNT_LOCKED_OUT = unchecked((Int32)0xc0000234);
        public const Int32 STATUS_HANDLE_NOT_CLOSABLE = unchecked((Int32)0xc0000235);
        public const Int32 STATUS_CONNECTION_REFUSED = unchecked((Int32)0xc0000236);
        public const Int32 STATUS_GRACEFUL_DISCONNECT = unchecked((Int32)0xc0000237);
        public const Int32 STATUS_ADDRESS_ALREADY_ASSOCIATED = unchecked((Int32)0xc0000238);
        public const Int32 STATUS_ADDRESS_NOT_ASSOCIATED = unchecked((Int32)0xc0000239);
        public const Int32 STATUS_CONNECTION_INVALID = unchecked((Int32)0xc000023a);
        public const Int32 STATUS_CONNECTION_ACTIVE = unchecked((Int32)0xc000023b);
        public const Int32 STATUS_NETWORK_UNREACHABLE = unchecked((Int32)0xc000023c);
        public const Int32 STATUS_HOST_UNREACHABLE = unchecked((Int32)0xc000023d);
        public const Int32 STATUS_PROTOCOL_UNREACHABLE = unchecked((Int32)0xc000023e);
        public const Int32 STATUS_PORT_UNREACHABLE = unchecked((Int32)0xc000023f);
        public const Int32 STATUS_REQUEST_ABORTED = unchecked((Int32)0xc0000240);
        public const Int32 STATUS_CONNECTION_ABORTED = unchecked((Int32)0xc0000241);
        public const Int32 STATUS_BAD_COMPRESSION_BUFFER = unchecked((Int32)0xc0000242);
        public const Int32 STATUS_USER_MAPPED_FILE = unchecked((Int32)0xc0000243);
        public const Int32 STATUS_AUDIT_FAILED = unchecked((Int32)0xc0000244);
        public const Int32 STATUS_TIMER_RESOLUTION_NOT_SET = unchecked((Int32)0xc0000245);
        public const Int32 STATUS_CONNECTION_COUNT_LIMIT = unchecked((Int32)0xc0000246);
        public const Int32 STATUS_LOGIN_TIME_RESTRICTION = unchecked((Int32)0xc0000247);
        public const Int32 STATUS_LOGIN_WKSTA_RESTRICTION = unchecked((Int32)0xc0000248);
        public const Int32 STATUS_IMAGE_MP_UP_MISMATCH = unchecked((Int32)0xc0000249);
        public const Int32 STATUS_INSUFFICIENT_LOGON_INFO = unchecked((Int32)0xc0000250);
        public const Int32 STATUS_BAD_DLL_ENTRYPOINT = unchecked((Int32)0xc0000251);
        public const Int32 STATUS_BAD_SERVICE_ENTRYPOINT = unchecked((Int32)0xc0000252);
        public const Int32 STATUS_LPC_REPLY_LOST = unchecked((Int32)0xc0000253);
        public const Int32 STATUS_IP_ADDRESS_CONFLICT1 = unchecked((Int32)0xc0000254);
        public const Int32 STATUS_IP_ADDRESS_CONFLICT2 = unchecked((Int32)0xc0000255);
        public const Int32 STATUS_REGISTRY_QUOTA_LIMIT = unchecked((Int32)0xc0000256);
        public const Int32 STATUS_PATH_NOT_COVERED = unchecked((Int32)0xc0000257);
        public const Int32 STATUS_NO_CALLBACK_ACTIVE = unchecked((Int32)0xc0000258);
        public const Int32 STATUS_LICENSE_QUOTA_EXCEEDED = unchecked((Int32)0xc0000259);
        public const Int32 STATUS_PWD_TOO_SHORT = unchecked((Int32)0xc000025a);
        public const Int32 STATUS_PWD_TOO_RECENT = unchecked((Int32)0xc000025b);
        public const Int32 STATUS_PWD_HISTORY_CONFLICT = unchecked((Int32)0xc000025c);
        public const Int32 STATUS_PLUGPLAY_NO_DEVICE = unchecked((Int32)0xc000025e);
        public const Int32 STATUS_UNSUPPORTED_COMPRESSION = unchecked((Int32)0xc000025f);
        public const Int32 STATUS_INVALID_HW_PROFILE = unchecked((Int32)0xc0000260);
        public const Int32 STATUS_INVALID_PLUGPLAY_DEVICE_PATH = unchecked((Int32)0xc0000261);
        public const Int32 STATUS_DRIVER_ORDINAL_NOT_FOUND = unchecked((Int32)0xc0000262);
        public const Int32 STATUS_DRIVER_ENTRYPOINT_NOT_FOUND = unchecked((Int32)0xc0000263);
        public const Int32 STATUS_RESOURCE_NOT_OWNED = unchecked((Int32)0xc0000264);
        public const Int32 STATUS_TOO_MANY_LINKS = unchecked((Int32)0xc0000265);
        public const Int32 STATUS_QUOTA_LIST_INCONSISTENT = unchecked((Int32)0xc0000266);
        public const Int32 STATUS_FILE_IS_OFFLINE = unchecked((Int32)0xc0000267);
        public const Int32 STATUS_EVALUATION_EXPIRATION = unchecked((Int32)0xc0000268);
        public const Int32 STATUS_ILLEGAL_DLL_RELOCATION = unchecked((Int32)0xc0000269);
        public const Int32 STATUS_LICENSE_VIOLATION = unchecked((Int32)0xc000026a);
        public const Int32 STATUS_DLL_INIT_FAILED_LOGOFF = unchecked((Int32)0xc000026b);
        public const Int32 STATUS_DRIVER_UNABLE_TO_LOAD = unchecked((Int32)0xc000026c);
        public const Int32 STATUS_DFS_UNAVAILABLE = unchecked((Int32)0xc000026d);
        public const Int32 STATUS_VOLUME_DISMOUNTED = unchecked((Int32)0xc000026e);
        public const Int32 STATUS_WX86_INTERNAL_ERROR = unchecked((Int32)0xc000026f);
        public const Int32 STATUS_WX86_FLOAT_STACK_CHECK = unchecked((Int32)0xc0000270);
        public const Int32 STATUS_VALIDATE_CONTINUE = unchecked((Int32)0xc0000271);
        public const Int32 STATUS_NO_MATCH = unchecked((Int32)0xc0000272);
        public const Int32 STATUS_NO_MORE_MATCHES = unchecked((Int32)0xc0000273);
        public const Int32 STATUS_NOT_A_REPARSE_POINT = unchecked((Int32)0xc0000275);
        public const Int32 STATUS_IO_REPARSE_TAG_INVALID = unchecked((Int32)0xc0000276);
        public const Int32 STATUS_IO_REPARSE_TAG_MISMATCH = unchecked((Int32)0xc0000277);
        public const Int32 STATUS_IO_REPARSE_DATA_INVALID = unchecked((Int32)0xc0000278);
        public const Int32 STATUS_IO_REPARSE_TAG_NOT_HANDLED = unchecked((Int32)0xc0000279);
        public const Int32 STATUS_PWD_TOO_LONG = unchecked((Int32)0xc000027a);
        public const Int32 STATUS_STOWED_EXCEPTION = unchecked((Int32)0xc000027b);
        public const Int32 STATUS_REPARSE_POINT_NOT_RESOLVED = unchecked((Int32)0xc0000280);
        public const Int32 STATUS_DIRECTORY_IS_A_REPARSE_POINT = unchecked((Int32)0xc0000281);
        public const Int32 STATUS_RANGE_LIST_CONFLICT = unchecked((Int32)0xc0000282);
        public const Int32 STATUS_SOURCE_ELEMENT_EMPTY = unchecked((Int32)0xc0000283);
        public const Int32 STATUS_DESTINATION_ELEMENT_FULL = unchecked((Int32)0xc0000284);
        public const Int32 STATUS_ILLEGAL_ELEMENT_ADDRESS = unchecked((Int32)0xc0000285);
        public const Int32 STATUS_MAGAZINE_NOT_PRESENT = unchecked((Int32)0xc0000286);
        public const Int32 STATUS_REINITIALIZATION_NEEDED = unchecked((Int32)0xc0000287);
        public const Int32 STATUS_DEVICE_REQUIRES_CLEANING = unchecked((Int32)0x80000288);
        public const Int32 STATUS_DEVICE_DOOR_OPEN = unchecked((Int32)0x80000289);
        public const Int32 STATUS_ENCRYPTION_FAILED = unchecked((Int32)0xc000028a);
        public const Int32 STATUS_DECRYPTION_FAILED = unchecked((Int32)0xc000028b);
        public const Int32 STATUS_RANGE_NOT_FOUND = unchecked((Int32)0xc000028c);
        public const Int32 STATUS_NO_RECOVERY_POLICY = unchecked((Int32)0xc000028d);
        public const Int32 STATUS_NO_EFS = unchecked((Int32)0xc000028e);
        public const Int32 STATUS_WRONG_EFS = unchecked((Int32)0xc000028f);
        public const Int32 STATUS_NO_USER_KEYS = unchecked((Int32)0xc0000290);
        public const Int32 STATUS_FILE_NOT_ENCRYPTED = unchecked((Int32)0xc0000291);
        public const Int32 STATUS_NOT_EXPORT_FORMAT = unchecked((Int32)0xc0000292);
        public const Int32 STATUS_FILE_ENCRYPTED = unchecked((Int32)0xc0000293);
        public const Int32 STATUS_WAKE_SYSTEM = unchecked((Int32)0x40000294);
        public const Int32 STATUS_WMI_GUID_NOT_FOUND = unchecked((Int32)0xc0000295);
        public const Int32 STATUS_WMI_INSTANCE_NOT_FOUND = unchecked((Int32)0xc0000296);
        public const Int32 STATUS_WMI_ITEMID_NOT_FOUND = unchecked((Int32)0xc0000297);
        public const Int32 STATUS_WMI_TRY_AGAIN = unchecked((Int32)0xc0000298);
        public const Int32 STATUS_SHARED_POLICY = unchecked((Int32)0xc0000299);
        public const Int32 STATUS_POLICY_OBJECT_NOT_FOUND = unchecked((Int32)0xc000029a);
        public const Int32 STATUS_POLICY_ONLY_IN_DS = unchecked((Int32)0xc000029b);
        public const Int32 STATUS_VOLUME_NOT_UPGRADED = unchecked((Int32)0xc000029c);
        public const Int32 STATUS_REMOTE_STORAGE_NOT_ACTIVE = unchecked((Int32)0xc000029d);
        public const Int32 STATUS_REMOTE_STORAGE_MEDIA_ERROR = unchecked((Int32)0xc000029e);
        public const Int32 STATUS_NO_TRACKING_SERVICE = unchecked((Int32)0xc000029f);
        public const Int32 STATUS_SERVER_SID_MISMATCH = unchecked((Int32)0xc00002a0);
        public const Int32 STATUS_DS_NO_ATTRIBUTE_OR_VALUE = unchecked((Int32)0xc00002a1);
        public const Int32 STATUS_DS_INVALID_ATTRIBUTE_SYNTAX = unchecked((Int32)0xc00002a2);
        public const Int32 STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED = unchecked((Int32)0xc00002a3);
        public const Int32 STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS = unchecked((Int32)0xc00002a4);
        public const Int32 STATUS_DS_BUSY = unchecked((Int32)0xc00002a5);
        public const Int32 STATUS_DS_UNAVAILABLE = unchecked((Int32)0xc00002a6);
        public const Int32 STATUS_DS_NO_RIDS_ALLOCATED = unchecked((Int32)0xc00002a7);
        public const Int32 STATUS_DS_NO_MORE_RIDS = unchecked((Int32)0xc00002a8);
        public const Int32 STATUS_DS_INCORRECT_ROLE_OWNER = unchecked((Int32)0xc00002a9);
        public const Int32 STATUS_DS_RIDMGR_INIT_ERROR = unchecked((Int32)0xc00002aa);
        public const Int32 STATUS_DS_OBJ_CLASS_VIOLATION = unchecked((Int32)0xc00002ab);
        public const Int32 STATUS_DS_CANT_ON_NON_LEAF = unchecked((Int32)0xc00002ac);
        public const Int32 STATUS_DS_CANT_ON_RDN = unchecked((Int32)0xc00002ad);
        public const Int32 STATUS_DS_CANT_MOD_OBJ_CLASS = unchecked((Int32)0xc00002ae);
        public const Int32 STATUS_DS_CROSS_DOM_MOVE_FAILED = unchecked((Int32)0xc00002af);
        public const Int32 STATUS_DS_GC_NOT_AVAILABLE = unchecked((Int32)0xc00002b0);
        public const Int32 STATUS_DIRECTORY_SERVICE_REQUIRED = unchecked((Int32)0xc00002b1);
        public const Int32 STATUS_REPARSE_ATTRIBUTE_CONFLICT = unchecked((Int32)0xc00002b2);
        public const Int32 STATUS_CANT_ENABLE_DENY_ONLY = unchecked((Int32)0xc00002b3);
        public const Int32 STATUS_FLOAT_MULTIPLE_FAULTS = unchecked((Int32)0xc00002b4);
        public const Int32 STATUS_FLOAT_MULTIPLE_TRAPS = unchecked((Int32)0xc00002b5);
        public const Int32 STATUS_DEVICE_REMOVED = unchecked((Int32)0xc00002b6);
        public const Int32 STATUS_JOURNAL_DELETE_IN_PROGRESS = unchecked((Int32)0xc00002b7);
        public const Int32 STATUS_JOURNAL_NOT_ACTIVE = unchecked((Int32)0xc00002b8);
        public const Int32 STATUS_NOINTERFACE = unchecked((Int32)0xc00002b9);
        public const Int32 STATUS_DS_RIDMGR_DISABLED = unchecked((Int32)0xc00002ba);
        public const Int32 STATUS_DS_ADMIN_LIMIT_EXCEEDED = unchecked((Int32)0xc00002c1);
        public const Int32 STATUS_DRIVER_FAILED_SLEEP = unchecked((Int32)0xc00002c2);
        public const Int32 STATUS_MUTUAL_AUTHENTICATION_FAILED = unchecked((Int32)0xc00002c3);
        public const Int32 STATUS_CORRUPT_SYSTEM_FILE = unchecked((Int32)0xc00002c4);
        public const Int32 STATUS_DATATYPE_MISALIGNMENT_ERROR = unchecked((Int32)0xc00002c5);
        public const Int32 STATUS_WMI_READ_ONLY = unchecked((Int32)0xc00002c6);
        public const Int32 STATUS_WMI_SET_FAILURE = unchecked((Int32)0xc00002c7);
        public const Int32 STATUS_COMMITMENT_MINIMUM = unchecked((Int32)0xc00002c8);
        public const Int32 STATUS_REG_NAT_CONSUMPTION = unchecked((Int32)0xc00002c9);
        public const Int32 STATUS_TRANSPORT_FULL = unchecked((Int32)0xc00002ca);
        public const Int32 STATUS_DS_SAM_INIT_FAILURE = unchecked((Int32)0xc00002cb);
        public const Int32 STATUS_ONLY_IF_CONNECTED = unchecked((Int32)0xc00002cc);
        public const Int32 STATUS_DS_SENSITIVE_GROUP_VIOLATION = unchecked((Int32)0xc00002cd);
        public const Int32 STATUS_PNP_RESTART_ENUMERATION = unchecked((Int32)0xc00002ce);
        public const Int32 STATUS_JOURNAL_ENTRY_DELETED = unchecked((Int32)0xc00002cf);
        public const Int32 STATUS_DS_CANT_MOD_PRIMARYGROUPID = unchecked((Int32)0xc00002d0);
        public const Int32 STATUS_SYSTEM_IMAGE_BAD_SIGNATURE = unchecked((Int32)0xc00002d1);
        public const Int32 STATUS_PNP_REBOOT_REQUIRED = unchecked((Int32)0xc00002d2);
        public const Int32 STATUS_POWER_STATE_INVALID = unchecked((Int32)0xc00002d3);
        public const Int32 STATUS_DS_INVALID_GROUP_TYPE = unchecked((Int32)0xc00002d4);
        public const Int32 STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN = unchecked((Int32)0xc00002d5);
        public const Int32 STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN = unchecked((Int32)0xc00002d6);
        public const Int32 STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER = unchecked((Int32)0xc00002d7);
        public const Int32 STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER = unchecked((Int32)0xc00002d8);
        public const Int32 STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER = unchecked((Int32)0xc00002d9);
        public const Int32 STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER = unchecked((Int32)0xc00002da);
        public const Int32 STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER = unchecked((Int32)0xc00002db);
        public const Int32 STATUS_DS_HAVE_PRIMARY_MEMBERS = unchecked((Int32)0xc00002dc);
        public const Int32 STATUS_WMI_NOT_SUPPORTED = unchecked((Int32)0xc00002dd);
        public const Int32 STATUS_INSUFFICIENT_POWER = unchecked((Int32)0xc00002de);
        public const Int32 STATUS_SAM_NEED_BOOTKEY_PASSWORD = unchecked((Int32)0xc00002df);
        public const Int32 STATUS_SAM_NEED_BOOTKEY_FLOPPY = unchecked((Int32)0xc00002e0);
        public const Int32 STATUS_DS_CANT_START = unchecked((Int32)0xc00002e1);
        public const Int32 STATUS_DS_INIT_FAILURE = unchecked((Int32)0xc00002e2);
        public const Int32 STATUS_SAM_INIT_FAILURE = unchecked((Int32)0xc00002e3);
        public const Int32 STATUS_DS_GC_REQUIRED = unchecked((Int32)0xc00002e4);
        public const Int32 STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY = unchecked((Int32)0xc00002e5);
        public const Int32 STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS = unchecked((Int32)0xc00002e6);
        public const Int32 STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED = unchecked((Int32)0xc00002e7);
        public const Int32 STATUS_MULTIPLE_FAULT_VIOLATION = unchecked((Int32)0xc00002e8);
        public const Int32 STATUS_CURRENT_DOMAIN_NOT_ALLOWED = unchecked((Int32)0xc00002e9);
        public const Int32 STATUS_CANNOT_MAKE = unchecked((Int32)0xc00002ea);
        public const Int32 STATUS_SYSTEM_SHUTDOWN = unchecked((Int32)0xc00002eb);
        public const Int32 STATUS_DS_INIT_FAILURE_CONSOLE = unchecked((Int32)0xc00002ec);
        public const Int32 STATUS_DS_SAM_INIT_FAILURE_CONSOLE = unchecked((Int32)0xc00002ed);
        public const Int32 STATUS_UNFINISHED_CONTEXT_DELETED = unchecked((Int32)0xc00002ee);
        public const Int32 STATUS_NO_TGT_REPLY = unchecked((Int32)0xc00002ef);
        public const Int32 STATUS_OBJECTID_NOT_FOUND = unchecked((Int32)0xc00002f0);
        public const Int32 STATUS_NO_IP_ADDRESSES = unchecked((Int32)0xc00002f1);
        public const Int32 STATUS_WRONG_CREDENTIAL_HANDLE = unchecked((Int32)0xc00002f2);
        public const Int32 STATUS_CRYPTO_SYSTEM_INVALID = unchecked((Int32)0xc00002f3);
        public const Int32 STATUS_MAX_REFERRALS_EXCEEDED = unchecked((Int32)0xc00002f4);
        public const Int32 STATUS_MUST_BE_KDC = unchecked((Int32)0xc00002f5);
        public const Int32 STATUS_STRONG_CRYPTO_NOT_SUPPORTED = unchecked((Int32)0xc00002f6);
        public const Int32 STATUS_TOO_MANY_PRINCIPALS = unchecked((Int32)0xc00002f7);
        public const Int32 STATUS_NO_PA_DATA = unchecked((Int32)0xc00002f8);
        public const Int32 STATUS_PKINIT_NAME_MISMATCH = unchecked((Int32)0xc00002f9);
        public const Int32 STATUS_SMARTCARD_LOGON_REQUIRED = unchecked((Int32)0xc00002fa);
        public const Int32 STATUS_KDC_INVALID_REQUEST = unchecked((Int32)0xc00002fb);
        public const Int32 STATUS_KDC_UNABLE_TO_REFER = unchecked((Int32)0xc00002fc);
        public const Int32 STATUS_KDC_UNKNOWN_ETYPE = unchecked((Int32)0xc00002fd);
        public const Int32 STATUS_SHUTDOWN_IN_PROGRESS = unchecked((Int32)0xc00002fe);
        public const Int32 STATUS_SERVER_SHUTDOWN_IN_PROGRESS = unchecked((Int32)0xc00002ff);
        public const Int32 STATUS_NOT_SUPPORTED_ON_SBS = unchecked((Int32)0xc0000300);
        public const Int32 STATUS_WMI_GUID_DISCONNECTED = unchecked((Int32)0xc0000301);
        public const Int32 STATUS_WMI_ALREADY_DISABLED = unchecked((Int32)0xc0000302);
        public const Int32 STATUS_WMI_ALREADY_ENABLED = unchecked((Int32)0xc0000303);
        public const Int32 STATUS_MFT_TOO_FRAGMENTED = unchecked((Int32)0xc0000304);
        public const Int32 STATUS_COPY_PROTECTION_FAILURE = unchecked((Int32)0xc0000305);
        public const Int32 STATUS_CSS_AUTHENTICATION_FAILURE = unchecked((Int32)0xc0000306);
        public const Int32 STATUS_CSS_KEY_NOT_PRESENT = unchecked((Int32)0xc0000307);
        public const Int32 STATUS_CSS_KEY_NOT_ESTABLISHED = unchecked((Int32)0xc0000308);
        public const Int32 STATUS_CSS_SCRAMBLED_SECTOR = unchecked((Int32)0xc0000309);
        public const Int32 STATUS_CSS_REGION_MISMATCH = unchecked((Int32)0xc000030a);
        public const Int32 STATUS_CSS_RESETS_EXHAUSTED = unchecked((Int32)0xc000030b);
        public const Int32 STATUS_PASSWORD_CHANGE_REQUIRED = unchecked((Int32)0xc000030c);
        public const Int32 STATUS_PKINIT_FAILURE = unchecked((Int32)0xc0000320);
        public const Int32 STATUS_SMARTCARD_SUBSYSTEM_FAILURE = unchecked((Int32)0xc0000321);
        public const Int32 STATUS_NO_KERB_KEY = unchecked((Int32)0xc0000322);
        public const Int32 STATUS_HOST_DOWN = unchecked((Int32)0xc0000350);
        public const Int32 STATUS_UNSUPPORTED_PREAUTH = unchecked((Int32)0xc0000351);
        public const Int32 STATUS_EFS_ALG_BLOB_TOO_BIG = unchecked((Int32)0xc0000352);
        public const Int32 STATUS_PORT_NOT_SET = unchecked((Int32)0xc0000353);
        public const Int32 STATUS_DEBUGGER_INACTIVE = unchecked((Int32)0xc0000354);
        public const Int32 STATUS_DS_VERSION_CHECK_FAILURE = unchecked((Int32)0xc0000355);
        public const Int32 STATUS_AUDITING_DISABLED = unchecked((Int32)0xc0000356);
        public const Int32 STATUS_PRENT4_MACHINE_ACCOUNT = unchecked((Int32)0xc0000357);
        public const Int32 STATUS_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER = unchecked((Int32)0xc0000358);
        public const Int32 STATUS_INVALID_IMAGE_WIN_32 = unchecked((Int32)0xc0000359);
        public const Int32 STATUS_INVALID_IMAGE_WIN_64 = unchecked((Int32)0xc000035a);
        public const Int32 STATUS_BAD_BINDINGS = unchecked((Int32)0xc000035b);
        public const Int32 STATUS_NETWORK_SESSION_EXPIRED = unchecked((Int32)0xc000035c);
        public const Int32 STATUS_APPHELP_BLOCK = unchecked((Int32)0xc000035d);
        public const Int32 STATUS_ALL_SIDS_FILTERED = unchecked((Int32)0xc000035e);
        public const Int32 STATUS_NOT_SAFE_MODE_DRIVER = unchecked((Int32)0xc000035f);
        public const Int32 STATUS_ACCESS_DISABLED_BY_POLICY_DEFAULT = unchecked((Int32)0xc0000361);
        public const Int32 STATUS_ACCESS_DISABLED_BY_POLICY_PATH = unchecked((Int32)0xc0000362);
        public const Int32 STATUS_ACCESS_DISABLED_BY_POLICY_PUBLISHER = unchecked((Int32)0xc0000363);
        public const Int32 STATUS_ACCESS_DISABLED_BY_POLICY_OTHER = unchecked((Int32)0xc0000364);
        public const Int32 STATUS_FAILED_DRIVER_ENTRY = unchecked((Int32)0xc0000365);
        public const Int32 STATUS_DEVICE_ENUMERATION_ERROR = unchecked((Int32)0xc0000366);
        public const Int32 STATUS_MOUNT_POINT_NOT_RESOLVED = unchecked((Int32)0xc0000368);
        public const Int32 STATUS_INVALID_DEVICE_OBJECT_PARAMETER = unchecked((Int32)0xc0000369);
        public const Int32 STATUS_MCA_OCCURED = unchecked((Int32)0xc000036a);
        public const Int32 STATUS_DRIVER_BLOCKED_CRITICAL = unchecked((Int32)0xc000036b);
        public const Int32 STATUS_DRIVER_BLOCKED = unchecked((Int32)0xc000036c);
        public const Int32 STATUS_DRIVER_DATABASE_ERROR = unchecked((Int32)0xc000036d);
        public const Int32 STATUS_SYSTEM_HIVE_TOO_LARGE = unchecked((Int32)0xc000036e);
        public const Int32 STATUS_INVALID_IMPORT_OF_NON_DLL = unchecked((Int32)0xc000036f);
        public const Int32 STATUS_DS_SHUTTING_DOWN = unchecked((Int32)0x40000370);
        public const Int32 STATUS_NO_SECRETS = unchecked((Int32)0xc0000371);
        public const Int32 STATUS_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY = unchecked((Int32)0xc0000372);
        public const Int32 STATUS_FAILED_STACK_SWITCH = unchecked((Int32)0xc0000373);
        public const Int32 STATUS_HEAP_CORRUPTION = unchecked((Int32)0xc0000374);
        public const Int32 STATUS_SMARTCARD_WRONG_PIN = unchecked((Int32)0xc0000380);
        public const Int32 STATUS_SMARTCARD_CARD_BLOCKED = unchecked((Int32)0xc0000381);
        public const Int32 STATUS_SMARTCARD_CARD_NOT_AUTHENTICATED = unchecked((Int32)0xc0000382);
        public const Int32 STATUS_SMARTCARD_NO_CARD = unchecked((Int32)0xc0000383);
        public const Int32 STATUS_SMARTCARD_NO_KEY_CONTAINER = unchecked((Int32)0xc0000384);
        public const Int32 STATUS_SMARTCARD_NO_CERTIFICATE = unchecked((Int32)0xc0000385);
        public const Int32 STATUS_SMARTCARD_NO_KEYSET = unchecked((Int32)0xc0000386);
        public const Int32 STATUS_SMARTCARD_IO_ERROR = unchecked((Int32)0xc0000387);
        public const Int32 STATUS_DOWNGRADE_DETECTED = unchecked((Int32)0xc0000388);
        public const Int32 STATUS_SMARTCARD_CERT_REVOKED = unchecked((Int32)0xc0000389);
        public const Int32 STATUS_ISSUING_CA_UNTRUSTED = unchecked((Int32)0xc000038a);
        public const Int32 STATUS_REVOCATION_OFFLINE_C = unchecked((Int32)0xc000038b);
        public const Int32 STATUS_PKINIT_CLIENT_FAILURE = unchecked((Int32)0xc000038c);
        public const Int32 STATUS_SMARTCARD_CERT_EXPIRED = unchecked((Int32)0xc000038d);
        public const Int32 STATUS_DRIVER_FAILED_PRIOR_UNLOAD = unchecked((Int32)0xc000038e);
        public const Int32 STATUS_SMARTCARD_SILENT_CONTEXT = unchecked((Int32)0xc000038f);
        public const Int32 STATUS_PER_USER_TRUST_QUOTA_EXCEEDED = unchecked((Int32)0xc0000401);
        public const Int32 STATUS_ALL_USER_TRUST_QUOTA_EXCEEDED = unchecked((Int32)0xc0000402);
        public const Int32 STATUS_USER_DELETE_TRUST_QUOTA_EXCEEDED = unchecked((Int32)0xc0000403);
        public const Int32 STATUS_DS_NAME_NOT_UNIQUE = unchecked((Int32)0xc0000404);
        public const Int32 STATUS_DS_DUPLICATE_ID_FOUND = unchecked((Int32)0xc0000405);
        public const Int32 STATUS_DS_GROUP_CONVERSION_ERROR = unchecked((Int32)0xc0000406);
        public const Int32 STATUS_VOLSNAP_PREPARE_HIBERNATE = unchecked((Int32)0xc0000407);
        public const Int32 STATUS_USER2USER_REQUIRED = unchecked((Int32)0xc0000408);
        public const Int32 STATUS_STACK_BUFFER_OVERRUN = unchecked((Int32)0xc0000409);
        public const Int32 STATUS_NO_S4U_PROT_SUPPORT = unchecked((Int32)0xc000040a);
        public const Int32 STATUS_CROSSREALM_DELEGATION_FAILURE = unchecked((Int32)0xc000040b);
        public const Int32 STATUS_REVOCATION_OFFLINE_KDC = unchecked((Int32)0xc000040c);
        public const Int32 STATUS_ISSUING_CA_UNTRUSTED_KDC = unchecked((Int32)0xc000040d);
        public const Int32 STATUS_KDC_CERT_EXPIRED = unchecked((Int32)0xc000040e);
        public const Int32 STATUS_KDC_CERT_REVOKED = unchecked((Int32)0xc000040f);
        public const Int32 STATUS_PARAMETER_QUOTA_EXCEEDED = unchecked((Int32)0xc0000410);
        public const Int32 STATUS_HIBERNATION_FAILURE = unchecked((Int32)0xc0000411);
        public const Int32 STATUS_DELAY_LOAD_FAILED = unchecked((Int32)0xc0000412);
        public const Int32 STATUS_AUTHENTICATION_FIREWALL_FAILED = unchecked((Int32)0xc0000413);
        public const Int32 STATUS_VDM_DISALLOWED = unchecked((Int32)0xc0000414);
        public const Int32 STATUS_HUNG_DISPLAY_DRIVER_THREAD = unchecked((Int32)0xc0000415);
        public const Int32 STATUS_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE = unchecked((Int32)0xc0000416);
        public const Int32 STATUS_INVALID_CRUNTIME_PARAMETER = unchecked((Int32)0xc0000417);
        public const Int32 STATUS_NTLM_BLOCKED = unchecked((Int32)0xc0000418);
        public const Int32 STATUS_DS_SRC_SID_EXISTS_IN_FOREST = unchecked((Int32)0xc0000419);
        public const Int32 STATUS_DS_DOMAIN_NAME_EXISTS_IN_FOREST = unchecked((Int32)0xc000041a);
        public const Int32 STATUS_DS_FLAT_NAME_EXISTS_IN_FOREST = unchecked((Int32)0xc000041b);
        public const Int32 STATUS_INVALID_USER_PRINCIPAL_NAME = unchecked((Int32)0xc000041c);
        public const Int32 STATUS_FATAL_USER_CALLBACK_EXCEPTION = unchecked((Int32)0xc000041d);
        public const Int32 STATUS_ASSERTION_FAILURE = unchecked((Int32)0xc0000420);
        public const Int32 STATUS_VERIFIER_STOP = unchecked((Int32)0xc0000421);
        public const Int32 STATUS_CALLBACK_POP_STACK = unchecked((Int32)0xc0000423);
        public const Int32 STATUS_INCOMPATIBLE_DRIVER_BLOCKED = unchecked((Int32)0xc0000424);
        public const Int32 STATUS_HIVE_UNLOADED = unchecked((Int32)0xc0000425);
        public const Int32 STATUS_COMPRESSION_DISABLED = unchecked((Int32)0xc0000426);
        public const Int32 STATUS_FILE_SYSTEM_LIMITATION = unchecked((Int32)0xc0000427);
        public const Int32 STATUS_INVALID_IMAGE_HASH = unchecked((Int32)0xc0000428);
        public const Int32 STATUS_NOT_CAPABLE = unchecked((Int32)0xc0000429);
        public const Int32 STATUS_REQUEST_OUT_OF_SEQUENCE = unchecked((Int32)0xc000042a);
        public const Int32 STATUS_IMPLEMENTATION_LIMIT = unchecked((Int32)0xc000042b);
        public const Int32 STATUS_ELEVATION_REQUIRED = unchecked((Int32)0xc000042c);
        public const Int32 STATUS_NO_SECURITY_CONTEXT = unchecked((Int32)0xc000042d);
        public const Int32 STATUS_PKU2U_CERT_FAILURE = unchecked((Int32)0xc000042f);
        public const Int32 STATUS_BEYOND_VDL = unchecked((Int32)0xc0000432);
        public const Int32 STATUS_ENCOUNTERED_WRITE_IN_PROGRESS = unchecked((Int32)0xc0000433);
        public const Int32 STATUS_PTE_CHANGED = unchecked((Int32)0xc0000434);
        public const Int32 STATUS_PURGE_FAILED = unchecked((Int32)0xc0000435);
        public const Int32 STATUS_CRED_REQUIRES_CONFIRMATION = unchecked((Int32)0xc0000440);
        public const Int32 STATUS_CS_ENCRYPTION_INVALID_SERVER_RESPONSE = unchecked((Int32)0xc0000441);
        public const Int32 STATUS_CS_ENCRYPTION_UNSUPPORTED_SERVER = unchecked((Int32)0xc0000442);
        public const Int32 STATUS_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE = unchecked((Int32)0xc0000443);
        public const Int32 STATUS_CS_ENCRYPTION_NEW_ENCRYPTED_FILE = unchecked((Int32)0xc0000444);
        public const Int32 STATUS_CS_ENCRYPTION_FILE_NOT_CSE = unchecked((Int32)0xc0000445);
        public const Int32 STATUS_INVALID_LABEL = unchecked((Int32)0xc0000446);
        public const Int32 STATUS_DRIVER_PROCESS_TERMINATED = unchecked((Int32)0xc0000450);
        public const Int32 STATUS_AMBIGUOUS_SYSTEM_DEVICE = unchecked((Int32)0xc0000451);
        public const Int32 STATUS_SYSTEM_DEVICE_NOT_FOUND = unchecked((Int32)0xc0000452);
        public const Int32 STATUS_RESTART_BOOT_APPLICATION = unchecked((Int32)0xc0000453);
        public const Int32 STATUS_INSUFFICIENT_NVRAM_RESOURCES = unchecked((Int32)0xc0000454);
        public const Int32 STATUS_INVALID_SESSION = unchecked((Int32)0xc0000455);
        public const Int32 STATUS_THREAD_ALREADY_IN_SESSION = unchecked((Int32)0xc0000456);
        public const Int32 STATUS_THREAD_NOT_IN_SESSION = unchecked((Int32)0xc0000457);
        public const Int32 STATUS_INVALID_WEIGHT = unchecked((Int32)0xc0000458);
        public const Int32 STATUS_REQUEST_PAUSED = unchecked((Int32)0xc0000459);
        public const Int32 STATUS_NO_RANGES_PROCESSED = unchecked((Int32)0xc0000460);
        public const Int32 STATUS_DISK_RESOURCES_EXHAUSTED = unchecked((Int32)0xc0000461);
        public const Int32 STATUS_NEEDS_REMEDIATION = unchecked((Int32)0xc0000462);
        public const Int32 STATUS_DEVICE_FEATURE_NOT_SUPPORTED = unchecked((Int32)0xc0000463);
        public const Int32 STATUS_DEVICE_UNREACHABLE = unchecked((Int32)0xc0000464);
        public const Int32 STATUS_INVALID_TOKEN = unchecked((Int32)0xc0000465);
        public const Int32 STATUS_SERVER_UNAVAILABLE = unchecked((Int32)0xc0000466);
        public const Int32 STATUS_FILE_NOT_AVAILABLE = unchecked((Int32)0xc0000467);
        public const Int32 STATUS_DEVICE_INSUFFICIENT_RESOURCES = unchecked((Int32)0xc0000468);
        public const Int32 STATUS_PACKAGE_UPDATING = unchecked((Int32)0xc0000469);
        public const Int32 STATUS_NOT_READ_FROM_COPY = unchecked((Int32)0xc000046a);
        public const Int32 STATUS_FT_WRITE_FAILURE = unchecked((Int32)0xc000046b);
        public const Int32 STATUS_FT_DI_SCAN_REQUIRED = unchecked((Int32)0xc000046c);
        public const Int32 STATUS_OBJECT_NOT_EXTERNALLY_BACKED = unchecked((Int32)0xc000046d);
        public const Int32 STATUS_EXTERNAL_BACKING_PROVIDER_UNKNOWN = unchecked((Int32)0xc000046e);
        public const Int32 STATUS_COMPRESSION_NOT_BENEFICIAL = unchecked((Int32)0xc000046f);
        public const Int32 STATUS_DATA_CHECKSUM_ERROR = unchecked((Int32)0xc0000470);
        public const Int32 STATUS_INTERMIXED_KERNEL_EA_OPERATION = unchecked((Int32)0xc0000471);
        public const Int32 STATUS_TRIM_READ_ZERO_NOT_SUPPORTED = unchecked((Int32)0xc0000472);
        public const Int32 STATUS_TOO_MANY_SEGMENT_DESCRIPTORS = unchecked((Int32)0xc0000473);
        public const Int32 STATUS_INVALID_OFFSET_ALIGNMENT = unchecked((Int32)0xc0000474);
        public const Int32 STATUS_INVALID_FIELD_IN_PARAMETER_LIST = unchecked((Int32)0xc0000475);
        public const Int32 STATUS_OPERATION_IN_PROGRESS = unchecked((Int32)0xc0000476);
        public const Int32 STATUS_INVALID_INITIATOR_TARGET_PATH = unchecked((Int32)0xc0000477);
        public const Int32 STATUS_SCRUB_DATA_DISABLED = unchecked((Int32)0xc0000478);
        public const Int32 STATUS_NOT_REDUNDANT_STORAGE = unchecked((Int32)0xc0000479);
        public const Int32 STATUS_RESIDENT_FILE_NOT_SUPPORTED = unchecked((Int32)0xc000047a);
        public const Int32 STATUS_COMPRESSED_FILE_NOT_SUPPORTED = unchecked((Int32)0xc000047b);
        public const Int32 STATUS_DIRECTORY_NOT_SUPPORTED = unchecked((Int32)0xc000047c);
        public const Int32 STATUS_IO_OPERATION_TIMEOUT = unchecked((Int32)0xc000047d);
        public const Int32 STATUS_SYSTEM_NEEDS_REMEDIATION = unchecked((Int32)0xc000047e);
        public const Int32 STATUS_APPX_INTEGRITY_FAILURE_CLR_NGEN = unchecked((Int32)0xc000047f);
        public const Int32 STATUS_SHARE_UNAVAILABLE = unchecked((Int32)0xc0000480);
        public const Int32 STATUS_APISET_NOT_HOSTED = unchecked((Int32)0xc0000481);
        public const Int32 STATUS_APISET_NOT_PRESENT = unchecked((Int32)0xc0000482);
        public const Int32 STATUS_DEVICE_HARDWARE_ERROR = unchecked((Int32)0xc0000483);
        public const Int32 STATUS_FIRMWARE_SLOT_INVALID = unchecked((Int32)0xc0000484);
        public const Int32 STATUS_FIRMWARE_IMAGE_INVALID = unchecked((Int32)0xc0000485);
        public const Int32 STATUS_STORAGE_TOPOLOGY_ID_MISMATCH = unchecked((Int32)0xc0000486);
        public const Int32 STATUS_WIM_NOT_BOOTABLE = unchecked((Int32)0xc0000487);
        public const Int32 STATUS_BLOCKED_BY_PARENTAL_CONTROLS = unchecked((Int32)0xc0000488);
        public const Int32 STATUS_NEEDS_REGISTRATION = unchecked((Int32)0xc0000489);
        public const Int32 STATUS_QUOTA_ACTIVITY = unchecked((Int32)0xc000048a);
        public const Int32 STATUS_CALLBACK_INVOKE_INLINE = unchecked((Int32)0xc000048b);
        public const Int32 STATUS_BLOCK_TOO_MANY_REFERENCES = unchecked((Int32)0xc000048c);
        public const Int32 STATUS_INVALID_TASK_NAME = unchecked((Int32)0xc0000500);
        public const Int32 STATUS_INVALID_TASK_INDEX = unchecked((Int32)0xc0000501);
        public const Int32 STATUS_THREAD_ALREADY_IN_TASK = unchecked((Int32)0xc0000502);
        public const Int32 STATUS_CALLBACK_BYPASS = unchecked((Int32)0xc0000503);
        public const Int32 STATUS_UNDEFINED_SCOPE = unchecked((Int32)0xc0000504);
        public const Int32 STATUS_INVALID_CAP = unchecked((Int32)0xc0000505);
        public const Int32 STATUS_NOT_GUI_PROCESS = unchecked((Int32)0xc0000506);
        public const Int32 STATUS_DEVICE_HUNG = unchecked((Int32)0xc0000507);
        public const Int32 STATUS_CONTAINER_ASSIGNED = unchecked((Int32)0xc0000508);
        public const Int32 STATUS_JOB_NO_CONTAINER = unchecked((Int32)0xc0000509);
        public const Int32 STATUS_FAIL_FAST_EXCEPTION = unchecked((Int32)0xc0000602);
        public const Int32 STATUS_IMAGE_CERT_REVOKED = unchecked((Int32)0xc0000603);
        public const Int32 STATUS_DYNAMIC_CODE_BLOCKED = unchecked((Int32)0xc0000604);
        public const Int32 STATUS_IMAGE_CERT_EXPIRED = unchecked((Int32)0xc0000605);
        public const Int32 STATUS_PORT_CLOSED = unchecked((Int32)0xc0000700);
        public const Int32 STATUS_MESSAGE_LOST = unchecked((Int32)0xc0000701);
        public const Int32 STATUS_INVALID_MESSAGE = unchecked((Int32)0xc0000702);
        public const Int32 STATUS_REQUEST_CANCELED = unchecked((Int32)0xc0000703);
        public const Int32 STATUS_RECURSIVE_DISPATCH = unchecked((Int32)0xc0000704);
        public const Int32 STATUS_LPC_RECEIVE_BUFFER_EXPECTED = unchecked((Int32)0xc0000705);
        public const Int32 STATUS_LPC_INVALID_CONNECTION_USAGE = unchecked((Int32)0xc0000706);
        public const Int32 STATUS_LPC_REQUESTS_NOT_ALLOWED = unchecked((Int32)0xc0000707);
        public const Int32 STATUS_RESOURCE_IN_USE = unchecked((Int32)0xc0000708);
        public const Int32 STATUS_HARDWARE_MEMORY_ERROR = unchecked((Int32)0xc0000709);
        public const Int32 STATUS_THREADPOOL_HANDLE_EXCEPTION = unchecked((Int32)0xc000070a);
        public const Int32 STATUS_THREADPOOL_SET_EVENT_ON_COMPLETION_FAILED = unchecked((Int32)0xc000070b);
        public const Int32 STATUS_THREADPOOL_RELEASE_SEMAPHORE_ON_COMPLETION_FAILED = unchecked((Int32)0xc000070c);
        public const Int32 STATUS_THREADPOOL_RELEASE_MUTEX_ON_COMPLETION_FAILED = unchecked((Int32)0xc000070d);
        public const Int32 STATUS_THREADPOOL_FREE_LIBRARY_ON_COMPLETION_FAILED = unchecked((Int32)0xc000070e);
        public const Int32 STATUS_THREADPOOL_RELEASED_DURING_OPERATION = unchecked((Int32)0xc000070f);
        public const Int32 STATUS_CALLBACK_RETURNED_WHILE_IMPERSONATING = unchecked((Int32)0xc0000710);
        public const Int32 STATUS_APC_RETURNED_WHILE_IMPERSONATING = unchecked((Int32)0xc0000711);
        public const Int32 STATUS_PROCESS_IS_PROTECTED = unchecked((Int32)0xc0000712);
        public const Int32 STATUS_MCA_EXCEPTION = unchecked((Int32)0xc0000713);
        public const Int32 STATUS_CERTIFICATE_MAPPING_NOT_UNIQUE = unchecked((Int32)0xc0000714);
        public const Int32 STATUS_SYMLINK_CLASS_DISABLED = unchecked((Int32)0xc0000715);
        public const Int32 STATUS_INVALID_IDN_NORMALIZATION = unchecked((Int32)0xc0000716);
        public const Int32 STATUS_NO_UNICODE_TRANSLATION = unchecked((Int32)0xc0000717);
        public const Int32 STATUS_ALREADY_REGISTERED = unchecked((Int32)0xc0000718);
        public const Int32 STATUS_CONTEXT_MISMATCH = unchecked((Int32)0xc0000719);
        public const Int32 STATUS_PORT_ALREADY_HAS_COMPLETION_LIST = unchecked((Int32)0xc000071a);
        public const Int32 STATUS_CALLBACK_RETURNED_THREAD_PRIORITY = unchecked((Int32)0xc000071b);
        public const Int32 STATUS_INVALID_THREAD = unchecked((Int32)0xc000071c);
        public const Int32 STATUS_CALLBACK_RETURNED_TRANSACTION = unchecked((Int32)0xc000071d);
        public const Int32 STATUS_CALLBACK_RETURNED_LDR_LOCK = unchecked((Int32)0xc000071e);
        public const Int32 STATUS_CALLBACK_RETURNED_LANG = unchecked((Int32)0xc000071f);
        public const Int32 STATUS_CALLBACK_RETURNED_PRI_BACK = unchecked((Int32)0xc0000720);
        public const Int32 STATUS_CALLBACK_RETURNED_THREAD_AFFINITY = unchecked((Int32)0xc0000721);
        public const Int32 STATUS_DISK_REPAIR_DISABLED = unchecked((Int32)0xc0000800);
        public const Int32 STATUS_DS_DOMAIN_RENAME_IN_PROGRESS = unchecked((Int32)0xc0000801);
        public const Int32 STATUS_DISK_QUOTA_EXCEEDED = unchecked((Int32)0xc0000802);
        public const Int32 STATUS_DATA_LOST_REPAIR = unchecked((Int32)0x80000803);
        public const Int32 STATUS_CONTENT_BLOCKED = unchecked((Int32)0xc0000804);
        public const Int32 STATUS_BAD_CLUSTERS = unchecked((Int32)0xc0000805);
        public const Int32 STATUS_VOLUME_DIRTY = unchecked((Int32)0xc0000806);
        public const Int32 STATUS_DISK_REPAIR_REDIRECTED = unchecked((Int32)0x40000807);
        public const Int32 STATUS_DISK_REPAIR_UNSUCCESSFUL = unchecked((Int32)0xc0000808);
        public const Int32 STATUS_CORRUPT_LOG_OVERFULL = unchecked((Int32)0xc0000809);
        public const Int32 STATUS_CORRUPT_LOG_CORRUPTED = unchecked((Int32)0xc000080a);
        public const Int32 STATUS_CORRUPT_LOG_UNAVAILABLE = unchecked((Int32)0xc000080b);
        public const Int32 STATUS_CORRUPT_LOG_DELETED_FULL = unchecked((Int32)0xc000080c);
        public const Int32 STATUS_CORRUPT_LOG_CLEARED = unchecked((Int32)0xc000080d);
        public const Int32 STATUS_ORPHAN_NAME_EXHAUSTED = unchecked((Int32)0xc000080e);
        public const Int32 STATUS_PROACTIVE_SCAN_IN_PROGRESS = unchecked((Int32)0xc000080f);
        public const Int32 STATUS_ENCRYPTED_IO_NOT_POSSIBLE = unchecked((Int32)0xc0000810);
        public const Int32 STATUS_CORRUPT_LOG_UPLEVEL_RECORDS = unchecked((Int32)0xc0000811);
        public const Int32 STATUS_FILE_CHECKED_OUT = unchecked((Int32)0xc0000901);
        public const Int32 STATUS_CHECKOUT_REQUIRED = unchecked((Int32)0xc0000902);
        public const Int32 STATUS_BAD_FILE_TYPE = unchecked((Int32)0xc0000903);
        public const Int32 STATUS_FILE_TOO_LARGE = unchecked((Int32)0xc0000904);
        public const Int32 STATUS_FORMS_AUTH_REQUIRED = unchecked((Int32)0xc0000905);
        public const Int32 STATUS_VIRUS_INFECTED = unchecked((Int32)0xc0000906);
        public const Int32 STATUS_VIRUS_DELETED = unchecked((Int32)0xc0000907);
        public const Int32 STATUS_BAD_MCFG_TABLE = unchecked((Int32)0xc0000908);
        public const Int32 STATUS_CANNOT_BREAK_OPLOCK = unchecked((Int32)0xc0000909);
        public const Int32 STATUS_BAD_KEY = unchecked((Int32)0xc000090a);
        public const Int32 STATUS_BAD_DATA = unchecked((Int32)0xc000090b);
        public const Int32 STATUS_NO_KEY = unchecked((Int32)0xc000090c);
        public const Int32 STATUS_FILE_HANDLE_REVOKED = unchecked((Int32)0xc0000910);
        public const Int32 STATUS_WOW_ASSERTION = unchecked((Int32)0xc0009898);
        public const Int32 STATUS_INVALID_SIGNATURE = unchecked((Int32)0xc000a000);
        public const Int32 STATUS_HMAC_NOT_SUPPORTED = unchecked((Int32)0xc000a001);
        public const Int32 STATUS_AUTH_TAG_MISMATCH = unchecked((Int32)0xc000a002);
        public const Int32 STATUS_INVALID_STATE_TRANSITION = unchecked((Int32)0xc000a003);
        public const Int32 STATUS_INVALID_KERNEL_INFO_VERSION = unchecked((Int32)0xc000a004);
        public const Int32 STATUS_INVALID_PEP_INFO_VERSION = unchecked((Int32)0xc000a005);
        public const Int32 STATUS_HANDLE_REVOKED = unchecked((Int32)0xc000a006);
        public const Int32 STATUS_IPSEC_QUEUE_OVERFLOW = unchecked((Int32)0xc000a010);
        public const Int32 STATUS_ND_QUEUE_OVERFLOW = unchecked((Int32)0xc000a011);
        public const Int32 STATUS_HOPLIMIT_EXCEEDED = unchecked((Int32)0xc000a012);
        public const Int32 STATUS_PROTOCOL_NOT_SUPPORTED = unchecked((Int32)0xc000a013);
        public const Int32 STATUS_FASTPATH_REJECTED = unchecked((Int32)0xc000a014);
        public const Int32 STATUS_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED = unchecked((Int32)0xc000a080);
        public const Int32 STATUS_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR = unchecked((Int32)0xc000a081);
        public const Int32 STATUS_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR = unchecked((Int32)0xc000a082);
        public const Int32 STATUS_XML_PARSE_ERROR = unchecked((Int32)0xc000a083);
        public const Int32 STATUS_XMLDSIG_ERROR = unchecked((Int32)0xc000a084);
        public const Int32 STATUS_WRONG_COMPARTMENT = unchecked((Int32)0xc000a085);
        public const Int32 STATUS_AUTHIP_FAILURE = unchecked((Int32)0xc000a086);
        public const Int32 STATUS_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS = unchecked((Int32)0xc000a087);
        public const Int32 STATUS_DS_OID_NOT_FOUND = unchecked((Int32)0xc000a088);
        public const Int32 STATUS_INCORRECT_ACCOUNT_TYPE = unchecked((Int32)0xc000a089);
        public const Int32 STATUS_HASH_NOT_SUPPORTED = unchecked((Int32)0xc000a100);
        public const Int32 STATUS_HASH_NOT_PRESENT = unchecked((Int32)0xc000a101);
        public const Int32 STATUS_SECONDARY_IC_PROVIDER_NOT_REGISTERED = unchecked((Int32)0xc000a121);
        public const Int32 STATUS_GPIO_CLIENT_INFORMATION_INVALID = unchecked((Int32)0xc000a122);
        public const Int32 STATUS_GPIO_VERSION_NOT_SUPPORTED = unchecked((Int32)0xc000a123);
        public const Int32 STATUS_GPIO_INVALID_REGISTRATION_PACKET = unchecked((Int32)0xc000a124);
        public const Int32 STATUS_GPIO_OPERATION_DENIED = unchecked((Int32)0xc000a125);
        public const Int32 STATUS_GPIO_INCOMPATIBLE_CONNECT_MODE = unchecked((Int32)0xc000a126);
        public const Int32 STATUS_GPIO_INTERRUPT_ALREADY_UNMASKED = unchecked((Int32)0x8000a127);
        public const Int32 STATUS_CANNOT_SWITCH_RUNLEVEL = unchecked((Int32)0xc000a141);
        public const Int32 STATUS_INVALID_RUNLEVEL_SETTING = unchecked((Int32)0xc000a142);
        public const Int32 STATUS_RUNLEVEL_SWITCH_TIMEOUT = unchecked((Int32)0xc000a143);
        public const Int32 STATUS_SERVICES_FAILED_AUTOSTART = unchecked((Int32)0x4000a144);
        public const Int32 STATUS_RUNLEVEL_SWITCH_AGENT_TIMEOUT = unchecked((Int32)0xc000a145);
        public const Int32 STATUS_RUNLEVEL_SWITCH_IN_PROGRESS = unchecked((Int32)0xc000a146);
        public const Int32 STATUS_NOT_APPCONTAINER = unchecked((Int32)0xc000a200);
        public const Int32 STATUS_NOT_SUPPORTED_IN_APPCONTAINER = unchecked((Int32)0xc000a201);
        public const Int32 STATUS_INVALID_PACKAGE_SID_LENGTH = unchecked((Int32)0xc000a202);
        public const Int32 STATUS_APP_DATA_NOT_FOUND = unchecked((Int32)0xc000a281);
        public const Int32 STATUS_APP_DATA_EXPIRED = unchecked((Int32)0xc000a282);
        public const Int32 STATUS_APP_DATA_CORRUPT = unchecked((Int32)0xc000a283);
        public const Int32 STATUS_APP_DATA_LIMIT_EXCEEDED = unchecked((Int32)0xc000a284);
        public const Int32 STATUS_APP_DATA_REBOOT_REQUIRED = unchecked((Int32)0xc000a285);
        public const Int32 STATUS_OFFLOAD_READ_FLT_NOT_SUPPORTED = unchecked((Int32)0xc000a2a1);
        public const Int32 STATUS_OFFLOAD_WRITE_FLT_NOT_SUPPORTED = unchecked((Int32)0xc000a2a2);
        public const Int32 STATUS_OFFLOAD_READ_FILE_NOT_SUPPORTED = unchecked((Int32)0xc000a2a3);
        public const Int32 STATUS_OFFLOAD_WRITE_FILE_NOT_SUPPORTED = unchecked((Int32)0xc000a2a4);
        public const Int32 STATUS_ACPI_INVALID_OPCODE = unchecked((Int32)0xc0140001);
        public const Int32 STATUS_ACPI_STACK_OVERFLOW = unchecked((Int32)0xc0140002);
        public const Int32 STATUS_ACPI_ASSERT_FAILED = unchecked((Int32)0xc0140003);
        public const Int32 STATUS_ACPI_INVALID_INDEX = unchecked((Int32)0xc0140004);
        public const Int32 STATUS_ACPI_INVALID_ARGUMENT = unchecked((Int32)0xc0140005);
        public const Int32 STATUS_ACPI_FATAL = unchecked((Int32)0xc0140006);
        public const Int32 STATUS_ACPI_INVALID_SUPERNAME = unchecked((Int32)0xc0140007);
        public const Int32 STATUS_ACPI_INVALID_ARGTYPE = unchecked((Int32)0xc0140008);
        public const Int32 STATUS_ACPI_INVALID_OBJTYPE = unchecked((Int32)0xc0140009);
        public const Int32 STATUS_ACPI_INVALID_TARGETTYPE = unchecked((Int32)0xc014000a);
        public const Int32 STATUS_ACPI_INCORRECT_ARGUMENT_COUNT = unchecked((Int32)0xc014000b);
        public const Int32 STATUS_ACPI_ADDRESS_NOT_MAPPED = unchecked((Int32)0xc014000c);
        public const Int32 STATUS_ACPI_INVALID_EVENTTYPE = unchecked((Int32)0xc014000d);
        public const Int32 STATUS_ACPI_HANDLER_COLLISION = unchecked((Int32)0xc014000e);
        public const Int32 STATUS_ACPI_INVALID_DATA = unchecked((Int32)0xc014000f);
        public const Int32 STATUS_ACPI_INVALID_REGION = unchecked((Int32)0xc0140010);
        public const Int32 STATUS_ACPI_INVALID_ACCESS_SIZE = unchecked((Int32)0xc0140011);
        public const Int32 STATUS_ACPI_ACQUIRE_GLOBAL_LOCK = unchecked((Int32)0xc0140012);
        public const Int32 STATUS_ACPI_ALREADY_INITIALIZED = unchecked((Int32)0xc0140013);
        public const Int32 STATUS_ACPI_NOT_INITIALIZED = unchecked((Int32)0xc0140014);
        public const Int32 STATUS_ACPI_INVALID_MUTEX_LEVEL = unchecked((Int32)0xc0140015);
        public const Int32 STATUS_ACPI_MUTEX_NOT_OWNED = unchecked((Int32)0xc0140016);
        public const Int32 STATUS_ACPI_MUTEX_NOT_OWNER = unchecked((Int32)0xc0140017);
        public const Int32 STATUS_ACPI_RS_ACCESS = unchecked((Int32)0xc0140018);
        public const Int32 STATUS_ACPI_INVALID_TABLE = unchecked((Int32)0xc0140019);
        public const Int32 STATUS_ACPI_REG_HANDLER_FAILED = unchecked((Int32)0xc0140020);
        public const Int32 STATUS_ACPI_POWER_REQUEST_FAILED = unchecked((Int32)0xc0140021);
        public const Int32 STATUS_CTX_WINSTATION_NAME_INVALID = unchecked((Int32)0xc00a0001);
        public const Int32 STATUS_CTX_INVALID_PD = unchecked((Int32)0xc00a0002);
        public const Int32 STATUS_CTX_PD_NOT_FOUND = unchecked((Int32)0xc00a0003);
        public const Int32 STATUS_CTX_CDM_CONNECT = unchecked((Int32)0x400a0004);
        public const Int32 STATUS_CTX_CDM_DISCONNECT = unchecked((Int32)0x400a0005);
        public const Int32 STATUS_CTX_CLOSE_PENDING = unchecked((Int32)0xc00a0006);
        public const Int32 STATUS_CTX_NO_OUTBUF = unchecked((Int32)0xc00a0007);
        public const Int32 STATUS_CTX_MODEM_INF_NOT_FOUND = unchecked((Int32)0xc00a0008);
        public const Int32 STATUS_CTX_INVALID_MODEMNAME = unchecked((Int32)0xc00a0009);
        public const Int32 STATUS_CTX_RESPONSE_ERROR = unchecked((Int32)0xc00a000a);
        public const Int32 STATUS_CTX_MODEM_RESPONSE_TIMEOUT = unchecked((Int32)0xc00a000b);
        public const Int32 STATUS_CTX_MODEM_RESPONSE_NO_CARRIER = unchecked((Int32)0xc00a000c);
        public const Int32 STATUS_CTX_MODEM_RESPONSE_NO_DIALTONE = unchecked((Int32)0xc00a000d);
        public const Int32 STATUS_CTX_MODEM_RESPONSE_BUSY = unchecked((Int32)0xc00a000e);
        public const Int32 STATUS_CTX_MODEM_RESPONSE_VOICE = unchecked((Int32)0xc00a000f);
        public const Int32 STATUS_CTX_TD_ERROR = unchecked((Int32)0xc00a0010);
        public const Int32 STATUS_CTX_LICENSE_CLIENT_INVALID = unchecked((Int32)0xc00a0012);
        public const Int32 STATUS_CTX_LICENSE_NOT_AVAILABLE = unchecked((Int32)0xc00a0013);
        public const Int32 STATUS_CTX_LICENSE_EXPIRED = unchecked((Int32)0xc00a0014);
        public const Int32 STATUS_CTX_WINSTATION_NOT_FOUND = unchecked((Int32)0xc00a0015);
        public const Int32 STATUS_CTX_WINSTATION_NAME_COLLISION = unchecked((Int32)0xc00a0016);
        public const Int32 STATUS_CTX_WINSTATION_BUSY = unchecked((Int32)0xc00a0017);
        public const Int32 STATUS_CTX_BAD_VIDEO_MODE = unchecked((Int32)0xc00a0018);
        public const Int32 STATUS_CTX_GRAPHICS_INVALID = unchecked((Int32)0xc00a0022);
        public const Int32 STATUS_CTX_NOT_CONSOLE = unchecked((Int32)0xc00a0024);
        public const Int32 STATUS_CTX_CLIENT_QUERY_TIMEOUT = unchecked((Int32)0xc00a0026);
        public const Int32 STATUS_CTX_CONSOLE_DISCONNECT = unchecked((Int32)0xc00a0027);
        public const Int32 STATUS_CTX_CONSOLE_CONNECT = unchecked((Int32)0xc00a0028);
        public const Int32 STATUS_CTX_SHADOW_DENIED = unchecked((Int32)0xc00a002a);
        public const Int32 STATUS_CTX_WINSTATION_ACCESS_DENIED = unchecked((Int32)0xc00a002b);
        public const Int32 STATUS_CTX_INVALID_WD = unchecked((Int32)0xc00a002e);
        public const Int32 STATUS_CTX_WD_NOT_FOUND = unchecked((Int32)0xc00a002f);
        public const Int32 STATUS_CTX_SHADOW_INVALID = unchecked((Int32)0xc00a0030);
        public const Int32 STATUS_CTX_SHADOW_DISABLED = unchecked((Int32)0xc00a0031);
        public const Int32 STATUS_RDP_PROTOCOL_ERROR = unchecked((Int32)0xc00a0032);
        public const Int32 STATUS_CTX_CLIENT_LICENSE_NOT_SET = unchecked((Int32)0xc00a0033);
        public const Int32 STATUS_CTX_CLIENT_LICENSE_IN_USE = unchecked((Int32)0xc00a0034);
        public const Int32 STATUS_CTX_SHADOW_ENDED_BY_MODE_CHANGE = unchecked((Int32)0xc00a0035);
        public const Int32 STATUS_CTX_SHADOW_NOT_RUNNING = unchecked((Int32)0xc00a0036);
        public const Int32 STATUS_CTX_LOGON_DISABLED = unchecked((Int32)0xc00a0037);
        public const Int32 STATUS_CTX_SECURITY_LAYER_ERROR = unchecked((Int32)0xc00a0038);
        public const Int32 STATUS_TS_INCOMPATIBLE_SESSIONS = unchecked((Int32)0xc00a0039);
        public const Int32 STATUS_TS_VIDEO_SUBSYSTEM_ERROR = unchecked((Int32)0xc00a003a);
        public const Int32 STATUS_PNP_BAD_MPS_TABLE = unchecked((Int32)0xc0040035);
        public const Int32 STATUS_PNP_TRANSLATION_FAILED = unchecked((Int32)0xc0040036);
        public const Int32 STATUS_PNP_IRQ_TRANSLATION_FAILED = unchecked((Int32)0xc0040037);
        public const Int32 STATUS_PNP_INVALID_ID = unchecked((Int32)0xc0040038);
        public const Int32 STATUS_IO_REISSUE_AS_CACHED = unchecked((Int32)0xc0040039);
        public const Int32 STATUS_MUI_FILE_NOT_FOUND = unchecked((Int32)0xc00b0001);
        public const Int32 STATUS_MUI_INVALID_FILE = unchecked((Int32)0xc00b0002);
        public const Int32 STATUS_MUI_INVALID_RC_CONFIG = unchecked((Int32)0xc00b0003);
        public const Int32 STATUS_MUI_INVALID_LOCALE_NAME = unchecked((Int32)0xc00b0004);
        public const Int32 STATUS_MUI_INVALID_ULTIMATEFALLBACK_NAME = unchecked((Int32)0xc00b0005);
        public const Int32 STATUS_MUI_FILE_NOT_LOADED = unchecked((Int32)0xc00b0006);
        public const Int32 STATUS_RESOURCE_ENUM_USER_STOP = unchecked((Int32)0xc00b0007);
        public const Int32 STATUS_FLT_NO_HANDLER_DEFINED = unchecked((Int32)0xc01c0001);
        public const Int32 STATUS_FLT_CONTEXT_ALREADY_DEFINED = unchecked((Int32)0xc01c0002);
        public const Int32 STATUS_FLT_INVALID_ASYNCHRONOUS_REQUEST = unchecked((Int32)0xc01c0003);
        public const Int32 STATUS_FLT_DISALLOW_FAST_IO = unchecked((Int32)0xc01c0004);
        public const Int32 STATUS_FLT_INVALID_NAME_REQUEST = unchecked((Int32)0xc01c0005);
        public const Int32 STATUS_FLT_NOT_SAFE_TO_POST_OPERATION = unchecked((Int32)0xc01c0006);
        public const Int32 STATUS_FLT_NOT_INITIALIZED = unchecked((Int32)0xc01c0007);
        public const Int32 STATUS_FLT_FILTER_NOT_READY = unchecked((Int32)0xc01c0008);
        public const Int32 STATUS_FLT_POST_OPERATION_CLEANUP = unchecked((Int32)0xc01c0009);
        public const Int32 STATUS_FLT_INTERNAL_ERROR = unchecked((Int32)0xc01c000a);
        public const Int32 STATUS_FLT_DELETING_OBJECT = unchecked((Int32)0xc01c000b);
        public const Int32 STATUS_FLT_MUST_BE_NONPAGED_POOL = unchecked((Int32)0xc01c000c);
        public const Int32 STATUS_FLT_DUPLICATE_ENTRY = unchecked((Int32)0xc01c000d);
        public const Int32 STATUS_FLT_CBDQ_DISABLED = unchecked((Int32)0xc01c000e);
        public const Int32 STATUS_FLT_DO_NOT_ATTACH = unchecked((Int32)0xc01c000f);
        public const Int32 STATUS_FLT_DO_NOT_DETACH = unchecked((Int32)0xc01c0010);
        public const Int32 STATUS_FLT_INSTANCE_ALTITUDE_COLLISION = unchecked((Int32)0xc01c0011);
        public const Int32 STATUS_FLT_INSTANCE_NAME_COLLISION = unchecked((Int32)0xc01c0012);
        public const Int32 STATUS_FLT_FILTER_NOT_FOUND = unchecked((Int32)0xc01c0013);
        public const Int32 STATUS_FLT_VOLUME_NOT_FOUND = unchecked((Int32)0xc01c0014);
        public const Int32 STATUS_FLT_INSTANCE_NOT_FOUND = unchecked((Int32)0xc01c0015);
        public const Int32 STATUS_FLT_CONTEXT_ALLOCATION_NOT_FOUND = unchecked((Int32)0xc01c0016);
        public const Int32 STATUS_FLT_INVALID_CONTEXT_REGISTRATION = unchecked((Int32)0xc01c0017);
        public const Int32 STATUS_FLT_NAME_CACHE_MISS = unchecked((Int32)0xc01c0018);
        public const Int32 STATUS_FLT_NO_DEVICE_OBJECT = unchecked((Int32)0xc01c0019);
        public const Int32 STATUS_FLT_VOLUME_ALREADY_MOUNTED = unchecked((Int32)0xc01c001a);
        public const Int32 STATUS_FLT_ALREADY_ENLISTED = unchecked((Int32)0xc01c001b);
        public const Int32 STATUS_FLT_CONTEXT_ALREADY_LINKED = unchecked((Int32)0xc01c001c);
        public const Int32 STATUS_FLT_NO_WAITER_FOR_REPLY = unchecked((Int32)0xc01c0020);
        public const Int32 STATUS_FLT_REGISTRATION_BUSY = unchecked((Int32)0xc01c0023);
        public const Int32 STATUS_SXS_SECTION_NOT_FOUND = unchecked((Int32)0xc0150001);
        public const Int32 STATUS_SXS_CANT_GEN_ACTCTX = unchecked((Int32)0xc0150002);
        public const Int32 STATUS_SXS_INVALID_ACTCTXDATA_FORMAT = unchecked((Int32)0xc0150003);
        public const Int32 STATUS_SXS_ASSEMBLY_NOT_FOUND = unchecked((Int32)0xc0150004);
        public const Int32 STATUS_SXS_MANIFEST_FORMAT_ERROR = unchecked((Int32)0xc0150005);
        public const Int32 STATUS_SXS_MANIFEST_PARSE_ERROR = unchecked((Int32)0xc0150006);
        public const Int32 STATUS_SXS_ACTIVATION_CONTEXT_DISABLED = unchecked((Int32)0xc0150007);
        public const Int32 STATUS_SXS_KEY_NOT_FOUND = unchecked((Int32)0xc0150008);
        public const Int32 STATUS_SXS_VERSION_CONFLICT = unchecked((Int32)0xc0150009);
        public const Int32 STATUS_SXS_WRONG_SECTION_TYPE = unchecked((Int32)0xc015000a);
        public const Int32 STATUS_SXS_THREAD_QUERIES_DISABLED = unchecked((Int32)0xc015000b);
        public const Int32 STATUS_SXS_ASSEMBLY_MISSING = unchecked((Int32)0xc015000c);
        public const Int32 STATUS_SXS_RELEASE_ACTIVATION_CONTEXT = unchecked((Int32)0x4015000d);
        public const Int32 STATUS_SXS_PROCESS_DEFAULT_ALREADY_SET = unchecked((Int32)0xc015000e);
        public const Int32 STATUS_SXS_EARLY_DEACTIVATION = unchecked((Int32)0xc015000f);
        public const Int32 STATUS_SXS_INVALID_DEACTIVATION = unchecked((Int32)0xc0150010);
        public const Int32 STATUS_SXS_MULTIPLE_DEACTIVATION = unchecked((Int32)0xc0150011);
        public const Int32 STATUS_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY = unchecked((Int32)0xc0150012);
        public const Int32 STATUS_SXS_PROCESS_TERMINATION_REQUESTED = unchecked((Int32)0xc0150013);
        public const Int32 STATUS_SXS_CORRUPT_ACTIVATION_STACK = unchecked((Int32)0xc0150014);
        public const Int32 STATUS_SXS_CORRUPTION = unchecked((Int32)0xc0150015);
        public const Int32 STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE = unchecked((Int32)0xc0150016);
        public const Int32 STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME = unchecked((Int32)0xc0150017);
        public const Int32 STATUS_SXS_IDENTITY_DUPLICATE_ATTRIBUTE = unchecked((Int32)0xc0150018);
        public const Int32 STATUS_SXS_IDENTITY_PARSE_ERROR = unchecked((Int32)0xc0150019);
        public const Int32 STATUS_SXS_COMPONENT_STORE_CORRUPT = unchecked((Int32)0xc015001a);
        public const Int32 STATUS_SXS_FILE_HASH_MISMATCH = unchecked((Int32)0xc015001b);
        public const Int32 STATUS_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT = unchecked((Int32)0xc015001c);
        public const Int32 STATUS_SXS_IDENTITIES_DIFFERENT = unchecked((Int32)0xc015001d);
        public const Int32 STATUS_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT = unchecked((Int32)0xc015001e);
        public const Int32 STATUS_SXS_FILE_NOT_PART_OF_ASSEMBLY = unchecked((Int32)0xc015001f);
        public const Int32 STATUS_ADVANCED_INSTALLER_FAILED = unchecked((Int32)0xc0150020);
        public const Int32 STATUS_XML_ENCODING_MISMATCH = unchecked((Int32)0xc0150021);
        public const Int32 STATUS_SXS_MANIFEST_TOO_BIG = unchecked((Int32)0xc0150022);
        public const Int32 STATUS_SXS_SETTING_NOT_REGISTERED = unchecked((Int32)0xc0150023);
        public const Int32 STATUS_SXS_TRANSACTION_CLOSURE_INCOMPLETE = unchecked((Int32)0xc0150024);
        public const Int32 STATUS_SMI_PRIMITIVE_INSTALLER_FAILED = unchecked((Int32)0xc0150025);
        public const Int32 STATUS_GENERIC_COMMAND_FAILED = unchecked((Int32)0xc0150026);
        public const Int32 STATUS_SXS_FILE_HASH_MISSING = unchecked((Int32)0xc0150027);
        public const Int32 STATUS_CLUSTER_INVALID_NODE = unchecked((Int32)0xc0130001);
        public const Int32 STATUS_CLUSTER_NODE_EXISTS = unchecked((Int32)0xc0130002);
        public const Int32 STATUS_CLUSTER_JOIN_IN_PROGRESS = unchecked((Int32)0xc0130003);
        public const Int32 STATUS_CLUSTER_NODE_NOT_FOUND = unchecked((Int32)0xc0130004);
        public const Int32 STATUS_CLUSTER_LOCAL_NODE_NOT_FOUND = unchecked((Int32)0xc0130005);
        public const Int32 STATUS_CLUSTER_NETWORK_EXISTS = unchecked((Int32)0xc0130006);
        public const Int32 STATUS_CLUSTER_NETWORK_NOT_FOUND = unchecked((Int32)0xc0130007);
        public const Int32 STATUS_CLUSTER_NETINTERFACE_EXISTS = unchecked((Int32)0xc0130008);
        public const Int32 STATUS_CLUSTER_NETINTERFACE_NOT_FOUND = unchecked((Int32)0xc0130009);
        public const Int32 STATUS_CLUSTER_INVALID_REQUEST = unchecked((Int32)0xc013000a);
        public const Int32 STATUS_CLUSTER_INVALID_NETWORK_PROVIDER = unchecked((Int32)0xc013000b);
        public const Int32 STATUS_CLUSTER_NODE_DOWN = unchecked((Int32)0xc013000c);
        public const Int32 STATUS_CLUSTER_NODE_UNREACHABLE = unchecked((Int32)0xc013000d);
        public const Int32 STATUS_CLUSTER_NODE_NOT_MEMBER = unchecked((Int32)0xc013000e);
        public const Int32 STATUS_CLUSTER_JOIN_NOT_IN_PROGRESS = unchecked((Int32)0xc013000f);
        public const Int32 STATUS_CLUSTER_INVALID_NETWORK = unchecked((Int32)0xc0130010);
        public const Int32 STATUS_CLUSTER_NO_NET_ADAPTERS = unchecked((Int32)0xc0130011);
        public const Int32 STATUS_CLUSTER_NODE_UP = unchecked((Int32)0xc0130012);
        public const Int32 STATUS_CLUSTER_NODE_PAUSED = unchecked((Int32)0xc0130013);
        public const Int32 STATUS_CLUSTER_NODE_NOT_PAUSED = unchecked((Int32)0xc0130014);
        public const Int32 STATUS_CLUSTER_NO_SECURITY_CONTEXT = unchecked((Int32)0xc0130015);
        public const Int32 STATUS_CLUSTER_NETWORK_NOT_INTERNAL = unchecked((Int32)0xc0130016);
        public const Int32 STATUS_CLUSTER_POISONED = unchecked((Int32)0xc0130017);
        public const Int32 STATUS_CLUSTER_NON_CSV_PATH = unchecked((Int32)0xc0130018);
        public const Int32 STATUS_CLUSTER_CSV_VOLUME_NOT_LOCAL = unchecked((Int32)0xc0130019);
        public const Int32 STATUS_CLUSTER_CSV_READ_OPLOCK_BREAK_IN_PROGRESS = unchecked((Int32)0xc0130020);
        public const Int32 STATUS_CLUSTER_CSV_AUTO_PAUSE_ERROR = unchecked((Int32)0xc0130021);
        public const Int32 STATUS_CLUSTER_CSV_REDIRECTED = unchecked((Int32)0xc0130022);
        public const Int32 STATUS_CLUSTER_CSV_NOT_REDIRECTED = unchecked((Int32)0xc0130023);
        public const Int32 STATUS_CLUSTER_CSV_VOLUME_DRAINING = unchecked((Int32)0xc0130024);
        public const Int32 STATUS_CLUSTER_CSV_SNAPSHOT_CREATION_IN_PROGRESS = unchecked((Int32)0xc0130025);
        public const Int32 STATUS_CLUSTER_CSV_VOLUME_DRAINING_SUCCEEDED_DOWNLEVEL = unchecked((Int32)0xc0130026);
        public const Int32 STATUS_CLUSTER_CSV_NO_SNAPSHOTS = unchecked((Int32)0xc0130027);
        public const Int32 STATUS_CSV_IO_PAUSE_TIMEOUT = unchecked((Int32)0xc0130028);
        public const Int32 STATUS_TRANSACTIONAL_CONFLICT = unchecked((Int32)0xc0190001);
        public const Int32 STATUS_INVALID_TRANSACTION = unchecked((Int32)0xc0190002);
        public const Int32 STATUS_TRANSACTION_NOT_ACTIVE = unchecked((Int32)0xc0190003);
        public const Int32 STATUS_TM_INITIALIZATION_FAILED = unchecked((Int32)0xc0190004);
        public const Int32 STATUS_RM_NOT_ACTIVE = unchecked((Int32)0xc0190005);
        public const Int32 STATUS_RM_METADATA_CORRUPT = unchecked((Int32)0xc0190006);
        public const Int32 STATUS_TRANSACTION_NOT_JOINED = unchecked((Int32)0xc0190007);
        public const Int32 STATUS_DIRECTORY_NOT_RM = unchecked((Int32)0xc0190008);
        public const Int32 STATUS_COULD_NOT_RESIZE_LOG = unchecked((Int32)0x80190009);
        public const Int32 STATUS_TRANSACTIONS_UNSUPPORTED_REMOTE = unchecked((Int32)0xc019000a);
        public const Int32 STATUS_LOG_RESIZE_INVALID_SIZE = unchecked((Int32)0xc019000b);
        public const Int32 STATUS_REMOTE_FILE_VERSION_MISMATCH = unchecked((Int32)0xc019000c);
        public const Int32 STATUS_CRM_PROTOCOL_ALREADY_EXISTS = unchecked((Int32)0xc019000f);
        public const Int32 STATUS_TRANSACTION_PROPAGATION_FAILED = unchecked((Int32)0xc0190010);
        public const Int32 STATUS_CRM_PROTOCOL_NOT_FOUND = unchecked((Int32)0xc0190011);
        public const Int32 STATUS_TRANSACTION_SUPERIOR_EXISTS = unchecked((Int32)0xc0190012);
        public const Int32 STATUS_TRANSACTION_REQUEST_NOT_VALID = unchecked((Int32)0xc0190013);
        public const Int32 STATUS_TRANSACTION_NOT_REQUESTED = unchecked((Int32)0xc0190014);
        public const Int32 STATUS_TRANSACTION_ALREADY_ABORTED = unchecked((Int32)0xc0190015);
        public const Int32 STATUS_TRANSACTION_ALREADY_COMMITTED = unchecked((Int32)0xc0190016);
        public const Int32 STATUS_TRANSACTION_INVALID_MARSHALL_BUFFER = unchecked((Int32)0xc0190017);
        public const Int32 STATUS_CURRENT_TRANSACTION_NOT_VALID = unchecked((Int32)0xc0190018);
        public const Int32 STATUS_LOG_GROWTH_FAILED = unchecked((Int32)0xc0190019);
        public const Int32 STATUS_OBJECT_NO_LONGER_EXISTS = unchecked((Int32)0xc0190021);
        public const Int32 STATUS_STREAM_MINIVERSION_NOT_FOUND = unchecked((Int32)0xc0190022);
        public const Int32 STATUS_STREAM_MINIVERSION_NOT_VALID = unchecked((Int32)0xc0190023);
        public const Int32 STATUS_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION = unchecked((Int32)0xc0190024);
        public const Int32 STATUS_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT = unchecked((Int32)0xc0190025);
        public const Int32 STATUS_CANT_CREATE_MORE_STREAM_MINIVERSIONS = unchecked((Int32)0xc0190026);
        public const Int32 STATUS_HANDLE_NO_LONGER_VALID = unchecked((Int32)0xc0190028);
        public const Int32 STATUS_NO_TXF_METADATA = unchecked((Int32)0x80190029);
        public const Int32 STATUS_LOG_CORRUPTION_DETECTED = unchecked((Int32)0xc0190030);
        public const Int32 STATUS_CANT_RECOVER_WITH_HANDLE_OPEN = unchecked((Int32)0x80190031);
        public const Int32 STATUS_RM_DISCONNECTED = unchecked((Int32)0xc0190032);
        public const Int32 STATUS_ENLISTMENT_NOT_SUPERIOR = unchecked((Int32)0xc0190033);
        public const Int32 STATUS_RECOVERY_NOT_NEEDED = unchecked((Int32)0x40190034);
        public const Int32 STATUS_RM_ALREADY_STARTED = unchecked((Int32)0x40190035);
        public const Int32 STATUS_FILE_IDENTITY_NOT_PERSISTENT = unchecked((Int32)0xc0190036);
        public const Int32 STATUS_CANT_BREAK_TRANSACTIONAL_DEPENDENCY = unchecked((Int32)0xc0190037);
        public const Int32 STATUS_CANT_CROSS_RM_BOUNDARY = unchecked((Int32)0xc0190038);
        public const Int32 STATUS_TXF_DIR_NOT_EMPTY = unchecked((Int32)0xc0190039);
        public const Int32 STATUS_INDOUBT_TRANSACTIONS_EXIST = unchecked((Int32)0xc019003a);
        public const Int32 STATUS_TM_VOLATILE = unchecked((Int32)0xc019003b);
        public const Int32 STATUS_ROLLBACK_TIMER_EXPIRED = unchecked((Int32)0xc019003c);
        public const Int32 STATUS_TXF_ATTRIBUTE_CORRUPT = unchecked((Int32)0xc019003d);
        public const Int32 STATUS_EFS_NOT_ALLOWED_IN_TRANSACTION = unchecked((Int32)0xc019003e);
        public const Int32 STATUS_TRANSACTIONAL_OPEN_NOT_ALLOWED = unchecked((Int32)0xc019003f);
        public const Int32 STATUS_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE = unchecked((Int32)0xc0190040);
        public const Int32 STATUS_TXF_METADATA_ALREADY_PRESENT = unchecked((Int32)0x80190041);
        public const Int32 STATUS_TRANSACTION_SCOPE_CALLBACKS_NOT_SET = unchecked((Int32)0x80190042);
        public const Int32 STATUS_TRANSACTION_REQUIRED_PROMOTION = unchecked((Int32)0xc0190043);
        public const Int32 STATUS_CANNOT_EXECUTE_FILE_IN_TRANSACTION = unchecked((Int32)0xc0190044);
        public const Int32 STATUS_TRANSACTIONS_NOT_FROZEN = unchecked((Int32)0xc0190045);
        public const Int32 STATUS_TRANSACTION_FREEZE_IN_PROGRESS = unchecked((Int32)0xc0190046);
        public const Int32 STATUS_NOT_SNAPSHOT_VOLUME = unchecked((Int32)0xc0190047);
        public const Int32 STATUS_NO_SAVEPOINT_WITH_OPEN_FILES = unchecked((Int32)0xc0190048);
        public const Int32 STATUS_SPARSE_NOT_ALLOWED_IN_TRANSACTION = unchecked((Int32)0xc0190049);
        public const Int32 STATUS_TM_IDENTITY_MISMATCH = unchecked((Int32)0xc019004a);
        public const Int32 STATUS_FLOATED_SECTION = unchecked((Int32)0xc019004b);
        public const Int32 STATUS_CANNOT_ACCEPT_TRANSACTED_WORK = unchecked((Int32)0xc019004c);
        public const Int32 STATUS_CANNOT_ABORT_TRANSACTIONS = unchecked((Int32)0xc019004d);
        public const Int32 STATUS_TRANSACTION_NOT_FOUND = unchecked((Int32)0xc019004e);
        public const Int32 STATUS_RESOURCEMANAGER_NOT_FOUND = unchecked((Int32)0xc019004f);
        public const Int32 STATUS_ENLISTMENT_NOT_FOUND = unchecked((Int32)0xc0190050);
        public const Int32 STATUS_TRANSACTIONMANAGER_NOT_FOUND = unchecked((Int32)0xc0190051);
        public const Int32 STATUS_TRANSACTIONMANAGER_NOT_ONLINE = unchecked((Int32)0xc0190052);
        public const Int32 STATUS_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION = unchecked((Int32)0xc0190053);
        public const Int32 STATUS_TRANSACTION_NOT_ROOT = unchecked((Int32)0xc0190054);
        public const Int32 STATUS_TRANSACTION_OBJECT_EXPIRED = unchecked((Int32)0xc0190055);
        public const Int32 STATUS_COMPRESSION_NOT_ALLOWED_IN_TRANSACTION = unchecked((Int32)0xc0190056);
        public const Int32 STATUS_TRANSACTION_RESPONSE_NOT_ENLISTED = unchecked((Int32)0xc0190057);
        public const Int32 STATUS_TRANSACTION_RECORD_TOO_LONG = unchecked((Int32)0xc0190058);
        public const Int32 STATUS_NO_LINK_TRACKING_IN_TRANSACTION = unchecked((Int32)0xc0190059);
        public const Int32 STATUS_OPERATION_NOT_SUPPORTED_IN_TRANSACTION = unchecked((Int32)0xc019005a);
        public const Int32 STATUS_TRANSACTION_INTEGRITY_VIOLATED = unchecked((Int32)0xc019005b);
        public const Int32 STATUS_TRANSACTIONMANAGER_IDENTITY_MISMATCH = unchecked((Int32)0xc019005c);
        public const Int32 STATUS_RM_CANNOT_BE_FROZEN_FOR_SNAPSHOT = unchecked((Int32)0xc019005d);
        public const Int32 STATUS_TRANSACTION_MUST_WRITETHROUGH = unchecked((Int32)0xc019005e);
        public const Int32 STATUS_TRANSACTION_NO_SUPERIOR = unchecked((Int32)0xc019005f);
        public const Int32 STATUS_EXPIRED_HANDLE = unchecked((Int32)0xc0190060);
        public const Int32 STATUS_TRANSACTION_NOT_ENLISTED = unchecked((Int32)0xc0190061);
        public const Int32 STATUS_LOG_SECTOR_INVALID = unchecked((Int32)0xc01a0001);
        public const Int32 STATUS_LOG_SECTOR_PARITY_INVALID = unchecked((Int32)0xc01a0002);
        public const Int32 STATUS_LOG_SECTOR_REMAPPED = unchecked((Int32)0xc01a0003);
        public const Int32 STATUS_LOG_BLOCK_INCOMPLETE = unchecked((Int32)0xc01a0004);
        public const Int32 STATUS_LOG_INVALID_RANGE = unchecked((Int32)0xc01a0005);
        public const Int32 STATUS_LOG_BLOCKS_EXHAUSTED = unchecked((Int32)0xc01a0006);
        public const Int32 STATUS_LOG_READ_CONTEXT_INVALID = unchecked((Int32)0xc01a0007);
        public const Int32 STATUS_LOG_RESTART_INVALID = unchecked((Int32)0xc01a0008);
        public const Int32 STATUS_LOG_BLOCK_VERSION = unchecked((Int32)0xc01a0009);
        public const Int32 STATUS_LOG_BLOCK_INVALID = unchecked((Int32)0xc01a000a);
        public const Int32 STATUS_LOG_READ_MODE_INVALID = unchecked((Int32)0xc01a000b);
        public const Int32 STATUS_LOG_NO_RESTART = unchecked((Int32)0x401a000c);
        public const Int32 STATUS_LOG_METADATA_CORRUPT = unchecked((Int32)0xc01a000d);
        public const Int32 STATUS_LOG_METADATA_INVALID = unchecked((Int32)0xc01a000e);
        public const Int32 STATUS_LOG_METADATA_INCONSISTENT = unchecked((Int32)0xc01a000f);
        public const Int32 STATUS_LOG_RESERVATION_INVALID = unchecked((Int32)0xc01a0010);
        public const Int32 STATUS_LOG_CANT_DELETE = unchecked((Int32)0xc01a0011);
        public const Int32 STATUS_LOG_CONTAINER_LIMIT_EXCEEDED = unchecked((Int32)0xc01a0012);
        public const Int32 STATUS_LOG_START_OF_LOG = unchecked((Int32)0xc01a0013);
        public const Int32 STATUS_LOG_POLICY_ALREADY_INSTALLED = unchecked((Int32)0xc01a0014);
        public const Int32 STATUS_LOG_POLICY_NOT_INSTALLED = unchecked((Int32)0xc01a0015);
        public const Int32 STATUS_LOG_POLICY_INVALID = unchecked((Int32)0xc01a0016);
        public const Int32 STATUS_LOG_POLICY_CONFLICT = unchecked((Int32)0xc01a0017);
        public const Int32 STATUS_LOG_PINNED_ARCHIVE_TAIL = unchecked((Int32)0xc01a0018);
        public const Int32 STATUS_LOG_RECORD_NONEXISTENT = unchecked((Int32)0xc01a0019);
        public const Int32 STATUS_LOG_RECORDS_RESERVED_INVALID = unchecked((Int32)0xc01a001a);
        public const Int32 STATUS_LOG_SPACE_RESERVED_INVALID = unchecked((Int32)0xc01a001b);
        public const Int32 STATUS_LOG_TAIL_INVALID = unchecked((Int32)0xc01a001c);
        public const Int32 STATUS_LOG_FULL = unchecked((Int32)0xc01a001d);
        public const Int32 STATUS_LOG_MULTIPLEXED = unchecked((Int32)0xc01a001e);
        public const Int32 STATUS_LOG_DEDICATED = unchecked((Int32)0xc01a001f);
        public const Int32 STATUS_LOG_ARCHIVE_NOT_IN_PROGRESS = unchecked((Int32)0xc01a0020);
        public const Int32 STATUS_LOG_ARCHIVE_IN_PROGRESS = unchecked((Int32)0xc01a0021);
        public const Int32 STATUS_LOG_EPHEMERAL = unchecked((Int32)0xc01a0022);
        public const Int32 STATUS_LOG_NOT_ENOUGH_CONTAINERS = unchecked((Int32)0xc01a0023);
        public const Int32 STATUS_LOG_CLIENT_ALREADY_REGISTERED = unchecked((Int32)0xc01a0024);
        public const Int32 STATUS_LOG_CLIENT_NOT_REGISTERED = unchecked((Int32)0xc01a0025);
        public const Int32 STATUS_LOG_FULL_HANDLER_IN_PROGRESS = unchecked((Int32)0xc01a0026);
        public const Int32 STATUS_LOG_CONTAINER_READ_FAILED = unchecked((Int32)0xc01a0027);
        public const Int32 STATUS_LOG_CONTAINER_WRITE_FAILED = unchecked((Int32)0xc01a0028);
        public const Int32 STATUS_LOG_CONTAINER_OPEN_FAILED = unchecked((Int32)0xc01a0029);
        public const Int32 STATUS_LOG_CONTAINER_STATE_INVALID = unchecked((Int32)0xc01a002a);
        public const Int32 STATUS_LOG_STATE_INVALID = unchecked((Int32)0xc01a002b);
        public const Int32 STATUS_LOG_PINNED = unchecked((Int32)0xc01a002c);
        public const Int32 STATUS_LOG_METADATA_FLUSH_FAILED = unchecked((Int32)0xc01a002d);
        public const Int32 STATUS_LOG_INCONSISTENT_SECURITY = unchecked((Int32)0xc01a002e);
        public const Int32 STATUS_LOG_APPENDED_FLUSH_FAILED = unchecked((Int32)0xc01a002f);
        public const Int32 STATUS_LOG_PINNED_RESERVATION = unchecked((Int32)0xc01a0030);
        public const Int32 STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD = unchecked((Int32)0xc01b00ea);
        public const Int32 STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD_RECOVERED = unchecked((Int32)0x801b00eb);
        public const Int32 STATUS_VIDEO_DRIVER_DEBUG_REPORT_REQUEST = unchecked((Int32)0x401b00ec);
        public const Int32 STATUS_MONITOR_NO_DESCRIPTOR = unchecked((Int32)0xc01d0001);
        public const Int32 STATUS_MONITOR_UNKNOWN_DESCRIPTOR_FORMAT = unchecked((Int32)0xc01d0002);
        public const Int32 STATUS_MONITOR_INVALID_DESCRIPTOR_CHECKSUM = unchecked((Int32)0xc01d0003);
        public const Int32 STATUS_MONITOR_INVALID_STANDARD_TIMING_BLOCK = unchecked((Int32)0xc01d0004);
        public const Int32 STATUS_MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED = unchecked((Int32)0xc01d0005);
        public const Int32 STATUS_MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK = unchecked((Int32)0xc01d0006);
        public const Int32 STATUS_MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK = unchecked((Int32)0xc01d0007);
        public const Int32 STATUS_MONITOR_NO_MORE_DESCRIPTOR_DATA = unchecked((Int32)0xc01d0008);
        public const Int32 STATUS_MONITOR_INVALID_DETAILED_TIMING_BLOCK = unchecked((Int32)0xc01d0009);
        public const Int32 STATUS_MONITOR_INVALID_MANUFACTURE_DATE = unchecked((Int32)0xc01d000a);
        public const Int32 STATUS_GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER = unchecked((Int32)0xc01e0000);
        public const Int32 STATUS_GRAPHICS_INSUFFICIENT_DMA_BUFFER = unchecked((Int32)0xc01e0001);
        public const Int32 STATUS_GRAPHICS_INVALID_DISPLAY_ADAPTER = unchecked((Int32)0xc01e0002);
        public const Int32 STATUS_GRAPHICS_ADAPTER_WAS_RESET = unchecked((Int32)0xc01e0003);
        public const Int32 STATUS_GRAPHICS_INVALID_DRIVER_MODEL = unchecked((Int32)0xc01e0004);
        public const Int32 STATUS_GRAPHICS_PRESENT_MODE_CHANGED = unchecked((Int32)0xc01e0005);
        public const Int32 STATUS_GRAPHICS_PRESENT_OCCLUDED = unchecked((Int32)0xc01e0006);
        public const Int32 STATUS_GRAPHICS_PRESENT_DENIED = unchecked((Int32)0xc01e0007);
        public const Int32 STATUS_GRAPHICS_CANNOTCOLORCONVERT = unchecked((Int32)0xc01e0008);
        public const Int32 STATUS_GRAPHICS_DRIVER_MISMATCH = unchecked((Int32)0xc01e0009);
        public const Int32 STATUS_GRAPHICS_PARTIAL_DATA_POPULATED = unchecked((Int32)0x401e000a);
        public const Int32 STATUS_GRAPHICS_PRESENT_REDIRECTION_DISABLED = unchecked((Int32)0xc01e000b);
        public const Int32 STATUS_GRAPHICS_PRESENT_UNOCCLUDED = unchecked((Int32)0xc01e000c);
        public const Int32 STATUS_GRAPHICS_WINDOWDC_NOT_AVAILABLE = unchecked((Int32)0xc01e000d);
        public const Int32 STATUS_GRAPHICS_WINDOWLESS_PRESENT_DISABLED = unchecked((Int32)0xc01e000e);
        public const Int32 STATUS_GRAPHICS_NO_VIDEO_MEMORY = unchecked((Int32)0xc01e0100);
        public const Int32 STATUS_GRAPHICS_CANT_LOCK_MEMORY = unchecked((Int32)0xc01e0101);
        public const Int32 STATUS_GRAPHICS_ALLOCATION_BUSY = unchecked((Int32)0xc01e0102);
        public const Int32 STATUS_GRAPHICS_TOO_MANY_REFERENCES = unchecked((Int32)0xc01e0103);
        public const Int32 STATUS_GRAPHICS_TRY_AGAIN_LATER = unchecked((Int32)0xc01e0104);
        public const Int32 STATUS_GRAPHICS_TRY_AGAIN_NOW = unchecked((Int32)0xc01e0105);
        public const Int32 STATUS_GRAPHICS_ALLOCATION_INVALID = unchecked((Int32)0xc01e0106);
        public const Int32 STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE = unchecked((Int32)0xc01e0107);
        public const Int32 STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED = unchecked((Int32)0xc01e0108);
        public const Int32 STATUS_GRAPHICS_CANT_EVICT_PINNED_ALLOCATION = unchecked((Int32)0xc01e0109);
        public const Int32 STATUS_GRAPHICS_INVALID_ALLOCATION_USAGE = unchecked((Int32)0xc01e0110);
        public const Int32 STATUS_GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION = unchecked((Int32)0xc01e0111);
        public const Int32 STATUS_GRAPHICS_ALLOCATION_CLOSED = unchecked((Int32)0xc01e0112);
        public const Int32 STATUS_GRAPHICS_INVALID_ALLOCATION_INSTANCE = unchecked((Int32)0xc01e0113);
        public const Int32 STATUS_GRAPHICS_INVALID_ALLOCATION_HANDLE = unchecked((Int32)0xc01e0114);
        public const Int32 STATUS_GRAPHICS_WRONG_ALLOCATION_DEVICE = unchecked((Int32)0xc01e0115);
        public const Int32 STATUS_GRAPHICS_ALLOCATION_CONTENT_LOST = unchecked((Int32)0xc01e0116);
        public const Int32 STATUS_GRAPHICS_GPU_EXCEPTION_ON_DEVICE = unchecked((Int32)0xc01e0200);
        public const Int32 STATUS_GRAPHICS_SKIP_ALLOCATION_PREPARATION = unchecked((Int32)0x401e0201);
        public const Int32 STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY = unchecked((Int32)0xc01e0300);
        public const Int32 STATUS_GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED = unchecked((Int32)0xc01e0301);
        public const Int32 STATUS_GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED = unchecked((Int32)0xc01e0302);
        public const Int32 STATUS_GRAPHICS_INVALID_VIDPN = unchecked((Int32)0xc01e0303);
        public const Int32 STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE = unchecked((Int32)0xc01e0304);
        public const Int32 STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET = unchecked((Int32)0xc01e0305);
        public const Int32 STATUS_GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED = unchecked((Int32)0xc01e0306);
        public const Int32 STATUS_GRAPHICS_MODE_NOT_PINNED = unchecked((Int32)0x401e0307);
        public const Int32 STATUS_GRAPHICS_INVALID_VIDPN_SOURCEMODESET = unchecked((Int32)0xc01e0308);
        public const Int32 STATUS_GRAPHICS_INVALID_VIDPN_TARGETMODESET = unchecked((Int32)0xc01e0309);
        public const Int32 STATUS_GRAPHICS_INVALID_FREQUENCY = unchecked((Int32)0xc01e030a);
        public const Int32 STATUS_GRAPHICS_INVALID_ACTIVE_REGION = unchecked((Int32)0xc01e030b);
        public const Int32 STATUS_GRAPHICS_INVALID_TOTAL_REGION = unchecked((Int32)0xc01e030c);
        public const Int32 STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE = unchecked((Int32)0xc01e0310);
        public const Int32 STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE = unchecked((Int32)0xc01e0311);
        public const Int32 STATUS_GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET = unchecked((Int32)0xc01e0312);
        public const Int32 STATUS_GRAPHICS_PATH_ALREADY_IN_TOPOLOGY = unchecked((Int32)0xc01e0313);
        public const Int32 STATUS_GRAPHICS_MODE_ALREADY_IN_MODESET = unchecked((Int32)0xc01e0314);
        public const Int32 STATUS_GRAPHICS_INVALID_VIDEOPRESENTSOURCESET = unchecked((Int32)0xc01e0315);
        public const Int32 STATUS_GRAPHICS_INVALID_VIDEOPRESENTTARGETSET = unchecked((Int32)0xc01e0316);
        public const Int32 STATUS_GRAPHICS_SOURCE_ALREADY_IN_SET = unchecked((Int32)0xc01e0317);
        public const Int32 STATUS_GRAPHICS_TARGET_ALREADY_IN_SET = unchecked((Int32)0xc01e0318);
        public const Int32 STATUS_GRAPHICS_INVALID_VIDPN_PRESENT_PATH = unchecked((Int32)0xc01e0319);
        public const Int32 STATUS_GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY = unchecked((Int32)0xc01e031a);
        public const Int32 STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET = unchecked((Int32)0xc01e031b);
        public const Int32 STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE = unchecked((Int32)0xc01e031c);
        public const Int32 STATUS_GRAPHICS_FREQUENCYRANGE_NOT_IN_SET = unchecked((Int32)0xc01e031d);
        public const Int32 STATUS_GRAPHICS_NO_PREFERRED_MODE = unchecked((Int32)0x401e031e);
        public const Int32 STATUS_GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET = unchecked((Int32)0xc01e031f);
        public const Int32 STATUS_GRAPHICS_STALE_MODESET = unchecked((Int32)0xc01e0320);
        public const Int32 STATUS_GRAPHICS_INVALID_MONITOR_SOURCEMODESET = unchecked((Int32)0xc01e0321);
        public const Int32 STATUS_GRAPHICS_INVALID_MONITOR_SOURCE_MODE = unchecked((Int32)0xc01e0322);
        public const Int32 STATUS_GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN = unchecked((Int32)0xc01e0323);
        public const Int32 STATUS_GRAPHICS_MODE_ID_MUST_BE_UNIQUE = unchecked((Int32)0xc01e0324);
        public const Int32 STATUS_GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION = unchecked((Int32)0xc01e0325);
        public const Int32 STATUS_GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES = unchecked((Int32)0xc01e0326);
        public const Int32 STATUS_GRAPHICS_PATH_NOT_IN_TOPOLOGY = unchecked((Int32)0xc01e0327);
        public const Int32 STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE = unchecked((Int32)0xc01e0328);
        public const Int32 STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET = unchecked((Int32)0xc01e0329);
        public const Int32 STATUS_GRAPHICS_INVALID_MONITORDESCRIPTORSET = unchecked((Int32)0xc01e032a);
        public const Int32 STATUS_GRAPHICS_INVALID_MONITORDESCRIPTOR = unchecked((Int32)0xc01e032b);
        public const Int32 STATUS_GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET = unchecked((Int32)0xc01e032c);
        public const Int32 STATUS_GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET = unchecked((Int32)0xc01e032d);
        public const Int32 STATUS_GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE = unchecked((Int32)0xc01e032e);
        public const Int32 STATUS_GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE = unchecked((Int32)0xc01e032f);
        public const Int32 STATUS_GRAPHICS_RESOURCES_NOT_RELATED = unchecked((Int32)0xc01e0330);
        public const Int32 STATUS_GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE = unchecked((Int32)0xc01e0331);
        public const Int32 STATUS_GRAPHICS_TARGET_ID_MUST_BE_UNIQUE = unchecked((Int32)0xc01e0332);
        public const Int32 STATUS_GRAPHICS_NO_AVAILABLE_VIDPN_TARGET = unchecked((Int32)0xc01e0333);
        public const Int32 STATUS_GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER = unchecked((Int32)0xc01e0334);
        public const Int32 STATUS_GRAPHICS_NO_VIDPNMGR = unchecked((Int32)0xc01e0335);
        public const Int32 STATUS_GRAPHICS_NO_ACTIVE_VIDPN = unchecked((Int32)0xc01e0336);
        public const Int32 STATUS_GRAPHICS_STALE_VIDPN_TOPOLOGY = unchecked((Int32)0xc01e0337);
        public const Int32 STATUS_GRAPHICS_MONITOR_NOT_CONNECTED = unchecked((Int32)0xc01e0338);
        public const Int32 STATUS_GRAPHICS_SOURCE_NOT_IN_TOPOLOGY = unchecked((Int32)0xc01e0339);
        public const Int32 STATUS_GRAPHICS_INVALID_PRIMARYSURFACE_SIZE = unchecked((Int32)0xc01e033a);
        public const Int32 STATUS_GRAPHICS_INVALID_VISIBLEREGION_SIZE = unchecked((Int32)0xc01e033b);
        public const Int32 STATUS_GRAPHICS_INVALID_STRIDE = unchecked((Int32)0xc01e033c);
        public const Int32 STATUS_GRAPHICS_INVALID_PIXELFORMAT = unchecked((Int32)0xc01e033d);
        public const Int32 STATUS_GRAPHICS_INVALID_COLORBASIS = unchecked((Int32)0xc01e033e);
        public const Int32 STATUS_GRAPHICS_INVALID_PIXELVALUEACCESSMODE = unchecked((Int32)0xc01e033f);
        public const Int32 STATUS_GRAPHICS_TARGET_NOT_IN_TOPOLOGY = unchecked((Int32)0xc01e0340);
        public const Int32 STATUS_GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT = unchecked((Int32)0xc01e0341);
        public const Int32 STATUS_GRAPHICS_VIDPN_SOURCE_IN_USE = unchecked((Int32)0xc01e0342);
        public const Int32 STATUS_GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN = unchecked((Int32)0xc01e0343);
        public const Int32 STATUS_GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL = unchecked((Int32)0xc01e0344);
        public const Int32 STATUS_GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION = unchecked((Int32)0xc01e0345);
        public const Int32 STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED = unchecked((Int32)0xc01e0346);
        public const Int32 STATUS_GRAPHICS_INVALID_GAMMA_RAMP = unchecked((Int32)0xc01e0347);
        public const Int32 STATUS_GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED = unchecked((Int32)0xc01e0348);
        public const Int32 STATUS_GRAPHICS_MULTISAMPLING_NOT_SUPPORTED = unchecked((Int32)0xc01e0349);
        public const Int32 STATUS_GRAPHICS_MODE_NOT_IN_MODESET = unchecked((Int32)0xc01e034a);
        public const Int32 STATUS_GRAPHICS_DATASET_IS_EMPTY = unchecked((Int32)0x401e034b);
        public const Int32 STATUS_GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET = unchecked((Int32)0x401e034c);
        public const Int32 STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON = unchecked((Int32)0xc01e034d);
        public const Int32 STATUS_GRAPHICS_INVALID_PATH_CONTENT_TYPE = unchecked((Int32)0xc01e034e);
        public const Int32 STATUS_GRAPHICS_INVALID_COPYPROTECTION_TYPE = unchecked((Int32)0xc01e034f);
        public const Int32 STATUS_GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS = unchecked((Int32)0xc01e0350);
        public const Int32 STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED = unchecked((Int32)0x401e0351);
        public const Int32 STATUS_GRAPHICS_INVALID_SCANLINE_ORDERING = unchecked((Int32)0xc01e0352);
        public const Int32 STATUS_GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED = unchecked((Int32)0xc01e0353);
        public const Int32 STATUS_GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS = unchecked((Int32)0xc01e0354);
        public const Int32 STATUS_GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT = unchecked((Int32)0xc01e0355);
        public const Int32 STATUS_GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM = unchecked((Int32)0xc01e0356);
        public const Int32 STATUS_GRAPHICS_INVALID_MONITOR_CAPABILITY_ORIGIN = unchecked((Int32)0xc01e0357);
        public const Int32 STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE_CONSTRAINT = unchecked((Int32)0xc01e0358);
        public const Int32 STATUS_GRAPHICS_MAX_NUM_PATHS_REACHED = unchecked((Int32)0xc01e0359);
        public const Int32 STATUS_GRAPHICS_CANCEL_VIDPN_TOPOLOGY_AUGMENTATION = unchecked((Int32)0xc01e035a);
        public const Int32 STATUS_GRAPHICS_INVALID_CLIENT_TYPE = unchecked((Int32)0xc01e035b);
        public const Int32 STATUS_GRAPHICS_CLIENTVIDPN_NOT_SET = unchecked((Int32)0xc01e035c);
        public const Int32 STATUS_GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED = unchecked((Int32)0xc01e0400);
        public const Int32 STATUS_GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED = unchecked((Int32)0xc01e0401);
        public const Int32 STATUS_GRAPHICS_UNKNOWN_CHILD_STATUS = unchecked((Int32)0x401e042f);
        public const Int32 STATUS_GRAPHICS_NOT_A_LINKED_ADAPTER = unchecked((Int32)0xc01e0430);
        public const Int32 STATUS_GRAPHICS_LEADLINK_NOT_ENUMERATED = unchecked((Int32)0xc01e0431);
        public const Int32 STATUS_GRAPHICS_CHAINLINKS_NOT_ENUMERATED = unchecked((Int32)0xc01e0432);
        public const Int32 STATUS_GRAPHICS_ADAPTER_CHAIN_NOT_READY = unchecked((Int32)0xc01e0433);
        public const Int32 STATUS_GRAPHICS_CHAINLINKS_NOT_STARTED = unchecked((Int32)0xc01e0434);
        public const Int32 STATUS_GRAPHICS_CHAINLINKS_NOT_POWERED_ON = unchecked((Int32)0xc01e0435);
        public const Int32 STATUS_GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE = unchecked((Int32)0xc01e0436);
        public const Int32 STATUS_GRAPHICS_LEADLINK_START_DEFERRED = unchecked((Int32)0x401e0437);
        public const Int32 STATUS_GRAPHICS_NOT_POST_DEVICE_DRIVER = unchecked((Int32)0xc01e0438);
        public const Int32 STATUS_GRAPHICS_POLLING_TOO_FREQUENTLY = unchecked((Int32)0x401e0439);
        public const Int32 STATUS_GRAPHICS_START_DEFERRED = unchecked((Int32)0x401e043a);
        public const Int32 STATUS_GRAPHICS_ADAPTER_ACCESS_NOT_EXCLUDED = unchecked((Int32)0xc01e043b);
        public const Int32 STATUS_GRAPHICS_DEPENDABLE_CHILD_STATUS = unchecked((Int32)0x401e043c);
        public const Int32 STATUS_GRAPHICS_OPM_NOT_SUPPORTED = unchecked((Int32)0xc01e0500);
        public const Int32 STATUS_GRAPHICS_COPP_NOT_SUPPORTED = unchecked((Int32)0xc01e0501);
        public const Int32 STATUS_GRAPHICS_UAB_NOT_SUPPORTED = unchecked((Int32)0xc01e0502);
        public const Int32 STATUS_GRAPHICS_OPM_INVALID_ENCRYPTED_PARAMETERS = unchecked((Int32)0xc01e0503);
        public const Int32 STATUS_GRAPHICS_OPM_NO_PROTECTED_OUTPUTS_EXIST = unchecked((Int32)0xc01e0505);
        public const Int32 STATUS_GRAPHICS_OPM_INTERNAL_ERROR = unchecked((Int32)0xc01e050b);
        public const Int32 STATUS_GRAPHICS_OPM_INVALID_HANDLE = unchecked((Int32)0xc01e050c);
        public const Int32 STATUS_GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH = unchecked((Int32)0xc01e050e);
        public const Int32 STATUS_GRAPHICS_OPM_SPANNING_MODE_ENABLED = unchecked((Int32)0xc01e050f);
        public const Int32 STATUS_GRAPHICS_OPM_THEATER_MODE_ENABLED = unchecked((Int32)0xc01e0510);
        public const Int32 STATUS_GRAPHICS_PVP_HFS_FAILED = unchecked((Int32)0xc01e0511);
        public const Int32 STATUS_GRAPHICS_OPM_INVALID_SRM = unchecked((Int32)0xc01e0512);
        public const Int32 STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP = unchecked((Int32)0xc01e0513);
        public const Int32 STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP = unchecked((Int32)0xc01e0514);
        public const Int32 STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA = unchecked((Int32)0xc01e0515);
        public const Int32 STATUS_GRAPHICS_OPM_HDCP_SRM_NEVER_SET = unchecked((Int32)0xc01e0516);
        public const Int32 STATUS_GRAPHICS_OPM_RESOLUTION_TOO_HIGH = unchecked((Int32)0xc01e0517);
        public const Int32 STATUS_GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE = unchecked((Int32)0xc01e0518);
        public const Int32 STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_NO_LONGER_EXISTS = unchecked((Int32)0xc01e051a);
        public const Int32 STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_COPP_SEMANTICS = unchecked((Int32)0xc01e051c);
        public const Int32 STATUS_GRAPHICS_OPM_INVALID_INFORMATION_REQUEST = unchecked((Int32)0xc01e051d);
        public const Int32 STATUS_GRAPHICS_OPM_DRIVER_INTERNAL_ERROR = unchecked((Int32)0xc01e051e);
        public const Int32 STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_OPM_SEMANTICS = unchecked((Int32)0xc01e051f);
        public const Int32 STATUS_GRAPHICS_OPM_SIGNALING_NOT_SUPPORTED = unchecked((Int32)0xc01e0520);
        public const Int32 STATUS_GRAPHICS_OPM_INVALID_CONFIGURATION_REQUEST = unchecked((Int32)0xc01e0521);
        public const Int32 STATUS_GRAPHICS_I2C_NOT_SUPPORTED = unchecked((Int32)0xc01e0580);
        public const Int32 STATUS_GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST = unchecked((Int32)0xc01e0581);
        public const Int32 STATUS_GRAPHICS_I2C_ERROR_TRANSMITTING_DATA = unchecked((Int32)0xc01e0582);
        public const Int32 STATUS_GRAPHICS_I2C_ERROR_RECEIVING_DATA = unchecked((Int32)0xc01e0583);
        public const Int32 STATUS_GRAPHICS_DDCCI_VCP_NOT_SUPPORTED = unchecked((Int32)0xc01e0584);
        public const Int32 STATUS_GRAPHICS_DDCCI_INVALID_DATA = unchecked((Int32)0xc01e0585);
        public const Int32 STATUS_GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE = unchecked((Int32)0xc01e0586);
        public const Int32 STATUS_GRAPHICS_DDCCI_INVALID_CAPABILITIES_STRING = unchecked((Int32)0xc01e0587);
        public const Int32 STATUS_GRAPHICS_MCA_INTERNAL_ERROR = unchecked((Int32)0xc01e0588);
        public const Int32 STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND = unchecked((Int32)0xc01e0589);
        public const Int32 STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH = unchecked((Int32)0xc01e058a);
        public const Int32 STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM = unchecked((Int32)0xc01e058b);
        public const Int32 STATUS_GRAPHICS_INVALID_PHYSICAL_MONITOR_HANDLE = unchecked((Int32)0xc01e058c);
        public const Int32 STATUS_GRAPHICS_MONITOR_NO_LONGER_EXISTS = unchecked((Int32)0xc01e058d);
        public const Int32 STATUS_GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED = unchecked((Int32)0xc01e05e0);
        public const Int32 STATUS_GRAPHICS_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME = unchecked((Int32)0xc01e05e1);
        public const Int32 STATUS_GRAPHICS_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP = unchecked((Int32)0xc01e05e2);
        public const Int32 STATUS_GRAPHICS_MIRRORING_DEVICES_NOT_SUPPORTED = unchecked((Int32)0xc01e05e3);
        public const Int32 STATUS_GRAPHICS_INVALID_POINTER = unchecked((Int32)0xc01e05e4);
        public const Int32 STATUS_GRAPHICS_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE = unchecked((Int32)0xc01e05e5);
        public const Int32 STATUS_GRAPHICS_PARAMETER_ARRAY_TOO_SMALL = unchecked((Int32)0xc01e05e6);
        public const Int32 STATUS_GRAPHICS_INTERNAL_ERROR = unchecked((Int32)0xc01e05e7);
        public const Int32 STATUS_GRAPHICS_SESSION_TYPE_CHANGE_IN_PROGRESS = unchecked((Int32)0xc01e05e8);
        public const Int32 STATUS_FVE_LOCKED_VOLUME = unchecked((Int32)0xc0210000);
        public const Int32 STATUS_FVE_NOT_ENCRYPTED = unchecked((Int32)0xc0210001);
        public const Int32 STATUS_FVE_BAD_INFORMATION = unchecked((Int32)0xc0210002);
        public const Int32 STATUS_FVE_TOO_SMALL = unchecked((Int32)0xc0210003);
        public const Int32 STATUS_FVE_FAILED_WRONG_FS = unchecked((Int32)0xc0210004);
        public const Int32 STATUS_FVE_BAD_PARTITION_SIZE = unchecked((Int32)0xc0210005);
        public const Int32 STATUS_FVE_FS_NOT_EXTENDED = unchecked((Int32)0xc0210006);
        public const Int32 STATUS_FVE_FS_MOUNTED = unchecked((Int32)0xc0210007);
        public const Int32 STATUS_FVE_NO_LICENSE = unchecked((Int32)0xc0210008);
        public const Int32 STATUS_FVE_ACTION_NOT_ALLOWED = unchecked((Int32)0xc0210009);
        public const Int32 STATUS_FVE_BAD_DATA = unchecked((Int32)0xc021000a);
        public const Int32 STATUS_FVE_VOLUME_NOT_BOUND = unchecked((Int32)0xc021000b);
        public const Int32 STATUS_FVE_NOT_DATA_VOLUME = unchecked((Int32)0xc021000c);
        public const Int32 STATUS_FVE_CONV_READ_ERROR = unchecked((Int32)0xc021000d);
        public const Int32 STATUS_FVE_CONV_WRITE_ERROR = unchecked((Int32)0xc021000e);
        public const Int32 STATUS_FVE_OVERLAPPED_UPDATE = unchecked((Int32)0xc021000f);
        public const Int32 STATUS_FVE_FAILED_SECTOR_SIZE = unchecked((Int32)0xc0210010);
        public const Int32 STATUS_FVE_FAILED_AUTHENTICATION = unchecked((Int32)0xc0210011);
        public const Int32 STATUS_FVE_NOT_OS_VOLUME = unchecked((Int32)0xc0210012);
        public const Int32 STATUS_FVE_KEYFILE_NOT_FOUND = unchecked((Int32)0xc0210013);
        public const Int32 STATUS_FVE_KEYFILE_INVALID = unchecked((Int32)0xc0210014);
        public const Int32 STATUS_FVE_KEYFILE_NO_VMK = unchecked((Int32)0xc0210015);
        public const Int32 STATUS_FVE_TPM_DISABLED = unchecked((Int32)0xc0210016);
        public const Int32 STATUS_FVE_TPM_SRK_AUTH_NOT_ZERO = unchecked((Int32)0xc0210017);
        public const Int32 STATUS_FVE_TPM_INVALID_PCR = unchecked((Int32)0xc0210018);
        public const Int32 STATUS_FVE_TPM_NO_VMK = unchecked((Int32)0xc0210019);
        public const Int32 STATUS_FVE_PIN_INVALID = unchecked((Int32)0xc021001a);
        public const Int32 STATUS_FVE_AUTH_INVALID_APPLICATION = unchecked((Int32)0xc021001b);
        public const Int32 STATUS_FVE_AUTH_INVALID_CONFIG = unchecked((Int32)0xc021001c);
        public const Int32 STATUS_FVE_DEBUGGER_ENABLED = unchecked((Int32)0xc021001d);
        public const Int32 STATUS_FVE_DRY_RUN_FAILED = unchecked((Int32)0xc021001e);
        public const Int32 STATUS_FVE_BAD_METADATA_POINTER = unchecked((Int32)0xc021001f);
        public const Int32 STATUS_FVE_OLD_METADATA_COPY = unchecked((Int32)0xc0210020);
        public const Int32 STATUS_FVE_REBOOT_REQUIRED = unchecked((Int32)0xc0210021);
        public const Int32 STATUS_FVE_RAW_ACCESS = unchecked((Int32)0xc0210022);
        public const Int32 STATUS_FVE_RAW_BLOCKED = unchecked((Int32)0xc0210023);
        public const Int32 STATUS_FVE_NO_AUTOUNLOCK_MASTER_KEY = unchecked((Int32)0xc0210024);
        public const Int32 STATUS_FVE_MOR_FAILED = unchecked((Int32)0xc0210025);
        public const Int32 STATUS_FVE_NO_FEATURE_LICENSE = unchecked((Int32)0xc0210026);
        public const Int32 STATUS_FVE_POLICY_USER_DISABLE_RDV_NOT_ALLOWED = unchecked((Int32)0xc0210027);
        public const Int32 STATUS_FVE_CONV_RECOVERY_FAILED = unchecked((Int32)0xc0210028);
        public const Int32 STATUS_FVE_VIRTUALIZED_SPACE_TOO_BIG = unchecked((Int32)0xc0210029);
        public const Int32 STATUS_FVE_INVALID_DATUM_TYPE = unchecked((Int32)0xc021002a);
        public const Int32 STATUS_FVE_VOLUME_TOO_SMALL = unchecked((Int32)0xc0210030);
        public const Int32 STATUS_FVE_ENH_PIN_INVALID = unchecked((Int32)0xc0210031);
        public const Int32 STATUS_FVE_FULL_ENCRYPTION_NOT_ALLOWED_ON_TP_STORAGE = unchecked((Int32)0xc0210032);
        public const Int32 STATUS_FVE_WIPE_NOT_ALLOWED_ON_TP_STORAGE = unchecked((Int32)0xc0210033);
        public const Int32 STATUS_FVE_NOT_ALLOWED_ON_CSV_STACK = unchecked((Int32)0xc0210034);
        public const Int32 STATUS_FVE_NOT_ALLOWED_ON_CLUSTER = unchecked((Int32)0xc0210035);
        public const Int32 STATUS_FVE_NOT_ALLOWED_TO_UPGRADE_WHILE_CONVERTING = unchecked((Int32)0xc0210036);
        public const Int32 STATUS_FVE_WIPE_CANCEL_NOT_APPLICABLE = unchecked((Int32)0xc0210037);
        public const Int32 STATUS_FVE_EDRIVE_DRY_RUN_FAILED = unchecked((Int32)0xc0210038);
        public const Int32 STATUS_FVE_SECUREBOOT_DISABLED = unchecked((Int32)0xc0210039);
        public const Int32 STATUS_FVE_SECUREBOOT_CONFIG_CHANGE = unchecked((Int32)0xc021003a);
        public const Int32 STATUS_FVE_DEVICE_LOCKEDOUT = unchecked((Int32)0xc021003b);
        public const Int32 STATUS_FVE_VOLUME_EXTEND_PREVENTS_EOW_DECRYPT = unchecked((Int32)0xc021003c);
        public const Int32 STATUS_FVE_NOT_DE_VOLUME = unchecked((Int32)0xc021003d);
        public const Int32 STATUS_FVE_PROTECTION_DISABLED = unchecked((Int32)0xc021003e);
        public const Int32 STATUS_FVE_PROTECTION_CANNOT_BE_DISABLED = unchecked((Int32)0xc021003f);
        public const Int32 STATUS_FWP_CALLOUT_NOT_FOUND = unchecked((Int32)0xc0220001);
        public const Int32 STATUS_FWP_CONDITION_NOT_FOUND = unchecked((Int32)0xc0220002);
        public const Int32 STATUS_FWP_FILTER_NOT_FOUND = unchecked((Int32)0xc0220003);
        public const Int32 STATUS_FWP_LAYER_NOT_FOUND = unchecked((Int32)0xc0220004);
        public const Int32 STATUS_FWP_PROVIDER_NOT_FOUND = unchecked((Int32)0xc0220005);
        public const Int32 STATUS_FWP_PROVIDER_CONTEXT_NOT_FOUND = unchecked((Int32)0xc0220006);
        public const Int32 STATUS_FWP_SUBLAYER_NOT_FOUND = unchecked((Int32)0xc0220007);
        public const Int32 STATUS_FWP_NOT_FOUND = unchecked((Int32)0xc0220008);
        public const Int32 STATUS_FWP_ALREADY_EXISTS = unchecked((Int32)0xc0220009);
        public const Int32 STATUS_FWP_IN_USE = unchecked((Int32)0xc022000a);
        public const Int32 STATUS_FWP_DYNAMIC_SESSION_IN_PROGRESS = unchecked((Int32)0xc022000b);
        public const Int32 STATUS_FWP_WRONG_SESSION = unchecked((Int32)0xc022000c);
        public const Int32 STATUS_FWP_NO_TXN_IN_PROGRESS = unchecked((Int32)0xc022000d);
        public const Int32 STATUS_FWP_TXN_IN_PROGRESS = unchecked((Int32)0xc022000e);
        public const Int32 STATUS_FWP_TXN_ABORTED = unchecked((Int32)0xc022000f);
        public const Int32 STATUS_FWP_SESSION_ABORTED = unchecked((Int32)0xc0220010);
        public const Int32 STATUS_FWP_INCOMPATIBLE_TXN = unchecked((Int32)0xc0220011);
        public const Int32 STATUS_FWP_TIMEOUT = unchecked((Int32)0xc0220012);
        public const Int32 STATUS_FWP_NET_EVENTS_DISABLED = unchecked((Int32)0xc0220013);
        public const Int32 STATUS_FWP_INCOMPATIBLE_LAYER = unchecked((Int32)0xc0220014);
        public const Int32 STATUS_FWP_KM_CLIENTS_ONLY = unchecked((Int32)0xc0220015);
        public const Int32 STATUS_FWP_LIFETIME_MISMATCH = unchecked((Int32)0xc0220016);
        public const Int32 STATUS_FWP_BUILTIN_OBJECT = unchecked((Int32)0xc0220017);
        public const Int32 STATUS_FWP_TOO_MANY_CALLOUTS = unchecked((Int32)0xc0220018);
        public const Int32 STATUS_FWP_NOTIFICATION_DROPPED = unchecked((Int32)0xc0220019);
        public const Int32 STATUS_FWP_TRAFFIC_MISMATCH = unchecked((Int32)0xc022001a);
        public const Int32 STATUS_FWP_INCOMPATIBLE_SA_STATE = unchecked((Int32)0xc022001b);
        public const Int32 STATUS_FWP_NULL_POINTER = unchecked((Int32)0xc022001c);
        public const Int32 STATUS_FWP_INVALID_ENUMERATOR = unchecked((Int32)0xc022001d);
        public const Int32 STATUS_FWP_INVALID_FLAGS = unchecked((Int32)0xc022001e);
        public const Int32 STATUS_FWP_INVALID_NET_MASK = unchecked((Int32)0xc022001f);
        public const Int32 STATUS_FWP_INVALID_RANGE = unchecked((Int32)0xc0220020);
        public const Int32 STATUS_FWP_INVALID_INTERVAL = unchecked((Int32)0xc0220021);
        public const Int32 STATUS_FWP_ZERO_LENGTH_ARRAY = unchecked((Int32)0xc0220022);
        public const Int32 STATUS_FWP_NULL_DISPLAY_NAME = unchecked((Int32)0xc0220023);
        public const Int32 STATUS_FWP_INVALID_ACTION_TYPE = unchecked((Int32)0xc0220024);
        public const Int32 STATUS_FWP_INVALID_WEIGHT = unchecked((Int32)0xc0220025);
        public const Int32 STATUS_FWP_MATCH_TYPE_MISMATCH = unchecked((Int32)0xc0220026);
        public const Int32 STATUS_FWP_TYPE_MISMATCH = unchecked((Int32)0xc0220027);
        public const Int32 STATUS_FWP_OUT_OF_BOUNDS = unchecked((Int32)0xc0220028);
        public const Int32 STATUS_FWP_RESERVED = unchecked((Int32)0xc0220029);
        public const Int32 STATUS_FWP_DUPLICATE_CONDITION = unchecked((Int32)0xc022002a);
        public const Int32 STATUS_FWP_DUPLICATE_KEYMOD = unchecked((Int32)0xc022002b);
        public const Int32 STATUS_FWP_ACTION_INCOMPATIBLE_WITH_LAYER = unchecked((Int32)0xc022002c);
        public const Int32 STATUS_FWP_ACTION_INCOMPATIBLE_WITH_SUBLAYER = unchecked((Int32)0xc022002d);
        public const Int32 STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_LAYER = unchecked((Int32)0xc022002e);
        public const Int32 STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_CALLOUT = unchecked((Int32)0xc022002f);
        public const Int32 STATUS_FWP_INCOMPATIBLE_AUTH_METHOD = unchecked((Int32)0xc0220030);
        public const Int32 STATUS_FWP_INCOMPATIBLE_DH_GROUP = unchecked((Int32)0xc0220031);
        public const Int32 STATUS_FWP_EM_NOT_SUPPORTED = unchecked((Int32)0xc0220032);
        public const Int32 STATUS_FWP_NEVER_MATCH = unchecked((Int32)0xc0220033);
        public const Int32 STATUS_FWP_PROVIDER_CONTEXT_MISMATCH = unchecked((Int32)0xc0220034);
        public const Int32 STATUS_FWP_INVALID_PARAMETER = unchecked((Int32)0xc0220035);
        public const Int32 STATUS_FWP_TOO_MANY_SUBLAYERS = unchecked((Int32)0xc0220036);
        public const Int32 STATUS_FWP_CALLOUT_NOTIFICATION_FAILED = unchecked((Int32)0xc0220037);
        public const Int32 STATUS_FWP_INVALID_AUTH_TRANSFORM = unchecked((Int32)0xc0220038);
        public const Int32 STATUS_FWP_INVALID_CIPHER_TRANSFORM = unchecked((Int32)0xc0220039);
        public const Int32 STATUS_FWP_INCOMPATIBLE_CIPHER_TRANSFORM = unchecked((Int32)0xc022003a);
        public const Int32 STATUS_FWP_INVALID_TRANSFORM_COMBINATION = unchecked((Int32)0xc022003b);
        public const Int32 STATUS_FWP_DUPLICATE_AUTH_METHOD = unchecked((Int32)0xc022003c);
        public const Int32 STATUS_FWP_INVALID_TUNNEL_ENDPOINT = unchecked((Int32)0xc022003d);
        public const Int32 STATUS_FWP_L2_DRIVER_NOT_READY = unchecked((Int32)0xc022003e);
        public const Int32 STATUS_FWP_KEY_DICTATOR_ALREADY_REGISTERED = unchecked((Int32)0xc022003f);
        public const Int32 STATUS_FWP_KEY_DICTATION_INVALID_KEYING_MATERIAL = unchecked((Int32)0xc0220040);
        public const Int32 STATUS_FWP_CONNECTIONS_DISABLED = unchecked((Int32)0xc0220041);
        public const Int32 STATUS_FWP_INVALID_DNS_NAME = unchecked((Int32)0xc0220042);
        public const Int32 STATUS_FWP_STILL_ON = unchecked((Int32)0xc0220043);
        public const Int32 STATUS_FWP_IKEEXT_NOT_RUNNING = unchecked((Int32)0xc0220044);
        public const Int32 STATUS_FWP_TCPIP_NOT_READY = unchecked((Int32)0xc0220100);
        public const Int32 STATUS_FWP_INJECT_HANDLE_CLOSING = unchecked((Int32)0xc0220101);
        public const Int32 STATUS_FWP_INJECT_HANDLE_STALE = unchecked((Int32)0xc0220102);
        public const Int32 STATUS_FWP_CANNOT_PEND = unchecked((Int32)0xc0220103);
        public const Int32 STATUS_FWP_DROP_NOICMP = unchecked((Int32)0xc0220104);
        public const Int32 STATUS_NDIS_CLOSING = unchecked((Int32)0xc0230002);
        public const Int32 STATUS_NDIS_BAD_VERSION = unchecked((Int32)0xc0230004);
        public const Int32 STATUS_NDIS_BAD_CHARACTERISTICS = unchecked((Int32)0xc0230005);
        public const Int32 STATUS_NDIS_ADAPTER_NOT_FOUND = unchecked((Int32)0xc0230006);
        public const Int32 STATUS_NDIS_OPEN_FAILED = unchecked((Int32)0xc0230007);
        public const Int32 STATUS_NDIS_DEVICE_FAILED = unchecked((Int32)0xc0230008);
        public const Int32 STATUS_NDIS_MULTICAST_FULL = unchecked((Int32)0xc0230009);
        public const Int32 STATUS_NDIS_MULTICAST_EXISTS = unchecked((Int32)0xc023000a);
        public const Int32 STATUS_NDIS_MULTICAST_NOT_FOUND = unchecked((Int32)0xc023000b);
        public const Int32 STATUS_NDIS_REQUEST_ABORTED = unchecked((Int32)0xc023000c);
        public const Int32 STATUS_NDIS_RESET_IN_PROGRESS = unchecked((Int32)0xc023000d);
        public const Int32 STATUS_NDIS_NOT_SUPPORTED = unchecked((Int32)0xc02300bb);
        public const Int32 STATUS_NDIS_INVALID_PACKET = unchecked((Int32)0xc023000f);
        public const Int32 STATUS_NDIS_ADAPTER_NOT_READY = unchecked((Int32)0xc0230011);
        public const Int32 STATUS_NDIS_INVALID_LENGTH = unchecked((Int32)0xc0230014);
        public const Int32 STATUS_NDIS_INVALID_DATA = unchecked((Int32)0xc0230015);
        public const Int32 STATUS_NDIS_BUFFER_TOO_SHORT = unchecked((Int32)0xc0230016);
        public const Int32 STATUS_NDIS_INVALID_OID = unchecked((Int32)0xc0230017);
        public const Int32 STATUS_NDIS_ADAPTER_REMOVED = unchecked((Int32)0xc0230018);
        public const Int32 STATUS_NDIS_UNSUPPORTED_MEDIA = unchecked((Int32)0xc0230019);
        public const Int32 STATUS_NDIS_GROUP_ADDRESS_IN_USE = unchecked((Int32)0xc023001a);
        public const Int32 STATUS_NDIS_FILE_NOT_FOUND = unchecked((Int32)0xc023001b);
        public const Int32 STATUS_NDIS_ERROR_READING_FILE = unchecked((Int32)0xc023001c);
        public const Int32 STATUS_NDIS_ALREADY_MAPPED = unchecked((Int32)0xc023001d);
        public const Int32 STATUS_NDIS_RESOURCE_CONFLICT = unchecked((Int32)0xc023001e);
        public const Int32 STATUS_NDIS_MEDIA_DISCONNECTED = unchecked((Int32)0xc023001f);
        public const Int32 STATUS_NDIS_INVALID_ADDRESS = unchecked((Int32)0xc0230022);
        public const Int32 STATUS_NDIS_INVALID_DEVICE_REQUEST = unchecked((Int32)0xc0230010);
        public const Int32 STATUS_NDIS_PAUSED = unchecked((Int32)0xc023002a);
        public const Int32 STATUS_NDIS_INTERFACE_NOT_FOUND = unchecked((Int32)0xc023002b);
        public const Int32 STATUS_NDIS_UNSUPPORTED_REVISION = unchecked((Int32)0xc023002c);
        public const Int32 STATUS_NDIS_INVALID_PORT = unchecked((Int32)0xc023002d);
        public const Int32 STATUS_NDIS_INVALID_PORT_STATE = unchecked((Int32)0xc023002e);
        public const Int32 STATUS_NDIS_LOW_POWER_STATE = unchecked((Int32)0xc023002f);
        public const Int32 STATUS_NDIS_REINIT_REQUIRED = unchecked((Int32)0xc0230030);
        public const Int32 STATUS_NDIS_DOT11_AUTO_CONFIG_ENABLED = unchecked((Int32)0xc0232000);
        public const Int32 STATUS_NDIS_DOT11_MEDIA_IN_USE = unchecked((Int32)0xc0232001);
        public const Int32 STATUS_NDIS_DOT11_POWER_STATE_INVALID = unchecked((Int32)0xc0232002);
        public const Int32 STATUS_NDIS_PM_WOL_PATTERN_LIST_FULL = unchecked((Int32)0xc0232003);
        public const Int32 STATUS_NDIS_PM_PROTOCOL_OFFLOAD_LIST_FULL = unchecked((Int32)0xc0232004);
        public const Int32 STATUS_NDIS_INDICATION_REQUIRED = unchecked((Int32)0x40230001);
        public const Int32 STATUS_NDIS_OFFLOAD_POLICY = unchecked((Int32)0xc023100f);
        public const Int32 STATUS_NDIS_OFFLOAD_CONNECTION_REJECTED = unchecked((Int32)0xc0231012);
        public const Int32 STATUS_NDIS_OFFLOAD_PATH_REJECTED = unchecked((Int32)0xc0231013);
        public const Int32 STATUS_TPM_ERROR_MASK = unchecked((Int32)0xc0290000);
        public const Int32 STATUS_TPM_AUTHFAIL = unchecked((Int32)0xc0290001);
        public const Int32 STATUS_TPM_BADINDEX = unchecked((Int32)0xc0290002);
        public const Int32 STATUS_TPM_BAD_PARAMETER = unchecked((Int32)0xc0290003);
        public const Int32 STATUS_TPM_AUDITFAILURE = unchecked((Int32)0xc0290004);
        public const Int32 STATUS_TPM_CLEAR_DISABLED = unchecked((Int32)0xc0290005);
        public const Int32 STATUS_TPM_DEACTIVATED = unchecked((Int32)0xc0290006);
        public const Int32 STATUS_TPM_DISABLED = unchecked((Int32)0xc0290007);
        public const Int32 STATUS_TPM_DISABLED_CMD = unchecked((Int32)0xc0290008);
        public const Int32 STATUS_TPM_FAIL = unchecked((Int32)0xc0290009);
        public const Int32 STATUS_TPM_BAD_ORDINAL = unchecked((Int32)0xc029000a);
        public const Int32 STATUS_TPM_INSTALL_DISABLED = unchecked((Int32)0xc029000b);
        public const Int32 STATUS_TPM_INVALID_KEYHANDLE = unchecked((Int32)0xc029000c);
        public const Int32 STATUS_TPM_KEYNOTFOUND = unchecked((Int32)0xc029000d);
        public const Int32 STATUS_TPM_INAPPROPRIATE_ENC = unchecked((Int32)0xc029000e);
        public const Int32 STATUS_TPM_MIGRATEFAIL = unchecked((Int32)0xc029000f);
        public const Int32 STATUS_TPM_INVALID_PCR_INFO = unchecked((Int32)0xc0290010);
        public const Int32 STATUS_TPM_NOSPACE = unchecked((Int32)0xc0290011);
        public const Int32 STATUS_TPM_NOSRK = unchecked((Int32)0xc0290012);
        public const Int32 STATUS_TPM_NOTSEALED_BLOB = unchecked((Int32)0xc0290013);
        public const Int32 STATUS_TPM_OWNER_SET = unchecked((Int32)0xc0290014);
        public const Int32 STATUS_TPM_RESOURCES = unchecked((Int32)0xc0290015);
        public const Int32 STATUS_TPM_SHORTRANDOM = unchecked((Int32)0xc0290016);
        public const Int32 STATUS_TPM_SIZE = unchecked((Int32)0xc0290017);
        public const Int32 STATUS_TPM_WRONGPCRVAL = unchecked((Int32)0xc0290018);
        public const Int32 STATUS_TPM_BAD_PARAM_SIZE = unchecked((Int32)0xc0290019);
        public const Int32 STATUS_TPM_SHA_THREAD = unchecked((Int32)0xc029001a);
        public const Int32 STATUS_TPM_SHA_ERROR = unchecked((Int32)0xc029001b);
        public const Int32 STATUS_TPM_FAILEDSELFTEST = unchecked((Int32)0xc029001c);
        public const Int32 STATUS_TPM_AUTH2FAIL = unchecked((Int32)0xc029001d);
        public const Int32 STATUS_TPM_BADTAG = unchecked((Int32)0xc029001e);
        public const Int32 STATUS_TPM_IOERROR = unchecked((Int32)0xc029001f);
        public const Int32 STATUS_TPM_ENCRYPT_ERROR = unchecked((Int32)0xc0290020);
        public const Int32 STATUS_TPM_DECRYPT_ERROR = unchecked((Int32)0xc0290021);
        public const Int32 STATUS_TPM_INVALID_AUTHHANDLE = unchecked((Int32)0xc0290022);
        public const Int32 STATUS_TPM_NO_ENDORSEMENT = unchecked((Int32)0xc0290023);
        public const Int32 STATUS_TPM_INVALID_KEYUSAGE = unchecked((Int32)0xc0290024);
        public const Int32 STATUS_TPM_WRONG_ENTITYTYPE = unchecked((Int32)0xc0290025);
        public const Int32 STATUS_TPM_INVALID_POSTINIT = unchecked((Int32)0xc0290026);
        public const Int32 STATUS_TPM_INAPPROPRIATE_SIG = unchecked((Int32)0xc0290027);
        public const Int32 STATUS_TPM_BAD_KEY_PROPERTY = unchecked((Int32)0xc0290028);
        public const Int32 STATUS_TPM_BAD_MIGRATION = unchecked((Int32)0xc0290029);
        public const Int32 STATUS_TPM_BAD_SCHEME = unchecked((Int32)0xc029002a);
        public const Int32 STATUS_TPM_BAD_DATASIZE = unchecked((Int32)0xc029002b);
        public const Int32 STATUS_TPM_BAD_MODE = unchecked((Int32)0xc029002c);
        public const Int32 STATUS_TPM_BAD_PRESENCE = unchecked((Int32)0xc029002d);
        public const Int32 STATUS_TPM_BAD_VERSION = unchecked((Int32)0xc029002e);
        public const Int32 STATUS_TPM_NO_WRAP_TRANSPORT = unchecked((Int32)0xc029002f);
        public const Int32 STATUS_TPM_AUDITFAIL_UNSUCCESSFUL = unchecked((Int32)0xc0290030);
        public const Int32 STATUS_TPM_AUDITFAIL_SUCCESSFUL = unchecked((Int32)0xc0290031);
        public const Int32 STATUS_TPM_NOTRESETABLE = unchecked((Int32)0xc0290032);
        public const Int32 STATUS_TPM_NOTLOCAL = unchecked((Int32)0xc0290033);
        public const Int32 STATUS_TPM_BAD_TYPE = unchecked((Int32)0xc0290034);
        public const Int32 STATUS_TPM_INVALID_RESOURCE = unchecked((Int32)0xc0290035);
        public const Int32 STATUS_TPM_NOTFIPS = unchecked((Int32)0xc0290036);
        public const Int32 STATUS_TPM_INVALID_FAMILY = unchecked((Int32)0xc0290037);
        public const Int32 STATUS_TPM_NO_NV_PERMISSION = unchecked((Int32)0xc0290038);
        public const Int32 STATUS_TPM_REQUIRES_SIGN = unchecked((Int32)0xc0290039);
        public const Int32 STATUS_TPM_KEY_NOTSUPPORTED = unchecked((Int32)0xc029003a);
        public const Int32 STATUS_TPM_AUTH_CONFLICT = unchecked((Int32)0xc029003b);
        public const Int32 STATUS_TPM_AREA_LOCKED = unchecked((Int32)0xc029003c);
        public const Int32 STATUS_TPM_BAD_LOCALITY = unchecked((Int32)0xc029003d);
        public const Int32 STATUS_TPM_READ_ONLY = unchecked((Int32)0xc029003e);
        public const Int32 STATUS_TPM_PER_NOWRITE = unchecked((Int32)0xc029003f);
        public const Int32 STATUS_TPM_FAMILYCOUNT = unchecked((Int32)0xc0290040);
        public const Int32 STATUS_TPM_WRITE_LOCKED = unchecked((Int32)0xc0290041);
        public const Int32 STATUS_TPM_BAD_ATTRIBUTES = unchecked((Int32)0xc0290042);
        public const Int32 STATUS_TPM_INVALID_STRUCTURE = unchecked((Int32)0xc0290043);
        public const Int32 STATUS_TPM_KEY_OWNER_CONTROL = unchecked((Int32)0xc0290044);
        public const Int32 STATUS_TPM_BAD_COUNTER = unchecked((Int32)0xc0290045);
        public const Int32 STATUS_TPM_NOT_FULLWRITE = unchecked((Int32)0xc0290046);
        public const Int32 STATUS_TPM_CONTEXT_GAP = unchecked((Int32)0xc0290047);
        public const Int32 STATUS_TPM_MAXNVWRITES = unchecked((Int32)0xc0290048);
        public const Int32 STATUS_TPM_NOOPERATOR = unchecked((Int32)0xc0290049);
        public const Int32 STATUS_TPM_RESOURCEMISSING = unchecked((Int32)0xc029004a);
        public const Int32 STATUS_TPM_DELEGATE_LOCK = unchecked((Int32)0xc029004b);
        public const Int32 STATUS_TPM_DELEGATE_FAMILY = unchecked((Int32)0xc029004c);
        public const Int32 STATUS_TPM_DELEGATE_ADMIN = unchecked((Int32)0xc029004d);
        public const Int32 STATUS_TPM_TRANSPORT_NOTEXCLUSIVE = unchecked((Int32)0xc029004e);
        public const Int32 STATUS_TPM_OWNER_CONTROL = unchecked((Int32)0xc029004f);
        public const Int32 STATUS_TPM_DAA_RESOURCES = unchecked((Int32)0xc0290050);
        public const Int32 STATUS_TPM_DAA_INPUT_DATA0 = unchecked((Int32)0xc0290051);
        public const Int32 STATUS_TPM_DAA_INPUT_DATA1 = unchecked((Int32)0xc0290052);
        public const Int32 STATUS_TPM_DAA_ISSUER_SETTINGS = unchecked((Int32)0xc0290053);
        public const Int32 STATUS_TPM_DAA_TPM_SETTINGS = unchecked((Int32)0xc0290054);
        public const Int32 STATUS_TPM_DAA_STAGE = unchecked((Int32)0xc0290055);
        public const Int32 STATUS_TPM_DAA_ISSUER_VALIDITY = unchecked((Int32)0xc0290056);
        public const Int32 STATUS_TPM_DAA_WRONG_W = unchecked((Int32)0xc0290057);
        public const Int32 STATUS_TPM_BAD_HANDLE = unchecked((Int32)0xc0290058);
        public const Int32 STATUS_TPM_BAD_DELEGATE = unchecked((Int32)0xc0290059);
        public const Int32 STATUS_TPM_BADCONTEXT = unchecked((Int32)0xc029005a);
        public const Int32 STATUS_TPM_TOOMANYCONTEXTS = unchecked((Int32)0xc029005b);
        public const Int32 STATUS_TPM_MA_TICKET_SIGNATURE = unchecked((Int32)0xc029005c);
        public const Int32 STATUS_TPM_MA_DESTINATION = unchecked((Int32)0xc029005d);
        public const Int32 STATUS_TPM_MA_SOURCE = unchecked((Int32)0xc029005e);
        public const Int32 STATUS_TPM_MA_AUTHORITY = unchecked((Int32)0xc029005f);
        public const Int32 STATUS_TPM_PERMANENTEK = unchecked((Int32)0xc0290061);
        public const Int32 STATUS_TPM_BAD_SIGNATURE = unchecked((Int32)0xc0290062);
        public const Int32 STATUS_TPM_NOCONTEXTSPACE = unchecked((Int32)0xc0290063);
        public const Int32 STATUS_TPM_COMMAND_BLOCKED = unchecked((Int32)0xc0290400);
        public const Int32 STATUS_TPM_INVALID_HANDLE = unchecked((Int32)0xc0290401);
        public const Int32 STATUS_TPM_DUPLICATE_VHANDLE = unchecked((Int32)0xc0290402);
        public const Int32 STATUS_TPM_EMBEDDED_COMMAND_BLOCKED = unchecked((Int32)0xc0290403);
        public const Int32 STATUS_TPM_EMBEDDED_COMMAND_UNSUPPORTED = unchecked((Int32)0xc0290404);
        public const Int32 STATUS_TPM_RETRY = unchecked((Int32)0xc0290800);
        public const Int32 STATUS_TPM_NEEDS_SELFTEST = unchecked((Int32)0xc0290801);
        public const Int32 STATUS_TPM_DOING_SELFTEST = unchecked((Int32)0xc0290802);
        public const Int32 STATUS_TPM_DEFEND_LOCK_RUNNING = unchecked((Int32)0xc0290803);
        public const Int32 STATUS_TPM_COMMAND_CANCELED = unchecked((Int32)0xc0291001);
        public const Int32 STATUS_TPM_TOO_MANY_CONTEXTS = unchecked((Int32)0xc0291002);
        public const Int32 STATUS_TPM_NOT_FOUND = unchecked((Int32)0xc0291003);
        public const Int32 STATUS_TPM_ACCESS_DENIED = unchecked((Int32)0xc0291004);
        public const Int32 STATUS_TPM_INSUFFICIENT_BUFFER = unchecked((Int32)0xc0291005);
        public const Int32 STATUS_TPM_PPI_FUNCTION_UNSUPPORTED = unchecked((Int32)0xc0291006);
        public const Int32 STATUS_PCP_ERROR_MASK = unchecked((Int32)0xc0292000);
        public const Int32 STATUS_PCP_DEVICE_NOT_READY = unchecked((Int32)0xc0292001);
        public const Int32 STATUS_PCP_INVALID_HANDLE = unchecked((Int32)0xc0292002);
        public const Int32 STATUS_PCP_INVALID_PARAMETER = unchecked((Int32)0xc0292003);
        public const Int32 STATUS_PCP_FLAG_NOT_SUPPORTED = unchecked((Int32)0xc0292004);
        public const Int32 STATUS_PCP_NOT_SUPPORTED = unchecked((Int32)0xc0292005);
        public const Int32 STATUS_PCP_BUFFER_TOO_SMALL = unchecked((Int32)0xc0292006);
        public const Int32 STATUS_PCP_INTERNAL_ERROR = unchecked((Int32)0xc0292007);
        public const Int32 STATUS_PCP_AUTHENTICATION_FAILED = unchecked((Int32)0xc0292008);
        public const Int32 STATUS_PCP_AUTHENTICATION_IGNORED = unchecked((Int32)0xc0292009);
        public const Int32 STATUS_PCP_POLICY_NOT_FOUND = unchecked((Int32)0xc029200a);
        public const Int32 STATUS_PCP_PROFILE_NOT_FOUND = unchecked((Int32)0xc029200b);
        public const Int32 STATUS_PCP_VALIDATION_FAILED = unchecked((Int32)0xc029200c);
        public const Int32 STATUS_PCP_DEVICE_NOT_FOUND = unchecked((Int32)0xc029200d);
        public const Int32 STATUS_RTPM_CONTEXT_CONTINUE = unchecked((Int32)0x00293000);
        public const Int32 STATUS_RTPM_CONTEXT_COMPLETE = unchecked((Int32)0x00293001);
        public const Int32 STATUS_RTPM_NO_RESULT = unchecked((Int32)0xc0293002);
        public const Int32 STATUS_RTPM_PCR_READ_INCOMPLETE = unchecked((Int32)0xc0293003);
        public const Int32 STATUS_RTPM_INVALID_CONTEXT = unchecked((Int32)0xc0293004);
        public const Int32 STATUS_RTPM_UNSUPPORTED_CMD = unchecked((Int32)0xc0293005);
        public const Int32 STATUS_HV_INVALID_HYPERCALL_CODE = unchecked((Int32)0xc0350002);
        public const Int32 STATUS_HV_INVALID_HYPERCALL_INPUT = unchecked((Int32)0xc0350003);
        public const Int32 STATUS_HV_INVALID_ALIGNMENT = unchecked((Int32)0xc0350004);
        public const Int32 STATUS_HV_INVALID_PARAMETER = unchecked((Int32)0xc0350005);
        public const Int32 STATUS_HV_ACCESS_DENIED = unchecked((Int32)0xc0350006);
        public const Int32 STATUS_HV_INVALID_PARTITION_STATE = unchecked((Int32)0xc0350007);
        public const Int32 STATUS_HV_OPERATION_DENIED = unchecked((Int32)0xc0350008);
        public const Int32 STATUS_HV_UNKNOWN_PROPERTY = unchecked((Int32)0xc0350009);
        public const Int32 STATUS_HV_PROPERTY_VALUE_OUT_OF_RANGE = unchecked((Int32)0xc035000a);
        public const Int32 STATUS_HV_INSUFFICIENT_MEMORY = unchecked((Int32)0xc035000b);
        public const Int32 STATUS_HV_PARTITION_TOO_DEEP = unchecked((Int32)0xc035000c);
        public const Int32 STATUS_HV_INVALID_PARTITION_ID = unchecked((Int32)0xc035000d);
        public const Int32 STATUS_HV_INVALID_VP_INDEX = unchecked((Int32)0xc035000e);
        public const Int32 STATUS_HV_INVALID_PORT_ID = unchecked((Int32)0xc0350011);
        public const Int32 STATUS_HV_INVALID_CONNECTION_ID = unchecked((Int32)0xc0350012);
        public const Int32 STATUS_HV_INSUFFICIENT_BUFFERS = unchecked((Int32)0xc0350013);
        public const Int32 STATUS_HV_NOT_ACKNOWLEDGED = unchecked((Int32)0xc0350014);
        public const Int32 STATUS_HV_ACKNOWLEDGED = unchecked((Int32)0xc0350016);
        public const Int32 STATUS_HV_INVALID_SAVE_RESTORE_STATE = unchecked((Int32)0xc0350017);
        public const Int32 STATUS_HV_INVALID_SYNIC_STATE = unchecked((Int32)0xc0350018);
        public const Int32 STATUS_HV_OBJECT_IN_USE = unchecked((Int32)0xc0350019);
        public const Int32 STATUS_HV_INVALID_PROXIMITY_DOMAIN_INFO = unchecked((Int32)0xc035001a);
        public const Int32 STATUS_HV_NO_DATA = unchecked((Int32)0xc035001b);
        public const Int32 STATUS_HV_INACTIVE = unchecked((Int32)0xc035001c);
        public const Int32 STATUS_HV_NO_RESOURCES = unchecked((Int32)0xc035001d);
        public const Int32 STATUS_HV_FEATURE_UNAVAILABLE = unchecked((Int32)0xc035001e);
        public const Int32 STATUS_HV_INSUFFICIENT_BUFFER = unchecked((Int32)0xc0350033);
        public const Int32 STATUS_HV_INSUFFICIENT_DEVICE_DOMAINS = unchecked((Int32)0xc0350038);
        public const Int32 STATUS_HV_CPUID_FEATURE_VALIDATION_ERROR = unchecked((Int32)0xc035003c);
        public const Int32 STATUS_HV_CPUID_XSAVE_FEATURE_VALIDATION_ERROR = unchecked((Int32)0xc035003d);
        public const Int32 STATUS_HV_PROCESSOR_STARTUP_TIMEOUT = unchecked((Int32)0xc035003e);
        public const Int32 STATUS_HV_SMX_ENABLED = unchecked((Int32)0xc035003f);
        public const Int32 STATUS_HV_INVALID_LP_INDEX = unchecked((Int32)0xc0350041);
        public const Int32 STATUS_HV_INVALID_REGISTER_VALUE = unchecked((Int32)0xc0350050);
        public const Int32 STATUS_HV_INVALID_VTL_STATE = unchecked((Int32)0xc0350051);
        public const Int32 STATUS_HV_NX_NOT_DETECTED = unchecked((Int32)0xc0350055);
        public const Int32 STATUS_HV_INVALID_DEVICE_ID = unchecked((Int32)0xc0350057);
        public const Int32 STATUS_HV_INVALID_DEVICE_STATE = unchecked((Int32)0xc0350058);
        public const Int32 STATUS_HV_PENDING_PAGE_REQUESTS = unchecked((Int32)0x00350059);
        public const Int32 STATUS_HV_PAGE_REQUEST_INVALID = unchecked((Int32)0xc0350060);
        public const Int32 STATUS_HV_NOT_PRESENT = unchecked((Int32)0xc0351000);
        public const Int32 STATUS_VID_DUPLICATE_HANDLER = unchecked((Int32)0xc0370001);
        public const Int32 STATUS_VID_TOO_MANY_HANDLERS = unchecked((Int32)0xc0370002);
        public const Int32 STATUS_VID_QUEUE_FULL = unchecked((Int32)0xc0370003);
        public const Int32 STATUS_VID_HANDLER_NOT_PRESENT = unchecked((Int32)0xc0370004);
        public const Int32 STATUS_VID_INVALID_OBJECT_NAME = unchecked((Int32)0xc0370005);
        public const Int32 STATUS_VID_PARTITION_NAME_TOO_LONG = unchecked((Int32)0xc0370006);
        public const Int32 STATUS_VID_MESSAGE_QUEUE_NAME_TOO_LONG = unchecked((Int32)0xc0370007);
        public const Int32 STATUS_VID_PARTITION_ALREADY_EXISTS = unchecked((Int32)0xc0370008);
        public const Int32 STATUS_VID_PARTITION_DOES_NOT_EXIST = unchecked((Int32)0xc0370009);
        public const Int32 STATUS_VID_PARTITION_NAME_NOT_FOUND = unchecked((Int32)0xc037000a);
        public const Int32 STATUS_VID_MESSAGE_QUEUE_ALREADY_EXISTS = unchecked((Int32)0xc037000b);
        public const Int32 STATUS_VID_EXCEEDED_MBP_ENTRY_MAP_LIMIT = unchecked((Int32)0xc037000c);
        public const Int32 STATUS_VID_MB_STILL_REFERENCED = unchecked((Int32)0xc037000d);
        public const Int32 STATUS_VID_CHILD_GPA_PAGE_SET_CORRUPTED = unchecked((Int32)0xc037000e);
        public const Int32 STATUS_VID_INVALID_NUMA_SETTINGS = unchecked((Int32)0xc037000f);
        public const Int32 STATUS_VID_INVALID_NUMA_NODE_INDEX = unchecked((Int32)0xc0370010);
        public const Int32 STATUS_VID_NOTIFICATION_QUEUE_ALREADY_ASSOCIATED = unchecked((Int32)0xc0370011);
        public const Int32 STATUS_VID_INVALID_MEMORY_BLOCK_HANDLE = unchecked((Int32)0xc0370012);
        public const Int32 STATUS_VID_PAGE_RANGE_OVERFLOW = unchecked((Int32)0xc0370013);
        public const Int32 STATUS_VID_INVALID_MESSAGE_QUEUE_HANDLE = unchecked((Int32)0xc0370014);
        public const Int32 STATUS_VID_INVALID_GPA_RANGE_HANDLE = unchecked((Int32)0xc0370015);
        public const Int32 STATUS_VID_NO_MEMORY_BLOCK_NOTIFICATION_QUEUE = unchecked((Int32)0xc0370016);
        public const Int32 STATUS_VID_MEMORY_BLOCK_LOCK_COUNT_EXCEEDED = unchecked((Int32)0xc0370017);
        public const Int32 STATUS_VID_INVALID_PPM_HANDLE = unchecked((Int32)0xc0370018);
        public const Int32 STATUS_VID_MBPS_ARE_LOCKED = unchecked((Int32)0xc0370019);
        public const Int32 STATUS_VID_MESSAGE_QUEUE_CLOSED = unchecked((Int32)0xc037001a);
        public const Int32 STATUS_VID_VIRTUAL_PROCESSOR_LIMIT_EXCEEDED = unchecked((Int32)0xc037001b);
        public const Int32 STATUS_VID_STOP_PENDING = unchecked((Int32)0xc037001c);
        public const Int32 STATUS_VID_INVALID_PROCESSOR_STATE = unchecked((Int32)0xc037001d);
        public const Int32 STATUS_VID_EXCEEDED_KM_CONTEXT_COUNT_LIMIT = unchecked((Int32)0xc037001e);
        public const Int32 STATUS_VID_KM_INTERFACE_ALREADY_INITIALIZED = unchecked((Int32)0xc037001f);
        public const Int32 STATUS_VID_MB_PROPERTY_ALREADY_SET_RESET = unchecked((Int32)0xc0370020);
        public const Int32 STATUS_VID_MMIO_RANGE_DESTROYED = unchecked((Int32)0xc0370021);
        public const Int32 STATUS_VID_INVALID_CHILD_GPA_PAGE_SET = unchecked((Int32)0xc0370022);
        public const Int32 STATUS_VID_RESERVE_PAGE_SET_IS_BEING_USED = unchecked((Int32)0xc0370023);
        public const Int32 STATUS_VID_RESERVE_PAGE_SET_TOO_SMALL = unchecked((Int32)0xc0370024);
        public const Int32 STATUS_VID_MBP_ALREADY_LOCKED_USING_RESERVED_PAGE = unchecked((Int32)0xc0370025);
        public const Int32 STATUS_VID_MBP_COUNT_EXCEEDED_LIMIT = unchecked((Int32)0xc0370026);
        public const Int32 STATUS_VID_SAVED_STATE_CORRUPT = unchecked((Int32)0xc0370027);
        public const Int32 STATUS_VID_SAVED_STATE_UNRECOGNIZED_ITEM = unchecked((Int32)0xc0370028);
        public const Int32 STATUS_VID_SAVED_STATE_INCOMPATIBLE = unchecked((Int32)0xc0370029);
        public const Int32 STATUS_VID_REMOTE_NODE_PARENT_GPA_PAGES_USED = unchecked((Int32)0x80370001);
        public const Int32 STATUS_IPSEC_BAD_SPI = unchecked((Int32)0xc0360001);
        public const Int32 STATUS_IPSEC_SA_LIFETIME_EXPIRED = unchecked((Int32)0xc0360002);
        public const Int32 STATUS_IPSEC_WRONG_SA = unchecked((Int32)0xc0360003);
        public const Int32 STATUS_IPSEC_REPLAY_CHECK_FAILED = unchecked((Int32)0xc0360004);
        public const Int32 STATUS_IPSEC_INVALID_PACKET = unchecked((Int32)0xc0360005);
        public const Int32 STATUS_IPSEC_INTEGRITY_CHECK_FAILED = unchecked((Int32)0xc0360006);
        public const Int32 STATUS_IPSEC_CLEAR_TEXT_DROP = unchecked((Int32)0xc0360007);
        public const Int32 STATUS_IPSEC_AUTH_FIREWALL_DROP = unchecked((Int32)0xc0360008);
        public const Int32 STATUS_IPSEC_THROTTLE_DROP = unchecked((Int32)0xc0360009);
        public const Int32 STATUS_IPSEC_DOSP_BLOCK = unchecked((Int32)0xc0368000);
        public const Int32 STATUS_IPSEC_DOSP_RECEIVED_MULTICAST = unchecked((Int32)0xc0368001);
        public const Int32 STATUS_IPSEC_DOSP_INVALID_PACKET = unchecked((Int32)0xc0368002);
        public const Int32 STATUS_IPSEC_DOSP_STATE_LOOKUP_FAILED = unchecked((Int32)0xc0368003);
        public const Int32 STATUS_IPSEC_DOSP_MAX_ENTRIES = unchecked((Int32)0xc0368004);
        public const Int32 STATUS_IPSEC_DOSP_KEYMOD_NOT_ALLOWED = unchecked((Int32)0xc0368005);
        public const Int32 STATUS_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES = unchecked((Int32)0xc0368006);
        public const Int32 STATUS_VOLMGR_INCOMPLETE_REGENERATION = unchecked((Int32)0x80380001);
        public const Int32 STATUS_VOLMGR_INCOMPLETE_DISK_MIGRATION = unchecked((Int32)0x80380002);
        public const Int32 STATUS_VOLMGR_DATABASE_FULL = unchecked((Int32)0xc0380001);
        public const Int32 STATUS_VOLMGR_DISK_CONFIGURATION_CORRUPTED = unchecked((Int32)0xc0380002);
        public const Int32 STATUS_VOLMGR_DISK_CONFIGURATION_NOT_IN_SYNC = unchecked((Int32)0xc0380003);
        public const Int32 STATUS_VOLMGR_PACK_CONFIG_UPDATE_FAILED = unchecked((Int32)0xc0380004);
        public const Int32 STATUS_VOLMGR_DISK_CONTAINS_NON_SIMPLE_VOLUME = unchecked((Int32)0xc0380005);
        public const Int32 STATUS_VOLMGR_DISK_DUPLICATE = unchecked((Int32)0xc0380006);
        public const Int32 STATUS_VOLMGR_DISK_DYNAMIC = unchecked((Int32)0xc0380007);
        public const Int32 STATUS_VOLMGR_DISK_ID_INVALID = unchecked((Int32)0xc0380008);
        public const Int32 STATUS_VOLMGR_DISK_INVALID = unchecked((Int32)0xc0380009);
        public const Int32 STATUS_VOLMGR_DISK_LAST_VOTER = unchecked((Int32)0xc038000a);
        public const Int32 STATUS_VOLMGR_DISK_LAYOUT_INVALID = unchecked((Int32)0xc038000b);
        public const Int32 STATUS_VOLMGR_DISK_LAYOUT_NON_BASIC_BETWEEN_BASIC_PARTITIONS = unchecked((Int32)0xc038000c);
        public const Int32 STATUS_VOLMGR_DISK_LAYOUT_NOT_CYLINDER_ALIGNED = unchecked((Int32)0xc038000d);
        public const Int32 STATUS_VOLMGR_DISK_LAYOUT_PARTITIONS_TOO_SMALL = unchecked((Int32)0xc038000e);
        public const Int32 STATUS_VOLMGR_DISK_LAYOUT_PRIMARY_BETWEEN_LOGICAL_PARTITIONS = unchecked((Int32)0xc038000f);
        public const Int32 STATUS_VOLMGR_DISK_LAYOUT_TOO_MANY_PARTITIONS = unchecked((Int32)0xc0380010);
        public const Int32 STATUS_VOLMGR_DISK_MISSING = unchecked((Int32)0xc0380011);
        public const Int32 STATUS_VOLMGR_DISK_NOT_EMPTY = unchecked((Int32)0xc0380012);
        public const Int32 STATUS_VOLMGR_DISK_NOT_ENOUGH_SPACE = unchecked((Int32)0xc0380013);
        public const Int32 STATUS_VOLMGR_DISK_REVECTORING_FAILED = unchecked((Int32)0xc0380014);
        public const Int32 STATUS_VOLMGR_DISK_SECTOR_SIZE_INVALID = unchecked((Int32)0xc0380015);
        public const Int32 STATUS_VOLMGR_DISK_SET_NOT_CONTAINED = unchecked((Int32)0xc0380016);
        public const Int32 STATUS_VOLMGR_DISK_USED_BY_MULTIPLE_MEMBERS = unchecked((Int32)0xc0380017);
        public const Int32 STATUS_VOLMGR_DISK_USED_BY_MULTIPLE_PLEXES = unchecked((Int32)0xc0380018);
        public const Int32 STATUS_VOLMGR_DYNAMIC_DISK_NOT_SUPPORTED = unchecked((Int32)0xc0380019);
        public const Int32 STATUS_VOLMGR_EXTENT_ALREADY_USED = unchecked((Int32)0xc038001a);
        public const Int32 STATUS_VOLMGR_EXTENT_NOT_CONTIGUOUS = unchecked((Int32)0xc038001b);
        public const Int32 STATUS_VOLMGR_EXTENT_NOT_IN_PUBLIC_REGION = unchecked((Int32)0xc038001c);
        public const Int32 STATUS_VOLMGR_EXTENT_NOT_SECTOR_ALIGNED = unchecked((Int32)0xc038001d);
        public const Int32 STATUS_VOLMGR_EXTENT_OVERLAPS_EBR_PARTITION = unchecked((Int32)0xc038001e);
        public const Int32 STATUS_VOLMGR_EXTENT_VOLUME_LENGTHS_DO_NOT_MATCH = unchecked((Int32)0xc038001f);
        public const Int32 STATUS_VOLMGR_FAULT_TOLERANT_NOT_SUPPORTED = unchecked((Int32)0xc0380020);
        public const Int32 STATUS_VOLMGR_INTERLEAVE_LENGTH_INVALID = unchecked((Int32)0xc0380021);
        public const Int32 STATUS_VOLMGR_MAXIMUM_REGISTERED_USERS = unchecked((Int32)0xc0380022);
        public const Int32 STATUS_VOLMGR_MEMBER_IN_SYNC = unchecked((Int32)0xc0380023);
        public const Int32 STATUS_VOLMGR_MEMBER_INDEX_DUPLICATE = unchecked((Int32)0xc0380024);
        public const Int32 STATUS_VOLMGR_MEMBER_INDEX_INVALID = unchecked((Int32)0xc0380025);
        public const Int32 STATUS_VOLMGR_MEMBER_MISSING = unchecked((Int32)0xc0380026);
        public const Int32 STATUS_VOLMGR_MEMBER_NOT_DETACHED = unchecked((Int32)0xc0380027);
        public const Int32 STATUS_VOLMGR_MEMBER_REGENERATING = unchecked((Int32)0xc0380028);
        public const Int32 STATUS_VOLMGR_ALL_DISKS_FAILED = unchecked((Int32)0xc0380029);
        public const Int32 STATUS_VOLMGR_NO_REGISTERED_USERS = unchecked((Int32)0xc038002a);
        public const Int32 STATUS_VOLMGR_NO_SUCH_USER = unchecked((Int32)0xc038002b);
        public const Int32 STATUS_VOLMGR_NOTIFICATION_RESET = unchecked((Int32)0xc038002c);
        public const Int32 STATUS_VOLMGR_NUMBER_OF_MEMBERS_INVALID = unchecked((Int32)0xc038002d);
        public const Int32 STATUS_VOLMGR_NUMBER_OF_PLEXES_INVALID = unchecked((Int32)0xc038002e);
        public const Int32 STATUS_VOLMGR_PACK_DUPLICATE = unchecked((Int32)0xc038002f);
        public const Int32 STATUS_VOLMGR_PACK_ID_INVALID = unchecked((Int32)0xc0380030);
        public const Int32 STATUS_VOLMGR_PACK_INVALID = unchecked((Int32)0xc0380031);
        public const Int32 STATUS_VOLMGR_PACK_NAME_INVALID = unchecked((Int32)0xc0380032);
        public const Int32 STATUS_VOLMGR_PACK_OFFLINE = unchecked((Int32)0xc0380033);
        public const Int32 STATUS_VOLMGR_PACK_HAS_QUORUM = unchecked((Int32)0xc0380034);
        public const Int32 STATUS_VOLMGR_PACK_WITHOUT_QUORUM = unchecked((Int32)0xc0380035);
        public const Int32 STATUS_VOLMGR_PARTITION_STYLE_INVALID = unchecked((Int32)0xc0380036);
        public const Int32 STATUS_VOLMGR_PARTITION_UPDATE_FAILED = unchecked((Int32)0xc0380037);
        public const Int32 STATUS_VOLMGR_PLEX_IN_SYNC = unchecked((Int32)0xc0380038);
        public const Int32 STATUS_VOLMGR_PLEX_INDEX_DUPLICATE = unchecked((Int32)0xc0380039);
        public const Int32 STATUS_VOLMGR_PLEX_INDEX_INVALID = unchecked((Int32)0xc038003a);
        public const Int32 STATUS_VOLMGR_PLEX_LAST_ACTIVE = unchecked((Int32)0xc038003b);
        public const Int32 STATUS_VOLMGR_PLEX_MISSING = unchecked((Int32)0xc038003c);
        public const Int32 STATUS_VOLMGR_PLEX_REGENERATING = unchecked((Int32)0xc038003d);
        public const Int32 STATUS_VOLMGR_PLEX_TYPE_INVALID = unchecked((Int32)0xc038003e);
        public const Int32 STATUS_VOLMGR_PLEX_NOT_RAID5 = unchecked((Int32)0xc038003f);
        public const Int32 STATUS_VOLMGR_PLEX_NOT_SIMPLE = unchecked((Int32)0xc0380040);
        public const Int32 STATUS_VOLMGR_STRUCTURE_SIZE_INVALID = unchecked((Int32)0xc0380041);
        public const Int32 STATUS_VOLMGR_TOO_MANY_NOTIFICATION_REQUESTS = unchecked((Int32)0xc0380042);
        public const Int32 STATUS_VOLMGR_TRANSACTION_IN_PROGRESS = unchecked((Int32)0xc0380043);
        public const Int32 STATUS_VOLMGR_UNEXPECTED_DISK_LAYOUT_CHANGE = unchecked((Int32)0xc0380044);
        public const Int32 STATUS_VOLMGR_VOLUME_CONTAINS_MISSING_DISK = unchecked((Int32)0xc0380045);
        public const Int32 STATUS_VOLMGR_VOLUME_ID_INVALID = unchecked((Int32)0xc0380046);
        public const Int32 STATUS_VOLMGR_VOLUME_LENGTH_INVALID = unchecked((Int32)0xc0380047);
        public const Int32 STATUS_VOLMGR_VOLUME_LENGTH_NOT_SECTOR_SIZE_MULTIPLE = unchecked((Int32)0xc0380048);
        public const Int32 STATUS_VOLMGR_VOLUME_NOT_MIRRORED = unchecked((Int32)0xc0380049);
        public const Int32 STATUS_VOLMGR_VOLUME_NOT_RETAINED = unchecked((Int32)0xc038004a);
        public const Int32 STATUS_VOLMGR_VOLUME_OFFLINE = unchecked((Int32)0xc038004b);
        public const Int32 STATUS_VOLMGR_VOLUME_RETAINED = unchecked((Int32)0xc038004c);
        public const Int32 STATUS_VOLMGR_NUMBER_OF_EXTENTS_INVALID = unchecked((Int32)0xc038004d);
        public const Int32 STATUS_VOLMGR_DIFFERENT_SECTOR_SIZE = unchecked((Int32)0xc038004e);
        public const Int32 STATUS_VOLMGR_BAD_BOOT_DISK = unchecked((Int32)0xc038004f);
        public const Int32 STATUS_VOLMGR_PACK_CONFIG_OFFLINE = unchecked((Int32)0xc0380050);
        public const Int32 STATUS_VOLMGR_PACK_CONFIG_ONLINE = unchecked((Int32)0xc0380051);
        public const Int32 STATUS_VOLMGR_NOT_PRIMARY_PACK = unchecked((Int32)0xc0380052);
        public const Int32 STATUS_VOLMGR_PACK_LOG_UPDATE_FAILED = unchecked((Int32)0xc0380053);
        public const Int32 STATUS_VOLMGR_NUMBER_OF_DISKS_IN_PLEX_INVALID = unchecked((Int32)0xc0380054);
        public const Int32 STATUS_VOLMGR_NUMBER_OF_DISKS_IN_MEMBER_INVALID = unchecked((Int32)0xc0380055);
        public const Int32 STATUS_VOLMGR_VOLUME_MIRRORED = unchecked((Int32)0xc0380056);
        public const Int32 STATUS_VOLMGR_PLEX_NOT_SIMPLE_SPANNED = unchecked((Int32)0xc0380057);
        public const Int32 STATUS_VOLMGR_NO_VALID_LOG_COPIES = unchecked((Int32)0xc0380058);
        public const Int32 STATUS_VOLMGR_PRIMARY_PACK_PRESENT = unchecked((Int32)0xc0380059);
        public const Int32 STATUS_VOLMGR_NUMBER_OF_DISKS_INVALID = unchecked((Int32)0xc038005a);
        public const Int32 STATUS_VOLMGR_MIRROR_NOT_SUPPORTED = unchecked((Int32)0xc038005b);
        public const Int32 STATUS_VOLMGR_RAID5_NOT_SUPPORTED = unchecked((Int32)0xc038005c);
        public const Int32 STATUS_BCD_NOT_ALL_ENTRIES_IMPORTED = unchecked((Int32)0x80390001);
        public const Int32 STATUS_BCD_TOO_MANY_ELEMENTS = unchecked((Int32)0xc0390002);
        public const Int32 STATUS_BCD_NOT_ALL_ENTRIES_SYNCHRONIZED = unchecked((Int32)0x80390003);
        public const Int32 STATUS_VHD_DRIVE_FOOTER_MISSING = unchecked((Int32)0xc03a0001);
        public const Int32 STATUS_VHD_DRIVE_FOOTER_CHECKSUM_MISMATCH = unchecked((Int32)0xc03a0002);
        public const Int32 STATUS_VHD_DRIVE_FOOTER_CORRUPT = unchecked((Int32)0xc03a0003);
        public const Int32 STATUS_VHD_FORMAT_UNKNOWN = unchecked((Int32)0xc03a0004);
        public const Int32 STATUS_VHD_FORMAT_UNSUPPORTED_VERSION = unchecked((Int32)0xc03a0005);
        public const Int32 STATUS_VHD_SPARSE_HEADER_CHECKSUM_MISMATCH = unchecked((Int32)0xc03a0006);
        public const Int32 STATUS_VHD_SPARSE_HEADER_UNSUPPORTED_VERSION = unchecked((Int32)0xc03a0007);
        public const Int32 STATUS_VHD_SPARSE_HEADER_CORRUPT = unchecked((Int32)0xc03a0008);
        public const Int32 STATUS_VHD_BLOCK_ALLOCATION_FAILURE = unchecked((Int32)0xc03a0009);
        public const Int32 STATUS_VHD_BLOCK_ALLOCATION_TABLE_CORRUPT = unchecked((Int32)0xc03a000a);
        public const Int32 STATUS_VHD_INVALID_BLOCK_SIZE = unchecked((Int32)0xc03a000b);
        public const Int32 STATUS_VHD_BITMAP_MISMATCH = unchecked((Int32)0xc03a000c);
        public const Int32 STATUS_VHD_PARENT_VHD_NOT_FOUND = unchecked((Int32)0xc03a000d);
        public const Int32 STATUS_VHD_CHILD_PARENT_ID_MISMATCH = unchecked((Int32)0xc03a000e);
        public const Int32 STATUS_VHD_CHILD_PARENT_TIMESTAMP_MISMATCH = unchecked((Int32)0xc03a000f);
        public const Int32 STATUS_VHD_METADATA_READ_FAILURE = unchecked((Int32)0xc03a0010);
        public const Int32 STATUS_VHD_METADATA_WRITE_FAILURE = unchecked((Int32)0xc03a0011);
        public const Int32 STATUS_VHD_INVALID_SIZE = unchecked((Int32)0xc03a0012);
        public const Int32 STATUS_VHD_INVALID_FILE_SIZE = unchecked((Int32)0xc03a0013);
        public const Int32 STATUS_VIRTDISK_PROVIDER_NOT_FOUND = unchecked((Int32)0xc03a0014);
        public const Int32 STATUS_VIRTDISK_NOT_VIRTUAL_DISK = unchecked((Int32)0xc03a0015);
        public const Int32 STATUS_VHD_PARENT_VHD_ACCESS_DENIED = unchecked((Int32)0xc03a0016);
        public const Int32 STATUS_VHD_CHILD_PARENT_SIZE_MISMATCH = unchecked((Int32)0xc03a0017);
        public const Int32 STATUS_VHD_DIFFERENCING_CHAIN_CYCLE_DETECTED = unchecked((Int32)0xc03a0018);
        public const Int32 STATUS_VHD_DIFFERENCING_CHAIN_ERROR_IN_PARENT = unchecked((Int32)0xc03a0019);
        public const Int32 STATUS_VIRTUAL_DISK_LIMITATION = unchecked((Int32)0xc03a001a);
        public const Int32 STATUS_VHD_INVALID_TYPE = unchecked((Int32)0xc03a001b);
        public const Int32 STATUS_VHD_INVALID_STATE = unchecked((Int32)0xc03a001c);
        public const Int32 STATUS_VIRTDISK_UNSUPPORTED_DISK_SECTOR_SIZE = unchecked((Int32)0xc03a001d);
        public const Int32 STATUS_VIRTDISK_DISK_ALREADY_OWNED = unchecked((Int32)0xc03a001e);
        public const Int32 STATUS_VIRTDISK_DISK_ONLINE_AND_WRITABLE = unchecked((Int32)0xc03a001f);
        public const Int32 STATUS_CTLOG_TRACKING_NOT_INITIALIZED = unchecked((Int32)0xc03a0020);
        public const Int32 STATUS_CTLOG_LOGFILE_SIZE_EXCEEDED_MAXSIZE = unchecked((Int32)0xc03a0021);
        public const Int32 STATUS_CTLOG_VHD_CHANGED_OFFLINE = unchecked((Int32)0xc03a0022);
        public const Int32 STATUS_CTLOG_INVALID_TRACKING_STATE = unchecked((Int32)0xc03a0023);
        public const Int32 STATUS_CTLOG_INCONSISTENT_TRACKING_FILE = unchecked((Int32)0xc03a0024);
        public const Int32 STATUS_VHD_METADATA_FULL = unchecked((Int32)0xc03a0028);
        public const Int32 STATUS_VHD_INVALID_CHANGE_TRACKING_ID = unchecked((Int32)0xc03a0029);
        public const Int32 STATUS_VHD_CHANGE_TRACKING_DISABLED = unchecked((Int32)0xc03a002a);
        public const Int32 STATUS_VHD_MISSING_CHANGE_TRACKING_INFORMATION = unchecked((Int32)0xc03a0030);
        public const Int32 STATUS_VHD_RESIZE_WOULD_TRUNCATE_DATA = unchecked((Int32)0xc03a0031);
        public const Int32 STATUS_VHD_COULD_NOT_COMPUTE_MINIMUM_VIRTUAL_SIZE = unchecked((Int32)0xc03a0032);
        public const Int32 STATUS_VHD_ALREADY_AT_OR_BELOW_MINIMUM_VIRTUAL_SIZE = unchecked((Int32)0xc03a0033);
        public const Int32 STATUS_QUERY_STORAGE_ERROR = unchecked((Int32)0x803a0001);
        public const Int32 STATUS_RKF_KEY_NOT_FOUND = unchecked((Int32)0xc0400001);
        public const Int32 STATUS_RKF_DUPLICATE_KEY = unchecked((Int32)0xc0400002);
        public const Int32 STATUS_RKF_BLOB_FULL = unchecked((Int32)0xc0400003);
        public const Int32 STATUS_RKF_STORE_FULL = unchecked((Int32)0xc0400004);
        public const Int32 STATUS_RKF_FILE_BLOCKED = unchecked((Int32)0xc0400005);
        public const Int32 STATUS_RKF_ACTIVE_KEY = unchecked((Int32)0xc0400006);
        public const Int32 STATUS_RDBSS_RESTART_OPERATION = unchecked((Int32)0xc0410001);
        public const Int32 STATUS_RDBSS_CONTINUE_OPERATION = unchecked((Int32)0xc0410002);
        public const Int32 STATUS_RDBSS_POST_OPERATION = unchecked((Int32)0xc0410003);
        public const Int32 STATUS_BTH_ATT_INVALID_HANDLE = unchecked((Int32)0xc0420001);
        public const Int32 STATUS_BTH_ATT_READ_NOT_PERMITTED = unchecked((Int32)0xc0420002);
        public const Int32 STATUS_BTH_ATT_WRITE_NOT_PERMITTED = unchecked((Int32)0xc0420003);
        public const Int32 STATUS_BTH_ATT_INVALID_PDU = unchecked((Int32)0xc0420004);
        public const Int32 STATUS_BTH_ATT_INSUFFICIENT_AUTHENTICATION = unchecked((Int32)0xc0420005);
        public const Int32 STATUS_BTH_ATT_REQUEST_NOT_SUPPORTED = unchecked((Int32)0xc0420006);
        public const Int32 STATUS_BTH_ATT_INVALID_OFFSET = unchecked((Int32)0xc0420007);
        public const Int32 STATUS_BTH_ATT_INSUFFICIENT_AUTHORIZATION = unchecked((Int32)0xc0420008);
        public const Int32 STATUS_BTH_ATT_PREPARE_QUEUE_FULL = unchecked((Int32)0xc0420009);
        public const Int32 STATUS_BTH_ATT_ATTRIBUTE_NOT_FOUND = unchecked((Int32)0xc042000a);
        public const Int32 STATUS_BTH_ATT_ATTRIBUTE_NOT_LONG = unchecked((Int32)0xc042000b);
        public const Int32 STATUS_BTH_ATT_INSUFFICIENT_ENCRYPTION_KEY_SIZE = unchecked((Int32)0xc042000c);
        public const Int32 STATUS_BTH_ATT_INVALID_ATTRIBUTE_VALUE_LENGTH = unchecked((Int32)0xc042000d);
        public const Int32 STATUS_BTH_ATT_UNLIKELY = unchecked((Int32)0xc042000e);
        public const Int32 STATUS_BTH_ATT_INSUFFICIENT_ENCRYPTION = unchecked((Int32)0xc042000f);
        public const Int32 STATUS_BTH_ATT_UNSUPPORTED_GROUP_TYPE = unchecked((Int32)0xc0420010);
        public const Int32 STATUS_BTH_ATT_INSUFFICIENT_RESOURCES = unchecked((Int32)0xc0420011);
        public const Int32 STATUS_BTH_ATT_UNKNOWN_ERROR = unchecked((Int32)0xc0421000);
        public const Int32 STATUS_SECUREBOOT_ROLLBACK_DETECTED = unchecked((Int32)0xc0430001);
        public const Int32 STATUS_SECUREBOOT_POLICY_VIOLATION = unchecked((Int32)0xc0430002);
        public const Int32 STATUS_SECUREBOOT_INVALID_POLICY = unchecked((Int32)0xc0430003);
        public const Int32 STATUS_SECUREBOOT_POLICY_PUBLISHER_NOT_FOUND = unchecked((Int32)0xc0430004);
        public const Int32 STATUS_SECUREBOOT_POLICY_NOT_SIGNED = unchecked((Int32)0xc0430005);
        public const Int32 STATUS_SECUREBOOT_NOT_ENABLED = unchecked((Int32)0x80430006);
        public const Int32 STATUS_SECUREBOOT_FILE_REPLACED = unchecked((Int32)0xc0430007);
        public const Int32 STATUS_SYSTEM_INTEGRITY_ROLLBACK_DETECTED = unchecked((Int32)0xc0e90001);
        public const Int32 STATUS_SYSTEM_INTEGRITY_POLICY_VIOLATION = unchecked((Int32)0xc0e90002);
        public const Int32 STATUS_SYSTEM_INTEGRITY_INVALID_POLICY = unchecked((Int32)0xc0e90003);
        public const Int32 STATUS_SYSTEM_INTEGRITY_POLICY_NOT_SIGNED = unchecked((Int32)0xc0e90004);
        public const Int32 STATUS_NO_APPLICABLE_APP_LICENSES_FOUND = unchecked((Int32)0xc0ea0001);
        public const Int32 STATUS_CLIP_LICENSE_NOT_FOUND = unchecked((Int32)0xc0ea0002);
        public const Int32 STATUS_CLIP_DEVICE_LICENSE_MISSING = unchecked((Int32)0xc0ea0003);
        public const Int32 STATUS_CLIP_LICENSE_INVALID_SIGNATURE = unchecked((Int32)0xc0ea0004);
        public const Int32 STATUS_CLIP_KEYHOLDER_LICENSE_MISSING_OR_INVALID = unchecked((Int32)0xc0ea0005);
        public const Int32 STATUS_CLIP_LICENSE_EXPIRED = unchecked((Int32)0xc0ea0006);
        public const Int32 STATUS_CLIP_LICENSE_SIGNED_BY_UNKNOWN_SOURCE = unchecked((Int32)0xc0ea0007);
        public const Int32 STATUS_CLIP_LICENSE_NOT_SIGNED = unchecked((Int32)0xc0ea0008);
        public const Int32 STATUS_CLIP_LICENSE_HARDWARE_ID_OUT_OF_TOLERANCE = unchecked((Int32)0xc0ea0009);
        public const Int32 STATUS_CLIP_LICENSE_DEVICE_ID_MISMATCH = unchecked((Int32)0xc0ea000a);
        public const Int32 STATUS_AUDIO_ENGINE_NODE_NOT_FOUND = unchecked((Int32)0xc0440001);
        public const Int32 STATUS_HDAUDIO_EMPTY_CONNECTION_LIST = unchecked((Int32)0xc0440002);
        public const Int32 STATUS_HDAUDIO_CONNECTION_LIST_NOT_SUPPORTED = unchecked((Int32)0xc0440003);
        public const Int32 STATUS_HDAUDIO_NO_LOGICAL_DEVICES_CREATED = unchecked((Int32)0xc0440004);
        public const Int32 STATUS_HDAUDIO_NULL_LINKED_LIST_ENTRY = unchecked((Int32)0xc0440005);
        public const Int32 STATUS_SPACES_REPAIRED = unchecked((Int32)0x00e70000);
        public const Int32 STATUS_SPACES_PAUSE = unchecked((Int32)0x00e70001);
        public const Int32 STATUS_SPACES_COMPLETE = unchecked((Int32)0x00e70002);
        public const Int32 STATUS_SPACES_FAULT_DOMAIN_TYPE_INVALID = unchecked((Int32)0xc0e70001);
        public const Int32 STATUS_SPACES_RESILIENCY_TYPE_INVALID = unchecked((Int32)0xc0e70003);
        public const Int32 STATUS_SPACES_DRIVE_SECTOR_SIZE_INVALID = unchecked((Int32)0xc0e70004);
        public const Int32 STATUS_SPACES_DRIVE_REDUNDANCY_INVALID = unchecked((Int32)0xc0e70006);
        public const Int32 STATUS_SPACES_NUMBER_OF_DATA_COPIES_INVALID = unchecked((Int32)0xc0e70007);
        public const Int32 STATUS_SPACES_INTERLEAVE_LENGTH_INVALID = unchecked((Int32)0xc0e70009);
        public const Int32 STATUS_SPACES_NUMBER_OF_COLUMNS_INVALID = unchecked((Int32)0xc0e7000a);
        public const Int32 STATUS_SPACES_NOT_ENOUGH_DRIVES = unchecked((Int32)0xc0e7000b);
        public const Int32 STATUS_SPACES_EXTENDED_ERROR = unchecked((Int32)0xc0e7000c);
        public const Int32 STATUS_SPACES_PROVISIONING_TYPE_INVALID = unchecked((Int32)0xc0e7000d);
        public const Int32 STATUS_SPACES_ALLOCATION_SIZE_INVALID = unchecked((Int32)0xc0e7000e);
        public const Int32 STATUS_SPACES_ENCLOSURE_AWARE_INVALID = unchecked((Int32)0xc0e7000f);
        public const Int32 STATUS_SPACES_WRITE_CACHE_SIZE_INVALID = unchecked((Int32)0xc0e70010);
        public const Int32 STATUS_SPACES_NUMBER_OF_GROUPS_INVALID = unchecked((Int32)0xc0e70011);
        public const Int32 STATUS_SPACES_DRIVE_OPERATIONAL_STATE_INVALID = unchecked((Int32)0xc0e70012);
        public const Int32 STATUS_SPACES_UPDATE_COLUMN_STATE = unchecked((Int32)0xc0e70013);
        public const Int32 STATUS_SPACES_MAP_REQUIRED = unchecked((Int32)0xc0e70014);
        public const Int32 STATUS_SPACES_UNSUPPORTED_VERSION = unchecked((Int32)0xc0e70015);
        public const Int32 STATUS_SPACES_CORRUPT_METADATA = unchecked((Int32)0xc0e70016);
        public const Int32 STATUS_SPACES_DRT_FULL = unchecked((Int32)0xc0e70017);
        public const Int32 STATUS_SPACES_INCONSISTENCY = unchecked((Int32)0xc0e70018);
        public const Int32 STATUS_SPACES_LOG_NOT_READY = unchecked((Int32)0xc0e70019);
        public const Int32 STATUS_SPACES_NO_REDUNDANCY = unchecked((Int32)0xc0e7001a);
        public const Int32 STATUS_SPACES_DRIVE_NOT_READY = unchecked((Int32)0xc0e7001b);
        public const Int32 STATUS_VOLSNAP_BOOTFILE_NOT_VALID = unchecked((Int32)0xc0500003);
        public const Int32 STATUS_IO_PREEMPTED = unchecked((Int32)0xc0510001);
        public const Int32 STATUS_SVHDX_ERROR_STORED = unchecked((Int32)0xc05c0000);
        public const Int32 STATUS_SVHDX_ERROR_NOT_AVAILABLE = unchecked((Int32)0xc05cff00);
        public const Int32 STATUS_SVHDX_UNIT_ATTENTION_AVAILABLE = unchecked((Int32)0xc05cff01);
        public const Int32 STATUS_SVHDX_UNIT_ATTENTION_CAPACITY_DATA_CHANGED = unchecked((Int32)0xc05cff02);
        public const Int32 STATUS_SVHDX_UNIT_ATTENTION_RESERVATIONS_PREEMPTED = unchecked((Int32)0xc05cff03);
        public const Int32 STATUS_SVHDX_UNIT_ATTENTION_RESERVATIONS_RELEASED = unchecked((Int32)0xc05cff04);
        public const Int32 STATUS_SVHDX_UNIT_ATTENTION_REGISTRATIONS_PREEMPTED = unchecked((Int32)0xc05cff05);
        public const Int32 STATUS_SVHDX_UNIT_ATTENTION_OPERATING_DEFINITION_CHANGED = unchecked((Int32)0xc05cff06);
        public const Int32 STATUS_SVHDX_RESERVATION_CONFLICT = unchecked((Int32)0xc05cff07);
        public const Int32 STATUS_SVHDX_WRONG_FILE_TYPE = unchecked((Int32)0xc05cff08);
        public const Int32 STATUS_SVHDX_VERSION_MISMATCH = unchecked((Int32)0xc05cff09);
        public const Int32 STATUS_VHD_SHARED = unchecked((Int32)0xc05cff0a);
        public const Int32 STATUS_SVHDX_NO_INITIATOR = unchecked((Int32)0xc05cff0b);
        public const Int32 STATUS_VHDSET_BACKING_STORAGE_NOT_FOUND = unchecked((Int32)0xc05cff0c);
        public const Int32 STATUS_SMB_NO_PREAUTH_INTEGRITY_HASH_OVERLAP = unchecked((Int32)0xc05d0000);
        public const Int32 STATUS_SMB_BAD_CLUSTER_DIALECT = unchecked((Int32)0xc05d0001);
        public const Int32 STATUS_SMB_GUEST_LOGON_BLOCKED = unchecked((Int32)0xc05d0002);
        public const Int32 STATUS_SECCORE_INVALID_COMMAND = unchecked((Int32)0xc0e80000);
        public const Int32 STATUS_VSM_NOT_INITIALIZED = unchecked((Int32)0xc0450000);
        public const Int32 STATUS_VSM_DMA_PROTECTION_NOT_IN_USE = unchecked((Int32)0xc0450001);
    }

}
